/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control;

import java.util.AbstractList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpinnerIntegerList
extends AbstractList<Integer> {
    private int from;
    private int size;
    private int step;

    public SpinnerIntegerList() {
        this(-1073741823, 0x3FFFFFFF, 1);
    }

    public SpinnerIntegerList(int from, int to) {
        this(from, to, from > to ? -1 : 1);
    }

    public SpinnerIntegerList(int from, int to, int step) {
        this.from = from;
        this.size = (to - from) / step + 1;
        if (this.size < 0) {
            throw new IllegalArgumentException("This results in a negative size: " + from + ", " + to + "," + step);
        }
        this.step = step;
    }

    @Override
    public Integer get(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index cannot be < 0: " + index);
        }
        int lValue = this.from + index * this.step;
        return lValue;
    }

    @Override
    public int indexOf(Object o) {
        int lValue = (Integer)o;
        int lIndex = (lValue - this.from) / this.step;
        return lIndex;
    }

    @Override
    public int size() {
        return this.size;
    }
}

