/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import jfxtras.labs.internal.scene.control.behavior.SimpleBatteryBehavior;
import jfxtras.labs.scene.control.gauge.GradientLookup;
import jfxtras.labs.scene.control.gauge.SimpleBattery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBatterySkin
extends SkinBase<SimpleBattery, SimpleBatteryBehavior> {
    private SimpleBattery control;
    private boolean isDirty;
    private boolean initialized;
    private Group background;
    private Group main;
    private Group foreground;
    private Path plug;
    private Path flashFrame;
    private Path flashMain;
    private Rectangle fluid;
    private GradientLookup lookup;
    private Color currentLevelColor;

    public SimpleBatterySkin(SimpleBattery CONTROL) {
        super((Control)CONTROL, (BehaviorBase)new SimpleBatteryBehavior(CONTROL));
        this.control = CONTROL;
        this.initialized = false;
        this.isDirty = false;
        this.background = new Group();
        this.main = new Group();
        this.foreground = new Group();
        this.plug = new Path();
        this.flashFrame = new Path();
        this.flashMain = new Path();
        this.fluid = new Rectangle();
        this.lookup = new GradientLookup(this.control.getLevelColors());
        this.currentLevelColor = Color.RED;
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 | this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(128.0, 128.0);
        }
        this.control.prefWidthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                SimpleBatterySkin.this.isDirty = true;
            }
        });
        this.control.prefHeightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                SimpleBatterySkin.this.isDirty = true;
            }
        });
        this.registerChangeListener((ObservableValue)this.control.chargingProperty(), "CHARGING");
        this.registerChangeListener((ObservableValue)this.control.chargeIndicatorProperty(), "CHARGE_INDICATOR");
        this.registerChangeListener((ObservableValue)this.control.chargingLevelProperty(), "CHARGE_LEVEL");
        this.registerChangeListener((ObservableValue)this.control.levelColorsProperty(), "LEVEL_COLORS");
        this.initialized = true;
        this.paint();
    }

    public final void paint() {
        if (!this.initialized) {
            this.init();
        }
        this.getChildren().clear();
        this.drawBackground();
        this.drawMain();
        this.drawForeground();
        this.getChildren().addAll((Object[])new Node[]{this.background, this.main, this.foreground});
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if (PROPERTY == "CHARGING") {
            this.plug.setVisible(this.control.isCharging());
            this.flashFrame.setVisible(this.control.isCharging());
            this.flashMain.setVisible(this.control.isCharging());
        } else if (PROPERTY == "CHARGE_INDICATOR") {
            if (this.control.getChargeIndicator() == SimpleBattery.ChargeIndicator.PLUG) {
                this.plug.setOpacity(1.0);
                this.flashFrame.setOpacity(0.0);
                this.flashMain.setOpacity(0.0);
            } else {
                this.plug.setOpacity(0.0);
                this.flashFrame.setOpacity(1.0);
                this.flashMain.setOpacity(1.0);
            }
        } else if (PROPERTY == "CHARGE_LEVEL") {
            this.currentLevelColor = this.lookup.getColorAt(this.control.getChargingLevel());
            this.updateFluid();
        } else if (PROPERTY == "LEVEL_COLORS") {
            this.lookup = new GradientLookup(this.control.getLevelColors());
            this.updateFluid();
        }
    }

    public void layoutChildren() {
        if (this.isDirty) {
            this.paint();
            this.isDirty = false;
        }
        super.layoutChildren();
    }

    public final SimpleBattery getSkinnable() {
        return this.control;
    }

    public final void dispose() {
        this.control = null;
    }

    protected double computePrefWidth(double PREF_WIDTH) {
        double prefWidth = 128.0;
        if (PREF_WIDTH != -1.0) {
            prefWidth = Math.max(0.0, PREF_WIDTH - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefWidth);
    }

    protected double computePrefHeight(double PREF_HEIGHT) {
        double prefHeight = 128.0;
        if (PREF_HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, PREF_HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefWidth(prefHeight);
    }

    public final void drawBackground() {
        double SIZE;
        double WIDTH = SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double HEIGHT = SIZE;
        this.background.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.background.getChildren().add((Object)IBOUNDS);
        Path BODY = new Path();
        BODY.setFillRule(FillRule.EVEN_ODD);
        BODY.getElements().add((Object)new MoveTo(0.0703125 * WIDTH, 0.3203125 * HEIGHT));
        BODY.getElements().add((Object)new CubicCurveTo(0.0703125 * WIDTH, 0.296875 * HEIGHT, 0.0703125 * WIDTH, 0.296875 * HEIGHT, 0.09375 * WIDTH, 0.296875 * HEIGHT));
        BODY.getElements().add((Object)new CubicCurveTo(0.09375 * WIDTH, 0.296875 * HEIGHT, 0.8359375 * WIDTH, 0.296875 * HEIGHT, 0.8359375 * WIDTH, 0.296875 * HEIGHT));
        BODY.getElements().add((Object)new CubicCurveTo(0.859375 * WIDTH, 0.296875 * HEIGHT, 0.859375 * WIDTH, 0.296875 * HEIGHT, 0.859375 * WIDTH, 0.3203125 * HEIGHT));
        BODY.getElements().add((Object)new CubicCurveTo(0.859375 * WIDTH, 0.3203125 * HEIGHT, 0.859375 * WIDTH, 0.6796875 * HEIGHT, 0.859375 * WIDTH, 0.6796875 * HEIGHT));
        BODY.getElements().add((Object)new CubicCurveTo(0.859375 * WIDTH, 0.703125 * HEIGHT, 0.859375 * WIDTH, 0.703125 * HEIGHT, 0.8359375 * WIDTH, 0.703125 * HEIGHT));
        BODY.getElements().add((Object)new CubicCurveTo(0.8359375 * WIDTH, 0.703125 * HEIGHT, 0.09375 * WIDTH, 0.703125 * HEIGHT, 0.09375 * WIDTH, 0.703125 * HEIGHT));
        BODY.getElements().add((Object)new CubicCurveTo(0.0703125 * WIDTH, 0.703125 * HEIGHT, 0.0703125 * WIDTH, 0.703125 * HEIGHT, 0.0703125 * WIDTH, 0.6796875 * HEIGHT));
        BODY.getElements().add((Object)new CubicCurveTo(0.0703125 * WIDTH, 0.6796875 * HEIGHT, 0.0703125 * WIDTH, 0.3203125 * HEIGHT, 0.0703125 * WIDTH, 0.3203125 * HEIGHT));
        BODY.getElements().add((Object)new ClosePath());
        BODY.getElements().add((Object)new MoveTo(0.0546875 * WIDTH, 0.3203125 * HEIGHT));
        BODY.getElements().add((Object)new CubicCurveTo(0.0546875 * WIDTH, 0.3203125 * HEIGHT, 0.0546875 * WIDTH, 0.6796875 * HEIGHT, 0.0546875 * WIDTH, 0.6796875 * HEIGHT));
        BODY.getElements().add((Object)new CubicCurveTo(0.0546875 * WIDTH, 0.7109375 * HEIGHT, 0.0625 * WIDTH, 0.71875 * HEIGHT, 0.09375 * WIDTH, 0.71875 * HEIGHT));
        BODY.getElements().add((Object)new CubicCurveTo(0.09375 * WIDTH, 0.71875 * HEIGHT, 0.8359375 * WIDTH, 0.71875 * HEIGHT, 0.8359375 * WIDTH, 0.71875 * HEIGHT));
        BODY.getElements().add((Object)new CubicCurveTo(0.8671875 * WIDTH, 0.71875 * HEIGHT, 0.875 * WIDTH, 0.7109375 * HEIGHT, 0.875 * WIDTH, 0.6796875 * HEIGHT));
        BODY.getElements().add((Object)new CubicCurveTo(0.875 * WIDTH, 0.6796875 * HEIGHT, 0.875 * WIDTH, 0.59375 * HEIGHT, 0.875 * WIDTH, 0.59375 * HEIGHT));
        BODY.getElements().add((Object)new CubicCurveTo(0.875 * WIDTH, 0.59375 * HEIGHT, 0.9375 * WIDTH, 0.59375 * HEIGHT, 0.9375 * WIDTH, 0.59375 * HEIGHT));
        BODY.getElements().add((Object)new CubicCurveTo(0.9453125 * WIDTH, 0.59375 * HEIGHT, 0.953125 * WIDTH, 0.5859375 * HEIGHT, 0.953125 * WIDTH, 0.578125 * HEIGHT));
        BODY.getElements().add((Object)new CubicCurveTo(0.953125 * WIDTH, 0.578125 * HEIGHT, 0.953125 * WIDTH, 0.4296875 * HEIGHT, 0.953125 * WIDTH, 0.4296875 * HEIGHT));
        BODY.getElements().add((Object)new CubicCurveTo(0.953125 * WIDTH, 0.4140625 * HEIGHT, 0.9453125 * WIDTH, 0.40625 * HEIGHT, 0.9375 * WIDTH, 0.40625 * HEIGHT));
        BODY.getElements().add((Object)new CubicCurveTo(0.9375 * WIDTH, 0.40625 * HEIGHT, 0.875 * WIDTH, 0.40625 * HEIGHT, 0.875 * WIDTH, 0.40625 * HEIGHT));
        BODY.getElements().add((Object)new CubicCurveTo(0.875 * WIDTH, 0.40625 * HEIGHT, 0.875 * WIDTH, 0.3203125 * HEIGHT, 0.875 * WIDTH, 0.3203125 * HEIGHT));
        BODY.getElements().add((Object)new CubicCurveTo(0.875 * WIDTH, 0.2890625 * HEIGHT, 0.8671875 * WIDTH, 0.28125 * HEIGHT, 0.8359375 * WIDTH, 0.28125 * HEIGHT));
        BODY.getElements().add((Object)new CubicCurveTo(0.8359375 * WIDTH, 0.28125 * HEIGHT, 0.09375 * WIDTH, 0.28125 * HEIGHT, 0.09375 * WIDTH, 0.28125 * HEIGHT));
        BODY.getElements().add((Object)new CubicCurveTo(0.0625 * WIDTH, 0.28125 * HEIGHT, 0.0546875 * WIDTH, 0.2890625 * HEIGHT, 0.0546875 * WIDTH, 0.3203125 * HEIGHT));
        BODY.getElements().add((Object)new ClosePath());
        BODY.setId("simple-battery-body");
        Path CONNECTOR = new Path();
        CONNECTOR.setFillRule(FillRule.EVEN_ODD);
        CONNECTOR.getElements().add((Object)new MoveTo(0.875 * WIDTH, 0.40625 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.875 * WIDTH, 0.40625 * HEIGHT));
        CONNECTOR.getElements().add((Object)new CubicCurveTo(0.875 * WIDTH, 0.40625 * HEIGHT, 0.9375 * WIDTH, 0.40625 * HEIGHT, 0.9375 * WIDTH, 0.40625 * HEIGHT));
        CONNECTOR.getElements().add((Object)new CubicCurveTo(0.9453125 * WIDTH, 0.40625 * HEIGHT, 0.953125 * WIDTH, 0.4140625 * HEIGHT, 0.953125 * WIDTH, 0.4296875 * HEIGHT));
        CONNECTOR.getElements().add((Object)new CubicCurveTo(0.953125 * WIDTH, 0.4296875 * HEIGHT, 0.953125 * WIDTH, 0.578125 * HEIGHT, 0.953125 * WIDTH, 0.578125 * HEIGHT));
        CONNECTOR.getElements().add((Object)new CubicCurveTo(0.953125 * WIDTH, 0.5859375 * HEIGHT, 0.9453125 * WIDTH, 0.59375 * HEIGHT, 0.9375 * WIDTH, 0.59375 * HEIGHT));
        CONNECTOR.getElements().add((Object)new CubicCurveTo(0.9375 * WIDTH, 0.59375 * HEIGHT, 0.875 * WIDTH, 0.59375 * HEIGHT, 0.875 * WIDTH, 0.59375 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.875 * WIDTH, 0.59375 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.875 * WIDTH, 0.40625 * HEIGHT));
        CONNECTOR.getElements().add((Object)new ClosePath());
        CONNECTOR.setId("simple-battery-connector");
        InnerShadow CONNECTOR_INNER_SHADOW0 = new InnerShadow();
        CONNECTOR_INNER_SHADOW0.setWidth(0.05625 * CONNECTOR.getLayoutBounds().getWidth());
        CONNECTOR_INNER_SHADOW0.setHeight(0.05625 * CONNECTOR.getLayoutBounds().getHeight());
        CONNECTOR_INNER_SHADOW0.setOffsetX(0.0);
        CONNECTOR_INNER_SHADOW0.setOffsetY(0.0);
        CONNECTOR_INNER_SHADOW0.setRadius(0.05625 * CONNECTOR.getLayoutBounds().getWidth());
        CONNECTOR_INNER_SHADOW0.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.6470588235));
        CONNECTOR_INNER_SHADOW0.setBlurType(BlurType.GAUSSIAN);
        CONNECTOR_INNER_SHADOW0.inputProperty().set(null);
        CONNECTOR.setEffect((Effect)CONNECTOR_INNER_SHADOW0);
        this.background.getChildren().addAll((Object[])new Node[]{BODY, CONNECTOR});
        this.background.setCache(true);
    }

    public final void drawMain() {
        double SIZE;
        double WIDTH = SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double HEIGHT = SIZE;
        this.main.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.main.getChildren().add((Object)IBOUNDS);
        this.fluid = new Rectangle(0.0703125 * WIDTH, 0.296875 * HEIGHT, 0.7890625 * WIDTH, 0.40625 * HEIGHT);
        this.fluid.setArcWidth(0.025 * WIDTH);
        this.fluid.setArcHeight(0.025 * HEIGHT);
        LinearGradient FLUID_FILL = new LinearGradient(0.0, 0.296875 * HEIGHT, 0.0, 0.703125 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.1647058824, (double)0.5450980392, (double)0.0, (double)1.0)), new Stop(0.32, Color.color((double)0.1647058824, (double)0.5450980392, (double)0.0, (double)1.0)), new Stop(1.0, Color.color((double)0.4666666667, (double)0.8588235294, (double)0.0, (double)1.0))});
        this.fluid.setFill((Paint)FLUID_FILL);
        this.fluid.setStroke(null);
        if (Double.compare(this.control.getChargingLevel(), 0.0) == 0) {
            this.fluid.setVisible(false);
        }
        this.flashFrame = new Path();
        this.flashFrame.setFillRule(FillRule.EVEN_ODD);
        this.flashFrame.getElements().add((Object)new MoveTo(0.59375 * WIDTH, 0.3671875 * HEIGHT));
        this.flashFrame.getElements().add((Object)new LineTo(0.34375 * WIDTH, 0.546875 * HEIGHT));
        this.flashFrame.getElements().add((Object)new LineTo(0.4453125 * WIDTH, 0.546875 * HEIGHT));
        this.flashFrame.getElements().add((Object)new LineTo(0.3515625 * WIDTH, 0.6484375 * HEIGHT));
        this.flashFrame.getElements().add((Object)new LineTo(0.5859375 * WIDTH, 0.5 * HEIGHT));
        this.flashFrame.getElements().add((Object)new LineTo(0.46875 * WIDTH, 0.5 * HEIGHT));
        this.flashFrame.getElements().add((Object)new LineTo(0.59375 * WIDTH, 0.3671875 * HEIGHT));
        this.flashFrame.getElements().add((Object)new ClosePath());
        Color FLASH_FRAME_FILL = Color.WHITE;
        this.flashFrame.setFill((Paint)FLASH_FRAME_FILL);
        this.flashFrame.setStroke(null);
        if (this.control.getChargeIndicator() == SimpleBattery.ChargeIndicator.FLASH) {
            this.flashFrame.setOpacity(1.0);
        } else {
            this.flashFrame.setOpacity(0.0);
        }
        if (!this.control.isCharging()) {
            this.flashFrame.setVisible(false);
        }
        this.flashMain = new Path();
        this.flashMain.setFillRule(FillRule.EVEN_ODD);
        this.flashMain.getElements().add((Object)new MoveTo(0.5625 * WIDTH, 0.390625 * HEIGHT));
        this.flashMain.getElements().add((Object)new LineTo(0.359375 * WIDTH, 0.5390625 * HEIGHT));
        this.flashMain.getElements().add((Object)new LineTo(0.453125 * WIDTH, 0.5390625 * HEIGHT));
        this.flashMain.getElements().add((Object)new LineTo(0.375 * WIDTH, 0.625 * HEIGHT));
        this.flashMain.getElements().add((Object)new LineTo(0.5703125 * WIDTH, 0.5078125 * HEIGHT));
        this.flashMain.getElements().add((Object)new LineTo(0.453125 * WIDTH, 0.5078125 * HEIGHT));
        this.flashMain.getElements().add((Object)new LineTo(0.5625 * WIDTH, 0.390625 * HEIGHT));
        this.flashMain.getElements().add((Object)new ClosePath());
        Color FLASH_MAIN_FILL = Color.color((double)0.9960784314, (double)0.9215686275, (double)0.0, (double)1.0);
        this.flashMain.setFill((Paint)FLASH_MAIN_FILL);
        this.flashMain.setStroke(null);
        if (this.control.getChargeIndicator() == SimpleBattery.ChargeIndicator.FLASH) {
            this.flashMain.setOpacity(1.0);
        } else {
            this.flashMain.setOpacity(0.0);
        }
        if (!this.control.isCharging()) {
            this.flashMain.setVisible(false);
        }
        InnerShadow FLASH_MAIN_INNER_SHADOW = new InnerShadow();
        FLASH_MAIN_INNER_SHADOW.setWidth(0.084375 * this.flashMain.getLayoutBounds().getWidth());
        FLASH_MAIN_INNER_SHADOW.setHeight(0.084375 * this.flashMain.getLayoutBounds().getHeight());
        FLASH_MAIN_INNER_SHADOW.setOffsetX(0.0);
        FLASH_MAIN_INNER_SHADOW.setOffsetY(0.0);
        FLASH_MAIN_INNER_SHADOW.setRadius(0.084375 * this.flashMain.getLayoutBounds().getWidth());
        FLASH_MAIN_INNER_SHADOW.setColor(Color.color((double)0.8509803922, (double)0.5294117647, (double)0.0, (double)1.0));
        FLASH_MAIN_INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        FLASH_MAIN_INNER_SHADOW.inputProperty().set(null);
        this.flashMain.setEffect((Effect)FLASH_MAIN_INNER_SHADOW);
        this.plug = new Path();
        this.plug.setFillRule(FillRule.EVEN_ODD);
        this.plug.getElements().add((Object)new MoveTo(0.5390625 * WIDTH, 0.484375 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.5390625 * WIDTH, 0.484375 * HEIGHT, 0.609375 * WIDTH, 0.484375 * HEIGHT, 0.609375 * WIDTH, 0.484375 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.6171875 * WIDTH, 0.484375 * HEIGHT, 0.625 * WIDTH, 0.4765625 * HEIGHT, 0.625 * WIDTH, 0.46875 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.625 * WIDTH, 0.46875 * HEIGHT, 0.625 * WIDTH, 0.4609375 * HEIGHT, 0.625 * WIDTH, 0.4609375 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.625 * WIDTH, 0.4609375 * HEIGHT, 0.6171875 * WIDTH, 0.453125 * HEIGHT, 0.609375 * WIDTH, 0.453125 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.609375 * WIDTH, 0.453125 * HEIGHT, 0.5390625 * WIDTH, 0.453125 * HEIGHT, 0.5390625 * WIDTH, 0.453125 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.5390625 * WIDTH, 0.4296875 * HEIGHT, 0.5390625 * WIDTH, 0.40625 * HEIGHT, 0.5390625 * WIDTH, 0.40625 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.4453125 * WIDTH, 0.40625 * HEIGHT, 0.390625 * WIDTH, 0.4453125 * HEIGHT, 0.375 * WIDTH, 0.484375 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.375 * WIDTH, 0.484375 * HEIGHT, 0.3046875 * WIDTH, 0.484375 * HEIGHT, 0.3046875 * WIDTH, 0.484375 * HEIGHT));
        this.plug.getElements().add((Object)new LineTo(0.3046875 * WIDTH, 0.5234375 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.3046875 * WIDTH, 0.5234375 * HEIGHT, 0.3828125 * WIDTH, 0.5234375 * HEIGHT, 0.3828125 * WIDTH, 0.5234375 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.390625 * WIDTH, 0.5625 * HEIGHT, 0.4296875 * WIDTH, 0.59375 * HEIGHT, 0.5390625 * WIDTH, 0.59375 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.5390625 * WIDTH, 0.59375 * HEIGHT, 0.5390625 * WIDTH, 0.578125 * HEIGHT, 0.5390625 * WIDTH, 0.5546875 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.5390625 * WIDTH, 0.5546875 * HEIGHT, 0.6171875 * WIDTH, 0.5546875 * HEIGHT, 0.6171875 * WIDTH, 0.5546875 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.6171875 * WIDTH, 0.5546875 * HEIGHT, 0.625 * WIDTH, 0.546875 * HEIGHT, 0.625 * WIDTH, 0.546875 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.625 * WIDTH, 0.546875 * HEIGHT, 0.625 * WIDTH, 0.53125 * HEIGHT, 0.625 * WIDTH, 0.53125 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.625 * WIDTH, 0.53125 * HEIGHT, 0.6171875 * WIDTH, 0.5234375 * HEIGHT, 0.6171875 * WIDTH, 0.5234375 * HEIGHT));
        this.plug.getElements().add((Object)new CubicCurveTo(0.6171875 * WIDTH, 0.5234375 * HEIGHT, 0.5390625 * WIDTH, 0.5234375 * HEIGHT, 0.5390625 * WIDTH, 0.5234375 * HEIGHT));
        this.plug.getElements().add((Object)new LineTo(0.5390625 * WIDTH, 0.484375 * HEIGHT));
        this.plug.getElements().add((Object)new ClosePath());
        this.plug.setFill((Paint)Color.rgb((int)51, (int)51, (int)51));
        this.plug.setStroke(null);
        if (this.control.getChargeIndicator() == SimpleBattery.ChargeIndicator.PLUG) {
            this.plug.setOpacity(1.0);
        } else {
            this.plug.setOpacity(0.0);
        }
        if (!this.control.isCharging()) {
            this.plug.setVisible(false);
        }
        this.main.getChildren().addAll((Object[])new Node[]{this.fluid, this.flashFrame, this.flashMain, this.plug});
    }

    private final void updateFluid() {
        Platform.runLater((Runnable)new Runnable(){

            public void run() {
                if (Double.compare(SimpleBatterySkin.this.control.getChargingLevel(), 0.0) == 0) {
                    SimpleBatterySkin.this.fluid.setVisible(false);
                } else {
                    SimpleBatterySkin.this.fluid.setVisible(true);
                }
                SimpleBatterySkin.this.fluid.setWidth(SimpleBatterySkin.this.control.getChargingLevel() * 0.7890625 * SimpleBatterySkin.this.control.getPrefWidth());
                SimpleBatterySkin.this.fluid.setFill((Paint)new LinearGradient(0.0, 0.296875 * SimpleBatterySkin.this.control.getPrefHeight(), 0.0, 0.703125 * SimpleBatterySkin.this.control.getPrefHeight(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.hsb((double)SimpleBatterySkin.this.currentLevelColor.getHue(), (double)SimpleBatterySkin.this.currentLevelColor.getSaturation(), (double)0.5)), new Stop(0.32, Color.hsb((double)SimpleBatterySkin.this.currentLevelColor.getHue(), (double)SimpleBatterySkin.this.currentLevelColor.getSaturation(), (double)0.5)), new Stop(1.0, SimpleBatterySkin.this.currentLevelColor)}));
            }
        });
    }

    public final void drawForeground() {
        double SIZE;
        double WIDTH = SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double HEIGHT = SIZE;
        this.foreground.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.foreground.getChildren().add((Object)IBOUNDS);
        Rectangle REFLECTION = new Rectangle(0.0703125 * WIDTH, 0.296875 * HEIGHT, 0.7890625 * WIDTH, 0.40625 * HEIGHT);
        REFLECTION.setArcWidth(0.025 * WIDTH);
        REFLECTION.setArcHeight(0.025 * HEIGHT);
        REFLECTION.setId("simple-battery-reflection");
        this.foreground.getChildren().addAll((Object[])new Node[]{REFLECTION});
        this.foreground.setCache(true);
    }
}

