/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Control;
import jfxtras.labs.internal.scene.control.behavior.CalendarPickerBehavior;
import jfxtras.labs.scene.control.CalendarPicker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CalendarPickerMonthlySkinAbstract<S>
extends SkinBase<CalendarPicker, CalendarPickerBehavior> {
    private volatile ObjectProperty<Calendar> iDisplayedCalendarObjectProperty = new SimpleObjectProperty();
    public static final String DISPLAYEDCALENDAR_PROPERTY_ID = "displayedCalendar";
    private SimpleDateFormat iSimpleDateFormat = null;
    private Calendar iToday = Calendar.getInstance();
    private int iTodayYear = this.iToday.get(1);
    private int iTodayMonth = this.iToday.get(2);
    private int iTodayDay = this.iToday.get(5);

    public CalendarPickerMonthlySkinAbstract(CalendarPicker control) {
        super((Control)control, (BehaviorBase)new CalendarPickerBehavior(control));
        this.construct();
    }

    private void construct() {
        this.setDisplayedCalendar(Calendar.getInstance());
        ((CalendarPicker)this.getSkinnable()).localeProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                CalendarPickerMonthlySkinAbstract.this.refreshLocale();
            }
        });
        this.refreshLocale();
    }

    public Calendar getDisplayedCalendar() {
        return (Calendar)this.iDisplayedCalendarObjectProperty.getValue();
    }

    public void setDisplayedCalendar(Calendar value) {
        Calendar lValue = this.getDisplayedCalendar();
        if (value != null && lValue != null && value.get(1) == lValue.get(1) && value.get(2) == lValue.get(2) && value.get(5) == lValue.get(5)) {
            return;
        }
        this.iDisplayedCalendarObjectProperty.setValue((Object)this.derriveDisplayedCalendar(value));
    }

    public S withDisplayedCalendar(Calendar value) {
        this.setDisplayedCalendar(value);
        return (S)((Object)this);
    }

    public ObjectProperty<Calendar> displayedCalendar() {
        return this.iDisplayedCalendarObjectProperty;
    }

    private Calendar derriveDisplayedCalendar(Calendar lDisplayedCalendar) {
        if (lDisplayedCalendar == null) {
            return null;
        }
        Calendar lCalendar = Calendar.getInstance(((CalendarPicker)this.getSkinnable()).getLocale());
        lCalendar.set(5, 1);
        lCalendar.set(2, lDisplayedCalendar.get(2));
        lCalendar.set(1, lDisplayedCalendar.get(1));
        lCalendar.set(11, 0);
        lCalendar.set(12, 0);
        lCalendar.set(13, 0);
        lCalendar.set(14, 0);
        return lCalendar;
    }

    private void refreshLocale() {
        this.iSimpleDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance(1, ((CalendarPicker)this.getSkinnable()).getLocale());
        this.setDisplayedCalendar(this.getDisplayedCalendar());
    }

    protected List<String> getWeekdayLabels() {
        ArrayList<String> lWeekdayLabels = new ArrayList<String>();
        this.iSimpleDateFormat.applyPattern("E");
        GregorianCalendar lCalendar = new GregorianCalendar(2009, 6, 5);
        for (int i = 0; i < 7; ++i) {
            lCalendar.set(5, 4 + this.getDisplayedCalendar().getFirstDayOfWeek() + i);
            lWeekdayLabels.add(this.iSimpleDateFormat.format(lCalendar.getTime()));
        }
        return lWeekdayLabels;
    }

    protected List<Integer> getWeeknumbers() {
        ArrayList<Integer> lWeekLabels = new ArrayList<Integer>();
        Calendar lCalendar = (Calendar)this.getDisplayedCalendar().clone();
        for (int i = 0; i <= 5; ++i) {
            lWeekLabels.add(lCalendar.get(3));
            lCalendar.add(5, 7);
        }
        return lWeekLabels;
    }

    protected List<String> getMonthLabels() {
        ArrayList<String> lMonthLabels = new ArrayList<String>();
        this.iSimpleDateFormat.applyPattern("MMMM");
        GregorianCalendar lCalendar = new GregorianCalendar(2009, 0, 1);
        for (int i = 0; i < 12; ++i) {
            lCalendar.set(2, i);
            lMonthLabels.add(this.iSimpleDateFormat.format(lCalendar.getTime()));
        }
        return lMonthLabels;
    }

    protected boolean isWeekday(int idx, int weekdaynr) {
        GregorianCalendar lCalendar = new GregorianCalendar(2009, 6, 4 + this.getDisplayedCalendar().getFirstDayOfWeek());
        ((Calendar)lCalendar).add(5, idx);
        int lDayOfWeek = lCalendar.get(7);
        return lDayOfWeek == weekdaynr;
    }

    protected boolean isWeekdayWeekend(int idx) {
        return this.isWeekday(idx, 7) || this.isWeekday(idx, 1);
    }

    protected int determineFirstOfMonthDayOfWeek() {
        int lFirstDayOfWeek = this.getDisplayedCalendar().getFirstDayOfWeek();
        int lFirstOfMonthIdx = this.getDisplayedCalendar().get(7) - lFirstDayOfWeek;
        if (lFirstOfMonthIdx < 0) {
            lFirstOfMonthIdx += 7;
        }
        return lFirstOfMonthIdx;
    }

    protected int determineDaysInMonth() {
        Calendar lCalendar = (Calendar)this.getDisplayedCalendar().clone();
        lCalendar.add(2, 1);
        lCalendar.set(5, 1);
        lCalendar.add(5, -1);
        return lCalendar.get(5);
    }

    protected boolean isToday(Calendar calendar) {
        int lYear = calendar.get(1);
        int lMonth = calendar.get(2);
        int lDay = calendar.get(5);
        return lYear == this.iTodayYear && lMonth == this.iTodayMonth && lDay == this.iTodayDay;
    }
}

