/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import jfxtras.labs.internal.scene.control.skin.CalendarPickerMonthlySkinAbstract;
import jfxtras.labs.scene.control.CalendarPicker;
import jfxtras.labs.scene.control.Spinner;
import jfxtras.labs.scene.control.SpinnerIntegerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarPickerControlSkin
extends CalendarPickerMonthlySkinAbstract<CalendarPickerControlSkin> {
    private Spinner<String> monthXSpinner = null;
    private Spinner<Integer> yearXSpinner = null;
    private final List<Label> weekdayLabels = new ArrayList<Label>();
    private final List<Label> weeknumberLabels = new ArrayList<Label>();
    private final List<ToggleButton> dayButtons = new ArrayList<ToggleButton>();
    private final Map<BooleanProperty, ToggleButton> booleanPropertyToDayToggleButtonMap = new HashMap<BooleanProperty, ToggleButton>();
    private final ChangeListener<Boolean> dayToggleButtonSelectedPropertyChangeListener = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> observableValue, Boolean oldValue, Boolean newValue) {
            if (CalendarPickerControlSkin.this.iRefreshingSelection.get() > 0) {
                return;
            }
            boolean lSelected = newValue;
            ToggleButton lToggleButton = (ToggleButton)CalendarPickerControlSkin.this.booleanPropertyToDayToggleButtonMap.get(observableValue);
            int lDayToggleButtonIdx = CalendarPickerControlSkin.this.dayButtons.indexOf(lToggleButton);
            int lFirstOfMonthIdx = CalendarPickerControlSkin.this.determineFirstOfMonthDayOfWeek();
            int lDayOfMonth = lDayToggleButtonIdx - lFirstOfMonthIdx + 1;
            Calendar lToggledCalendar = (Calendar)CalendarPickerControlSkin.this.getDisplayedCalendar().clone();
            lToggledCalendar.set(1, CalendarPickerControlSkin.this.getDisplayedCalendar().get(1));
            lToggledCalendar.set(2, CalendarPickerControlSkin.this.getDisplayedCalendar().get(2));
            lToggledCalendar.set(5, lDayOfMonth);
            ObservableList<Calendar> lCalendars = ((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).calendars();
            if (lSelected) {
                if (!lCalendars.contains(lToggledCalendar)) {
                    lCalendars.add(lToggledCalendar);
                }
                while (((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).getMode() == CalendarPicker.Mode.SINGLE && lCalendars.size() > 1) {
                    lCalendars.remove(0);
                }
            } else if (lCalendars.contains(lToggledCalendar)) {
                lCalendars.remove(lToggledCalendar);
            }
        }
    };
    private final AtomicInteger iRefreshingSelection = new AtomicInteger(0);

    public CalendarPickerControlSkin(CalendarPicker control) {
        super(control);
        this.construct();
    }

    private void construct() {
        this.createNodes();
        ((CalendarPicker)this.getSkinnable()).calendarProperty().addListener((ChangeListener)new ChangeListener<Calendar>(){

            public void changed(ObservableValue<? extends Calendar> observable, Calendar oldValue, Calendar newValue) {
                if (newValue != null) {
                    CalendarPickerControlSkin.this.setDisplayedCalendar(newValue);
                }
            }
        });
        if (((CalendarPicker)this.getSkinnable()).getCalendar() != null) {
            this.setDisplayedCalendar(((CalendarPicker)this.getSkinnable()).getCalendar());
        }
        ((CalendarPicker)this.getSkinnable()).calendars().addListener((ListChangeListener)new ListChangeListener<Calendar>(){

            public void onChanged(ListChangeListener.Change<? extends Calendar> arg0) {
                CalendarPickerControlSkin.this.refreshSelection();
            }
        });
        this.displayedCalendar().addListener((ChangeListener)new ChangeListener<Calendar>(){

            public void changed(ObservableValue<? extends Calendar> observable, Calendar oldValue, Calendar newValue) {
                CalendarPickerControlSkin.this.refresh();
            }
        });
        this.refresh();
    }

    private void createNodes() {
        Label lLabel;
        int i;
        GridPane lGridPane = new GridPane();
        lGridPane.setVgap(2.0);
        lGridPane.setHgap(2.0);
        ColumnConstraints lColumnConstraintsAlwaysGrow = new ColumnConstraints();
        lColumnConstraintsAlwaysGrow.setHgrow(Priority.ALWAYS);
        ColumnConstraints lColumnConstraintsNeverGrow = new ColumnConstraints();
        lColumnConstraintsNeverGrow.setHgrow(Priority.NEVER);
        lGridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{lColumnConstraintsNeverGrow, lColumnConstraintsAlwaysGrow, lColumnConstraintsAlwaysGrow, lColumnConstraintsAlwaysGrow, lColumnConstraintsAlwaysGrow, lColumnConstraintsAlwaysGrow, lColumnConstraintsAlwaysGrow, lColumnConstraintsAlwaysGrow});
        List<String> lMonthLabels = this.getMonthLabels();
        this.monthXSpinner = new Spinner<String>(lMonthLabels).withIndex(Calendar.getInstance().get(2)).withCyclic(Boolean.TRUE);
        this.monthXSpinner.setOnCycle(new EventHandler<Spinner.CycleEvent>(){

            public void handle(Spinner.CycleEvent evt) {
                if (evt.cycledDown()) {
                    CalendarPickerControlSkin.this.yearXSpinner.increment();
                } else {
                    CalendarPickerControlSkin.this.yearXSpinner.decrement();
                }
            }
        });
        this.monthXSpinner.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue arg0, String arg1, String arg2) {
                CalendarPickerControlSkin.this.setDisplayedCalendarFromSpinners();
            }
        });
        lGridPane.add(this.monthXSpinner, 0, 0, 5, 1);
        this.yearXSpinner = new Spinner<Integer>(new SpinnerIntegerList()).withValue(Calendar.getInstance().get(1));
        this.yearXSpinner.valueProperty().addListener((ChangeListener)new ChangeListener<Integer>(){

            public void changed(ObservableValue arg0, Integer oldValue, Integer newValue) {
                CalendarPickerControlSkin.this.setDisplayedCalendarFromSpinners();
            }
        });
        lGridPane.add(this.yearXSpinner, 5, 0, 3, 1);
        for (i = 0; i < 7; ++i) {
            lLabel = new Label("" + i);
            lLabel.setAlignment(Pos.CENTER);
            lGridPane.add((Node)lLabel, i + 1, 1);
            this.weekdayLabels.add(lLabel);
            lLabel.setAlignment(Pos.BASELINE_CENTER);
        }
        for (i = 0; i < 6; ++i) {
            lLabel = new Label("" + i);
            lLabel.getStyleClass().add((Object)"weeknumber");
            lLabel.setAlignment(Pos.BASELINE_RIGHT);
            this.weeknumberLabels.add(lLabel);
            lGridPane.add((Node)this.weeknumberLabels.get(i), 0, i + 2);
        }
        for (i = 0; i < 42; ++i) {
            ToggleButton lToggleButton = new ToggleButton("" + i);
            lToggleButton.getStyleClass().add((Object)"day");
            lToggleButton.selectedProperty().addListener(this.dayToggleButtonSelectedPropertyChangeListener);
            this.booleanPropertyToDayToggleButtonMap.put(lToggleButton.selectedProperty(), lToggleButton);
            lGridPane.add((Node)lToggleButton, i % 7 + 1, i / 7 + 2);
            lToggleButton.setMaxWidth(Double.MAX_VALUE);
            lToggleButton.setAlignment(Pos.BASELINE_CENTER);
            this.dayButtons.add(lToggleButton);
        }
        this.getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
        this.getChildren().add((Object)lGridPane);
    }

    private void setDisplayedCalendarFromSpinners() {
        int lYear = this.yearXSpinner.getValue();
        int lMonth = this.monthXSpinner.getIndex();
        Calendar lCalendar = (Calendar)this.getDisplayedCalendar().clone();
        lCalendar.set(1, lYear);
        lCalendar.set(2, lMonth);
        this.setDisplayedCalendar(lCalendar);
    }

    private void refresh() {
        this.refreshSpinner();
        this.refreshWeekdayLabels();
        this.refreshWeeknumberLabels();
        this.refreshDayButtons();
        this.refreshSelection();
    }

    private void refreshSpinner() {
        Calendar lCalendar = this.getDisplayedCalendar();
        List<String> lMonthLabels = this.getMonthLabels();
        String lMonthLabel = lMonthLabels.get(lCalendar.get(2));
        this.monthXSpinner.setValue(lMonthLabel);
        this.yearXSpinner.setValue(lCalendar.get(1));
    }

    private void refreshWeekdayLabels() {
        List<String> lWeekdayLabels = this.getWeekdayLabels();
        for (int i = 0; i < this.weekdayLabels.size(); ++i) {
            Label lLabel = this.weekdayLabels.get(i);
            lLabel.setText(lWeekdayLabels.get(i));
            lLabel.getStyleClass().remove((Object)"weekend");
            lLabel.getStyleClass().remove((Object)"weekday");
            lLabel.getStyleClass().add((Object)(this.isWeekdayWeekend(i) ? "weekend" : "weekday"));
        }
    }

    private void refreshWeeknumberLabels() {
        List<Integer> lWeeknumbers = this.getWeeknumbers();
        for (int i = 0; i < lWeeknumbers.size(); ++i) {
            this.weeknumberLabels.get(i).setText((lWeeknumbers.get(i) < 10 ? "0" : "") + lWeeknumbers.get(i).toString());
        }
    }

    private void refreshDayButtons() {
        int i;
        int i2;
        int lFirstOfMonthIdx = this.determineFirstOfMonthDayOfWeek();
        for (i2 = 0; i2 < lFirstOfMonthIdx; ++i2) {
            this.dayButtons.get(i2).setVisible(false);
        }
        for (i2 = 1; i2 < 6; ++i2) {
            this.weeknumberLabels.get(i2).setVisible(false);
        }
        int lDaysInMonth = this.determineDaysInMonth();
        Calendar lCalendar = (Calendar)this.getDisplayedCalendar().clone();
        for (i = 1; i <= lDaysInMonth; ++i) {
            lCalendar.set(5, i);
            int lIdx = lFirstOfMonthIdx + i - 1;
            ToggleButton lToggleButton = this.dayButtons.get(lIdx);
            lToggleButton.setVisible(true);
            lToggleButton.setText("" + i);
            lToggleButton.getStyleClass().remove((Object)"weekend");
            lToggleButton.getStyleClass().remove((Object)"weekday");
            lToggleButton.getStyleClass().add((Object)(this.isWeekdayWeekend(lIdx % 7) ? "weekend" : "weekday"));
            this.weeknumberLabels.get(lIdx / 7).setVisible(true);
            if (this.isToday(lCalendar)) {
                lToggleButton.getStyleClass().add((Object)"today");
                continue;
            }
            lToggleButton.getStyleClass().remove((Object)"today");
        }
        for (i = lFirstOfMonthIdx + lDaysInMonth; i < 42; ++i) {
            this.dayButtons.get(i).setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshSelection() {
        this.iRefreshingSelection.addAndGet(1);
        try {
            int lFirstOfMonthIdx = this.determineFirstOfMonthDayOfWeek();
            ObservableList<Calendar> lCalendars = ((CalendarPicker)this.getSkinnable()).calendars();
            int lDaysInMonth = this.determineDaysInMonth();
            Calendar lCalendar = (Calendar)this.getDisplayedCalendar().clone();
            for (int i = 1; i <= lDaysInMonth; ++i) {
                lCalendar.set(5, i);
                int lIdx = lFirstOfMonthIdx + i - 1;
                boolean lSelected = lCalendars.contains(lCalendar);
                this.dayButtons.get(lIdx).setSelected(lSelected);
            }
        }
        finally {
            this.iRefreshingSelection.addAndGet(-1);
        }
    }
}

