/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.cli.shell.command;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;
import org.codehaus.griffon.cli.CommandLineConstants;
import org.codehaus.griffon.cli.shell.GriffonShellContext;
import org.fusesource.jansi.Ansi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Command(scope="shell", name="properties", description="Prints information on system properties.")
public class PropertiesCommand
extends AbstractAction {
    @Option(name="--reset", description="Reset property values as if the shell was just launched.")
    private boolean reset;

    protected Object doExecute() throws Exception {
        if (this.reset) {
            Properties props = System.getProperties();
            for (String string : GriffonShellContext.getSystemProperties().keySet()) {
                props.remove(string);
            }
            for (String key : CommandLineConstants.KEYS) {
                props.remove(key);
            }
            for (Map.Entry entry : GriffonShellContext.getInitialSystemProperties().entrySet()) {
                props.put(entry.getKey(), entry.getValue());
            }
            GriffonShellContext.setSystemProperties(GriffonShellContext.getInitialSystemProperties());
            System.setProperties(props);
        }
        this.printProperties("Initial Properties", GriffonShellContext.getInitialSystemProperties(), false);
        this.printProperties("Command Properties", this.getCommandLineProperties(), true);
        this.printProperties("Custom Properties", this.getCustomProperties(), true);
        return null;
    }

    private void printProperties(String label, Map<String, String> properties, boolean live) {
        int maxNameLen = 0;
        System.out.println(label);
        if (!properties.isEmpty()) {
            for (String string : properties.keySet()) {
                maxNameLen = Math.max(maxNameLen, string.length());
            }
            for (Map.Entry entry : properties.entrySet()) {
                if (live) {
                    this.printSysValue((String)entry.getKey(), maxNameLen);
                    continue;
                }
                this.printValue((String)entry.getKey(), maxNameLen, (String)entry.getValue());
            }
        } else {
            System.out.println("  NONE");
        }
        System.out.println();
    }

    private Map<String, String> getCommandLineProperties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        Arrays.sort(CommandLineConstants.KEYS);
        for (String key : CommandLineConstants.KEYS) {
            properties.put(key, null);
        }
        return properties;
    }

    private Map<String, String> getCustomProperties() {
        Object[] commandProperties = (String[])ArrayUtils.clone((Object[])CommandLineConstants.KEYS);
        Arrays.sort(commandProperties);
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : GriffonShellContext.getSystemProperties().entrySet()) {
            if (ArrayUtils.contains((Object[])commandProperties, (Object)entry.getKey())) continue;
            properties.put(entry.getKey(), null);
        }
        return properties;
    }

    private void printSysValue(String prop, int pad) {
        this.printValue(prop, pad, System.getProperty(prop));
    }

    private void printValue(String name, int pad, String value) {
        if (value == null) {
            value = "<not set>";
        } else if (value.equals("")) {
            value = "<empty>";
        }
        System.out.println(Ansi.ansi().a("  ").a(Ansi.Attribute.INTENSITY_BOLD).a(name).a(this.spaces(pad - name.length())).a(Ansi.Attribute.RESET).a("   ").a(value).toString());
    }

    private String spaces(int nb) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nb; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }
}

