/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.cli.shell;

import griffon.util.GriffonNameUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import jline.Terminal;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.CommandException;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.gogo.runtime.CommandNotFoundException;
import org.apache.felix.gogo.runtime.CommandProcessorImpl;
import org.apache.felix.gogo.runtime.threadio.ThreadIOImpl;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.apache.felix.service.threadio.ThreadIO;
import org.apache.karaf.shell.console.jline.Console;
import org.apache.karaf.shell.console.jline.TerminalFactory;
import org.codehaus.griffon.cli.shell.CommandProcessorImplHolder;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KarafMain {
    private String application = System.getProperty("karaf.name", "root");
    private String user = "karaf";

    public void run(String[] args) throws Exception {
        ThreadIOImpl threadio = new ThreadIOImpl();
        threadio.start();
        CommandProcessorImpl commandProcessor = new CommandProcessorImpl((ThreadIO)threadio);
        CommandProcessorImplHolder.setCommandProcessor(commandProcessor);
        ClassLoader cl = KarafMain.class.getClassLoader();
        if (args.length > 0 && args[0].startsWith("--classpath=")) {
            String base = args[0].substring("--classpath=".length());
            List<URL> urls = KarafMain.getFiles(new File(base));
            cl = new URLClassLoader(urls.toArray(new URL[urls.size()]), cl);
            String[] a = new String[args.length - 1];
            System.arraycopy(args, 1, a, 0, a.length);
            args = a;
        }
        this.discoverCommands(commandProcessor, cl);
        InputStream in = KarafMain.unwrap(System.in);
        PrintStream out = KarafMain.wrap(KarafMain.unwrap(System.out));
        PrintStream err = KarafMain.wrap(KarafMain.unwrap(System.err));
        this.run(commandProcessor, args, in, out, err);
    }

    public void run(CommandSession parent, String[] args) throws Exception {
        CommandProcessorImpl commandProcessor = new CommandProcessorImpl(new ThreadIO(){

            public void setStreams(InputStream in, PrintStream out, PrintStream err) {
            }

            public void close() {
            }
        });
        CommandProcessorImplHolder.setCommandProcessor(commandProcessor);
        ClassLoader cl = KarafMain.class.getClassLoader();
        if (args.length > 0 && args[0].startsWith("--classpath=")) {
            String base = args[0].substring("--classpath=".length());
            List<URL> urls = KarafMain.getFiles(new File(base));
            cl = new URLClassLoader(urls.toArray(new URL[urls.size()]), cl);
            String[] a = new String[args.length - 1];
            System.arraycopy(args, 1, a, 0, a.length);
            args = a;
        }
        this.discoverCommands(commandProcessor, cl);
        InputStream in = parent.getKeyboard();
        PrintStream out = parent.getConsole();
        PrintStream err = parent.getConsole();
        this.run(commandProcessor, args, in, out, err);
    }

    private void run(CommandProcessorImpl commandProcessor, String[] args, InputStream in, PrintStream out, PrintStream err) throws Exception {
        block9: {
            String stringifiedArgs;
            StringBuilder sb = new StringBuilder();
            if (args.length > 0) {
                for (int i = 0; i < args.length; ++i) {
                    if (i > 0) {
                        sb.append(" ");
                    }
                    sb.append(args[i]);
                }
            }
            if (!GriffonNameUtils.isBlank((String)(stringifiedArgs = sb.toString().trim()))) {
                CommandSession session = commandProcessor.createSession(in, out, err);
                session.put("USER", (Object)this.user);
                session.put("APPLICATION", (Object)this.application);
                session.put("MULTI_SCOPE_MODE", (Object)Boolean.toString(this.isMultiScopeMode()));
                try {
                    session.execute((CharSequence)stringifiedArgs);
                }
                catch (Throwable t) {
                    if (t instanceof CommandNotFoundException) {
                        String str = Ansi.ansi().fg(Ansi.Color.RED).a("Command not found: ").a(Ansi.Attribute.INTENSITY_BOLD).a(((CommandNotFoundException)t).getCommand()).a(Ansi.Attribute.INTENSITY_BOLD_OFF).fg(Ansi.Color.DEFAULT).toString();
                        session.getConsole().println(str);
                        break block9;
                    }
                    if (t instanceof CommandException) {
                        session.getConsole().println(((CommandException)t).getNiceHelp());
                        break block9;
                    }
                    session.getConsole().print(Ansi.ansi().fg(Ansi.Color.RED).toString());
                    t.printStackTrace(session.getConsole());
                    session.getConsole().print(Ansi.ansi().fg(Ansi.Color.DEFAULT).toString());
                }
            } else {
                TerminalFactory terminalFactory = new TerminalFactory();
                final Terminal terminal = terminalFactory.getTerminal();
                Console console = this.createConsole(commandProcessor, in, out, err, terminal);
                CommandSession session = console.getSession();
                session.put("USER", (Object)this.user);
                session.put("APPLICATION", (Object)this.application);
                session.put("MULTI_SCOPE_MODE", (Object)Boolean.toString(this.isMultiScopeMode()));
                session.put("#LINES", (Object)new Function(){

                    public Object execute(CommandSession session, List<Object> arguments) throws Exception {
                        return Integer.toString(terminal.getHeight());
                    }
                });
                session.put("#COLUMNS", (Object)new Function(){

                    public Object execute(CommandSession session, List<Object> arguments) throws Exception {
                        return Integer.toString(terminal.getWidth());
                    }
                });
                session.put(".jline.terminal", (Object)terminal);
                console.run();
                terminalFactory.destroy();
            }
        }
    }

    protected Console createConsole(CommandProcessorImpl commandProcessor, InputStream in, PrintStream out, PrintStream err, Terminal terminal) throws Exception {
        return new Console((CommandProcessor)commandProcessor, in, out, err, terminal, null);
    }

    public String getDiscoveryResource() {
        return "META-INF/services/org/apache/karaf/shell/commands";
    }

    protected void discoverCommands(CommandProcessorImpl commandProcessor, ClassLoader cl) throws IOException, ClassNotFoundException {
        Enumeration<URL> urls = cl.getResources(this.getDiscoveryResource());
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = r.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0 && line.charAt(0) != '#') {
                    final Class<?> actionClass = cl.loadClass(line);
                    Command cmd = actionClass.getAnnotation(Command.class);
                    AbstractCommand function = new AbstractCommand(){

                        public Action createNewAction() {
                            try {
                                return (Action)actionClass.newInstance();
                            }
                            catch (InstantiationException e) {
                                throw new RuntimeException(e);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                    this.addCommand(cmd, (Function)function, commandProcessor);
                }
                line = r.readLine();
            }
            r.close();
        }
    }

    protected void addCommand(Command cmd, Function function, CommandProcessorImpl commandProcessor) {
        try {
            commandProcessor.addCommand(cmd.scope(), (Object)function, cmd.name());
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean isMultiScopeMode() {
        return true;
    }

    private static PrintStream wrap(PrintStream stream) {
        OutputStream o = AnsiConsole.wrapOutputStream((OutputStream)stream);
        if (o instanceof PrintStream) {
            return (PrintStream)o;
        }
        return new PrintStream(o);
    }

    private static <T> T unwrap(T stream) {
        try {
            Method mth = stream.getClass().getMethod("getRoot", new Class[0]);
            return (T)mth.invoke(stream, new Object[0]);
        }
        catch (Throwable t) {
            return stream;
        }
    }

    private static List<URL> getFiles(File base) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        KarafMain.getFiles(base, urls);
        return urls;
    }

    private static void getFiles(File base, List<URL> urls) throws MalformedURLException {
        for (File f : base.listFiles()) {
            if (f.isDirectory()) {
                KarafMain.getFiles(f, urls);
                continue;
            }
            if (!f.getName().endsWith(".jar")) continue;
            urls.add(f.toURI().toURL());
        }
    }
}

