/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.util;

import griffon.core.ArtifactHandler;
import griffon.core.GriffonApplication;
import griffon.core.GriffonArtifact;
import griffon.core.GriffonClass;
import griffon.core.LifecycleHandler;
import griffon.core.MVCGroupConfiguration;
import griffon.core.UIThreadManager;
import griffon.core.factories.AddonManagerFactory;
import griffon.core.factories.ArtifactManagerFactory;
import griffon.core.factories.MVCGroupManagerFactory;
import griffon.exceptions.GriffonException;
import griffon.util.CollectionUtils;
import griffon.util.ConfigUtils;
import griffon.util.Environment;
import griffon.util.GriffonApplicationUtils;
import griffon.util.GriffonExceptionHandler;
import griffon.util.GriffonNameUtils;
import griffon.util.Metadata;
import griffon.util.PlatformHandler;
import griffon.util.RunnableWithArgs;
import griffon.util.RunnableWithArgsClosure;
import groovy.lang.Closure;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.ExpandoMetaClassCreationHandle;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import groovy.util.ConfigObject;
import groovy.util.ConfigSlurper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.LogManager;
import org.apache.log4j.helpers.LogLog;
import org.codehaus.griffon.runtime.core.ControllerArtifactHandler;
import org.codehaus.griffon.runtime.core.ModelArtifactHandler;
import org.codehaus.griffon.runtime.core.ServiceArtifactHandler;
import org.codehaus.griffon.runtime.core.ViewArtifactHandler;
import org.codehaus.griffon.runtime.logging.Log4jConfig;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GriffonApplicationHelper {
    private static final Logger LOG = LoggerFactory.getLogger(GriffonApplicationHelper.class);
    private static final Map<String, String> DEFAULT_PLATFORM_HANDLERS = CollectionUtils.map().e("linux", "org.codehaus.griffon.runtime.util.DefaultLinuxPlatformHandler").e("macosx", "org.codehaus.griffon.runtime.util.DefaultMacOSXPlatformHandler").e("solaris", "org.codehaus.griffon.runtime.util.DefaultSolarisPlatformHandler").e("windows", "org.codehaus.griffon.runtime.util.DefaultWindowsPlatformHandler");
    private static final String KEY_ARTIFACT_MANAGER_FACTORY = "app.artifactManager.factory";
    private static final String DEFAULT_ARTIFACT_MANAGER_FACTORY = "org.codehaus.griffon.runtime.core.factories.DefaultArtifactManagerFactory";
    private static final String KEY_ADDON_MANAGER_FACTORY = "app.addonManager.factory";
    private static final String DEFAULT_ADDON_MANAGER_FACTORY = "org.codehaus.griffon.runtime.core.factories.DefaultAddonManagerFactory";
    private static final String KEY_MVCGROUP_MANAGER_FACTORY = "app.mvcGroupManager.factory";
    private static final String DEFAULT_MVCGROUP_MANAGER_FACTORY = "org.codehaus.griffon.runtime.core.factories.DefaultMVCGroupManagerFactory";

    public static MetaClass expandoMetaClassFor(Class clazz) {
        MetaClass mc = GroovySystem.getMetaClassRegistry().getMetaClass(clazz);
        if (!(mc instanceof ExpandoMetaClass)) {
            mc = new ExpandoMetaClass(clazz, true, true);
            mc.initialize();
            GroovySystem.getMetaClassRegistry().setMetaClass(clazz, mc);
        }
        return mc;
    }

    private static ConfigObject loadConfig(ConfigSlurper configSlurper, Class configClass, String configFileName) {
        ConfigObject config = new ConfigObject();
        try {
            InputStream is;
            if (configClass != null) {
                config.merge(configSlurper.parse(configClass));
            }
            if ((is = Thread.currentThread().getContextClassLoader().getResourceAsStream(configFileName + ".properties")) != null) {
                Properties p = new Properties();
                p.load(is);
                config.merge(configSlurper.parse(p));
            }
        }
        catch (Exception x) {
            LogLog.warn((String)("Cannot read configuration [class: " + configClass + ", file: " + configFileName + "]"), (Throwable)GriffonExceptionHandler.sanitize(x));
        }
        return config;
    }

    public static void prepare(GriffonApplication app) {
        app.getBindings().setVariable("app", (Object)app);
        Metadata.getCurrent().getGriffonStartDir();
        Metadata.getCurrent().getGriffonWorkingDir();
        GriffonApplicationHelper.readAndSetConfiguration(app);
        app.event(GriffonApplication.Event.BOOTSTRAP_START.getName(), Arrays.asList(app));
        GriffonApplicationHelper.applyPlatformTweaks(app);
        GriffonApplicationHelper.runLifecycleHandler(GriffonApplication.Lifecycle.INITIALIZE.getName(), app);
        GriffonApplicationHelper.initializeArtifactManager(app);
        GriffonApplicationHelper.initializeMvcManager(app);
        GriffonApplicationHelper.initializeAddonManager(app);
        app.event(GriffonApplication.Event.BOOTSTRAP_END.getName(), Arrays.asList(app));
    }

    private static void readAndSetConfiguration(GriffonApplication app) {
        Object log4jConfig;
        ConfigSlurper configSlurper = new ConfigSlurper(Environment.getCurrent().getName());
        app.setConfig(GriffonApplicationHelper.loadConfig(configSlurper, app.getAppConfigClass(), GriffonApplication.Configuration.APPLICATION.getName()));
        app.getConfig().merge(GriffonApplicationHelper.loadConfig(configSlurper, app.getConfigClass(), GriffonApplication.Configuration.CONFIG.getName()));
        GriffonExceptionHandler.configure(app.getConfig().flatten(new LinkedHashMap()));
        app.setBuilderConfig(GriffonApplicationHelper.loadConfig(configSlurper, app.getBuilderClass(), GriffonApplication.Configuration.BUILDER.getName()));
        Object events = GriffonApplicationHelper.safeNewInstance(app.getEventsClass());
        if (events != null) {
            app.setEventsConfig(events);
            app.addApplicationEventListener(app.getEventsConfig());
        }
        if ((log4jConfig = app.getConfig().get((Object)"log4j")) instanceof Closure) {
            app.event(GriffonApplication.Event.LOG4J_CONFIG_START.getName(), Arrays.asList(log4jConfig));
            LogManager.resetConfiguration();
            new Log4jConfig().configure((Closure)log4jConfig);
        }
    }

    public static void applyPlatformTweaks(GriffonApplication app) {
        String platform = GriffonApplicationUtils.platform;
        String handlerClassName = ConfigUtils.getConfigValueAsString((Map)app.getConfig(), "platform.handler." + platform, DEFAULT_PLATFORM_HANDLERS.get(platform));
        PlatformHandler platformHandler = (PlatformHandler)GriffonApplicationHelper.safeNewInstance(handlerClassName);
        platformHandler.handle(app);
    }

    private static void initializeArtifactManager(GriffonApplication app) {
        if (app.getArtifactManager() == null) {
            String className = ConfigUtils.getConfigValueAsString((Map)app.getConfig(), KEY_ARTIFACT_MANAGER_FACTORY, DEFAULT_ARTIFACT_MANAGER_FACTORY);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using " + className + " as ArtifactManagerFactory");
            }
            ArtifactManagerFactory factory = (ArtifactManagerFactory)GriffonApplicationHelper.safeNewInstance(className);
            InvokerHelper.setProperty((Object)app, (String)"artifactManager", (Object)factory.create(app));
        }
        app.getArtifactManager().registerArtifactHandler(new ModelArtifactHandler(app));
        app.getArtifactManager().registerArtifactHandler(new ViewArtifactHandler(app));
        app.getArtifactManager().registerArtifactHandler(new ControllerArtifactHandler(app));
        app.getArtifactManager().registerArtifactHandler(new ServiceArtifactHandler(app));
        GriffonApplicationHelper.loadArtifactHandlers(app);
        app.getArtifactManager().loadArtifactMetadata();
    }

    private static void initializeAddonManager(GriffonApplication app) {
        if (app.getAddonManager() == null) {
            String className = ConfigUtils.getConfigValueAsString((Map)app.getConfig(), KEY_ADDON_MANAGER_FACTORY, DEFAULT_ADDON_MANAGER_FACTORY);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using " + className + " as AddonManagerFactory");
            }
            AddonManagerFactory factory = (AddonManagerFactory)GriffonApplicationHelper.safeNewInstance(className);
            InvokerHelper.setProperty((Object)app, (String)"addonManager", (Object)factory.create(app));
        }
        app.getAddonManager().initialize();
    }

    private static void initializeMvcManager(GriffonApplication app) {
        if (app.getMvcGroupManager() == null) {
            String className = ConfigUtils.getConfigValueAsString((Map)app.getConfig(), KEY_MVCGROUP_MANAGER_FACTORY, DEFAULT_MVCGROUP_MANAGER_FACTORY);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using " + className + " as MVCGroupManagerFactory");
            }
            MVCGroupManagerFactory factory = (MVCGroupManagerFactory)GriffonApplicationHelper.safeNewInstance(className);
            InvokerHelper.setProperty((Object)app, (String)"mvcGroupManager", (Object)factory.create(app));
        }
        LinkedHashMap<String, MVCGroupConfiguration> configurations = new LinkedHashMap<String, MVCGroupConfiguration>();
        Map mvcGroups = (Map)app.getConfig().get((Object)"mvcGroups");
        if (mvcGroups != null) {
            for (Map.Entry groupEntry : mvcGroups.entrySet()) {
                String type = (String)groupEntry.getKey();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding MVC group " + type);
                }
                ConfigObject members = (ConfigObject)groupEntry.getValue();
                Map<String, Object> configMap = new LinkedHashMap<String, Object>();
                LinkedHashMap<String, String> membersCopy = new LinkedHashMap<String, String>();
                for (Object o : members.entrySet()) {
                    Map.Entry entry = (Map.Entry)o;
                    String key = String.valueOf(entry.getKey());
                    if ("config".equals(key) && entry.getValue() instanceof Map) {
                        configMap = (Map)entry.getValue();
                        continue;
                    }
                    membersCopy.put(key, String.valueOf(entry.getValue()));
                }
                configurations.put(type, app.getMvcGroupManager().newMVCGroupConfiguration(type, membersCopy, configMap));
            }
        }
        app.getMvcGroupManager().initialize(configurations);
    }

    private static void loadArtifactHandlers(final GriffonApplication app) {
        Enumeration<URL> urls = null;
        try {
            urls = app.getClass().getClassLoader().getResources("META-INF/services/" + ArtifactHandler.class.getName());
        }
        catch (IOException ioe) {
            return;
        }
        if (urls == null) {
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reading " + ArtifactHandler.class.getName() + " definitions from " + url);
            }
            try {
                DefaultGroovyMethods.eachLine((URL)url, (Closure)new RunnableWithArgsClosure(new RunnableWithArgs(){

                    public void run(Object[] args) {
                        block3: {
                            String line = (String)args[0];
                            if (line.startsWith("#") || GriffonNameUtils.isBlank(line)) {
                                return;
                            }
                            try {
                                Class artifactHandlerClass = GriffonApplicationHelper.loadClass(line);
                                Constructor ctor = artifactHandlerClass.getDeclaredConstructor(GriffonApplication.class);
                                ArtifactHandler handler = null;
                                handler = ctor != null ? (ArtifactHandler)ctor.newInstance(app) : (ArtifactHandler)GriffonApplicationHelper.safeNewInstance(artifactHandlerClass);
                                app.getArtifactManager().registerArtifactHandler(handler);
                            }
                            catch (Exception e) {
                                if (!LOG.isWarnEnabled()) break block3;
                                LOG.warn("Could not load ArtifactHandler with " + line, GriffonExceptionHandler.sanitize(e));
                            }
                        }
                    }
                }));
            }
            catch (IOException e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Could not load ArtifactHandler from " + url, GriffonExceptionHandler.sanitize(e));
            }
        }
    }

    @Deprecated
    public static void runScriptInsideUIThread(String scriptName, GriffonApplication app) {
        GriffonApplicationHelper.runLifecycleHandler(scriptName, app);
    }

    public static void runLifecycleHandler(String handlerName, GriffonApplication app) {
        Class handlerClass = null;
        try {
            handlerClass = GriffonApplicationHelper.loadClass(handlerName);
        }
        catch (ClassNotFoundException cnfe) {
            if (cnfe.getMessage().equals(handlerName)) {
                return;
            }
            throw new GriffonException(cnfe);
        }
        if (Script.class.isAssignableFrom(handlerClass)) {
            GriffonApplicationHelper.doRunScript(handlerName, handlerClass, app);
        } else if (LifecycleHandler.class.isAssignableFrom(handlerClass)) {
            GriffonApplicationHelper.doRunLifecycleHandler(handlerName, handlerClass, app);
        }
    }

    private static void doRunScript(String scriptName, Class handlerClass, GriffonApplication app) {
        Script script = (Script)GriffonApplicationHelper.safeNewInstance(handlerClass);
        script.setBinding(app.getBindings());
        UIThreadManager.enhance(script);
        if (LOG.isInfoEnabled()) {
            LOG.info("Running lifecycle handler (script) '" + scriptName + "'");
        }
        UIThreadManager.getInstance().executeSync(script);
    }

    private static void doRunLifecycleHandler(String handlerName, Class handlerClass, GriffonApplication app) {
        LifecycleHandler handler = (LifecycleHandler)GriffonApplicationHelper.safeNewInstance(handlerClass);
        if (LOG.isInfoEnabled()) {
            LOG.info("Running lifecycle handler (class) '" + handlerName + "'");
        }
        UIThreadManager.getInstance().executeSync(handler);
    }

    public static Object newInstance(GriffonApplication app, Class klass) {
        return GriffonApplicationHelper.newInstance(app, klass, "");
    }

    public static Object newInstance(GriffonApplication app, Class klass, String type) {
        if (GriffonNameUtils.isBlank(type)) {
            type = "";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Instantiating " + klass.getName() + " with type '" + type + "'");
        }
        Object instance = GriffonApplicationHelper.safeNewInstance(klass);
        GriffonClass griffonClass = app.getArtifactManager().findGriffonClass(klass);
        MetaClass mc = griffonClass != null ? griffonClass.getMetaClass() : GriffonApplicationHelper.expandoMetaClassFor(klass);
        GriffonApplicationHelper.enhance(app, klass, mc, instance);
        app.event(GriffonApplication.Event.NEW_INSTANCE.getName(), Arrays.asList(klass, type, instance));
        return instance;
    }

    public static void enhance(GriffonApplication app, Class klass, MetaClass mc, Object instance) {
        block5: {
            try {
                InvokerHelper.invokeMethod((Object)instance, (String)"setApp", (Object)app);
            }
            catch (MissingMethodException mme) {
                try {
                    InvokerHelper.setProperty((Object)instance, (String)"app", (Object)app);
                }
                catch (MissingPropertyException mpe) {
                    if (!(mc instanceof ExpandoMetaClass)) break block5;
                    ((ExpandoMetaClass)mc).registerBeanProperty("app", (Object)app);
                }
            }
        }
        if (!GriffonArtifact.class.isAssignableFrom(klass)) {
            UIThreadManager.enhance(mc);
        }
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        ClassNotFoundException cnfe = null;
        ClassLoader cl = GriffonApplicationHelper.class.getClassLoader();
        try {
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            cnfe = e;
            cl = Thread.currentThread().getContextClassLoader();
            try {
                return cl.loadClass(className);
            }
            catch (ClassNotFoundException e2) {
                cnfe = e2;
                if (cnfe != null) {
                    throw cnfe;
                }
                return null;
            }
        }
    }

    private static Object safeNewInstance(String className) {
        try {
            return GriffonApplicationHelper.loadClass(className).newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object safeNewInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        ExpandoMetaClassCreationHandle.enable();
    }
}

