/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.ArtifactInfo;
import griffon.core.GriffonApplication;
import groovy.util.ConfigObject;
import groovy.util.ConfigSlurper;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.griffon.runtime.core.AbstractArtifactManager;
import org.codehaus.griffon.runtime.util.GriffonApplicationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultArtifactManager
extends AbstractArtifactManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultArtifactManager.class);

    public DefaultArtifactManager(GriffonApplication app) {
        super(app);
    }

    @Override
    protected Map<String, List<ArtifactInfo>> doLoadArtifactMetadata() {
        LinkedHashMap<String, List<ArtifactInfo>> artifacts = new LinkedHashMap<String, List<ArtifactInfo>>();
        try {
            Enumeration<URL> urls = this.getApp().getClass().getClassLoader().getResources("META-INF/griffon-artifacts.properties");
            ConfigSlurper slurper = new ConfigSlurper();
            while (urls.hasMoreElements()) {
                this.processURL(urls.nextElement(), slurper, artifacts);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return artifacts;
    }

    private void processURL(URL url, ConfigSlurper slurper, Map<String, List<ArtifactInfo>> artifacts) {
        Properties p = new Properties();
        try {
            p.load(url.openStream());
        }
        catch (IOException e) {
            return;
        }
        ConfigObject config = slurper.parse(p);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading artifact definitions from " + url);
        }
        for (Object key : config.keySet()) {
            List<ArtifactInfo> list;
            String type = key.toString();
            String classes = (String)config.get((Object)type);
            if (classes.startsWith("'") && classes.endsWith("'")) {
                classes = classes.substring(1, classes.length() - 1);
            }
            String[] classNames = classes.split(",");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Artifacts of type '" + type + "' = " + classNames.length);
            }
            if ((list = artifacts.get(type)) == null) {
                list = new ArrayList<ArtifactInfo>();
                artifacts.put(type, list);
            }
            for (String className : classNames) {
                try {
                    ArtifactInfo info;
                    Class clazz = GriffonApplicationHelper.loadClass(className);
                    if (Modifier.isAbstract(clazz.getModifiers()) || list.contains(info = new ArtifactInfo(clazz, type))) continue;
                    list.add(info);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
    }
}

