/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GriffonNameUtils {
    private static final String PROPERTY_SET_PREFIX = "set";

    public static String capitalize(String str) {
        if (GriffonNameUtils.isBlank(str)) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toUpperCase(Locale.ENGLISH) + str.substring(1);
    }

    public static String uncapitalize(String str) {
        if (GriffonNameUtils.isBlank(str)) {
            return str;
        }
        if (str.length() == 1) {
            return String.valueOf(Character.toLowerCase(str.charAt(0)));
        }
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public static String getSetterName(String propertyName) {
        return PROPERTY_SET_PREFIX + GriffonNameUtils.capitalize(propertyName);
    }

    public static String getGetterName(String propertyName) {
        return "get" + GriffonNameUtils.capitalize(propertyName);
    }

    public static String getClassName(String logicalName, String trailingName) {
        if (GriffonNameUtils.isBlank(logicalName)) {
            throw new IllegalArgumentException("Argument [logicalName] cannot be null or blank");
        }
        String className = GriffonNameUtils.capitalize(logicalName);
        if (trailingName != null) {
            className = className + trailingName;
        }
        return className;
    }

    public static String getClassNameRepresentation(String name) {
        StringBuilder buf = new StringBuilder();
        if (name != null && name.length() > 0) {
            String[] tokens;
            for (String token1 : tokens = name.split("[^\\w\\d]")) {
                String token = token1.trim();
                buf.append(GriffonNameUtils.capitalize(token));
            }
        }
        return buf.toString();
    }

    public static String getClassNameForLowerCaseHyphenSeparatedName(String name) {
        if (GriffonNameUtils.isBlank(name)) {
            return name;
        }
        if (name.indexOf(45) > -1) {
            String[] tokens;
            StringBuilder buf = new StringBuilder();
            for (String token : tokens = name.split("-")) {
                if (token == null || token.length() == 0) continue;
                buf.append(GriffonNameUtils.capitalize(token));
            }
            return buf.toString();
        }
        return GriffonNameUtils.capitalize(name);
    }

    public static String getLogicalName(Class<?> clazz, String trailingName) {
        return GriffonNameUtils.getLogicalName(clazz.getName(), trailingName);
    }

    public static String getLogicalName(String name, String trailingName) {
        String shortName;
        if (!GriffonNameUtils.isBlank(trailingName) && (shortName = GriffonNameUtils.getShortName(name)).indexOf(trailingName) > -1) {
            return shortName.substring(0, shortName.length() - trailingName.length());
        }
        return name;
    }

    public static String getLogicalPropertyName(String className, String trailingName) {
        if (!GriffonNameUtils.isBlank(className) && !GriffonNameUtils.isBlank(trailingName) && className.length() == trailingName.length() + 1 && className.endsWith(trailingName)) {
            return className.substring(0, 1).toLowerCase();
        }
        return GriffonNameUtils.getLogicalName(GriffonNameUtils.getPropertyName(className), trailingName);
    }

    public static String getPropertyName(String name) {
        return GriffonNameUtils.getPropertyNameRepresentation(name);
    }

    public static String getPropertyName(Class<?> clazz) {
        return GriffonNameUtils.getPropertyNameRepresentation(clazz);
    }

    public static String getPropertyNameRepresentation(Class<?> targetClass) {
        String shortName = GriffonNameUtils.getShortName(targetClass);
        return GriffonNameUtils.getPropertyNameRepresentation(shortName);
    }

    public static String getPropertyNameRepresentation(String name) {
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            name = name.substring(pos + 1);
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(0)) && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        String propertyName = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        if (propertyName.indexOf(32) > -1) {
            propertyName = propertyName.replaceAll("\\s", "");
        }
        return propertyName;
    }

    public static String getPropertyNameForLowerCaseHyphenSeparatedName(String name) {
        return GriffonNameUtils.getPropertyName(GriffonNameUtils.getClassNameForLowerCaseHyphenSeparatedName(name));
    }

    public static String getShortName(Class<?> targetClass) {
        String className = targetClass.getName();
        return GriffonNameUtils.getShortName(className);
    }

    public static String getShortName(String className) {
        int i = className.lastIndexOf(".");
        if (i > -1) {
            className = className.substring(i + 1, className.length());
        }
        return className;
    }

    public static String getNaturalName(String name) {
        name = GriffonNameUtils.getShortName(name);
        ArrayList<String> words = new ArrayList<String>();
        int i = 0;
        char[] chars = name.toCharArray();
        for (int j = 0; j < chars.length; ++j) {
            String w;
            char c = chars[j];
            if (i >= words.size()) {
                w = "";
                words.add(i, w);
            } else {
                w = (String)words.get(i);
            }
            if (Character.isLowerCase(c) || Character.isDigit(c)) {
                if (Character.isLowerCase(c) && w.length() == 0) {
                    c = Character.toUpperCase(c);
                } else if (w.length() > 1 && Character.isUpperCase(w.charAt(w.length() - 1))) {
                    w = "";
                    words.add(++i, w);
                }
                words.set(i, w + c);
                continue;
            }
            if (!Character.isUpperCase(c)) continue;
            if (i == 0 && w.length() == 0 || Character.isUpperCase(w.charAt(w.length() - 1))) {
                words.set(i, w + c);
                continue;
            }
            words.add(++i, String.valueOf(c));
        }
        StringBuilder buf = new StringBuilder();
        Iterator j = words.iterator();
        while (j.hasNext()) {
            String word = (String)j.next();
            buf.append(word);
            if (!j.hasNext()) continue;
            buf.append(' ');
        }
        return buf.toString();
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String getHyphenatedName(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return GriffonNameUtils.getHyphenatedName(clazz.getName());
    }

    public static String getHyphenatedName(String name) {
        if (name == null) {
            return null;
        }
        if (name.endsWith(".groovy")) {
            name = name.substring(0, name.length() - 7);
        }
        String naturalName = GriffonNameUtils.getNaturalName(GriffonNameUtils.getShortName(name));
        return naturalName.replaceAll("\\s", "-").toLowerCase();
    }
}

