/*
 * Copyright 2005-2013 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 *
 * In applying this licence, ECMWF does not waive the privileges and immunities granted to it by
 * virtue of its status as an intergovernmental organisation nor does it submit to any jurisdiction.
 */
parameter parameters[] = {
   {
      "10_meter_u_velocity_sfc",
      -100,
      -1,
      1,
      100,
      {
         {"discipline", 0},
         {"parameterCategory", 2},
         {"parameterNumber", 2},
         {"scaleFactorOfFirstFixedSurface", 0},
         {"scaledValueOfFirstFixedSurface", 10},
         {"typeOfFirstFixedSurface", 103},
         {NULL, },
      },
      {&point_in_time, &given_level},
   },

   {
      "10_meter_v_velocity_sfc",
      -100,
      -1,
      1,
      100,
      {
         {"discipline", 0},
         {"parameterCategory", 2},
         {"parameterNumber", 3},
         {"scaleFactorOfFirstFixedSurface", 0},
         {"scaledValueOfFirstFixedSurface", 10},
         {"typeOfFirstFixedSurface", 103},
         {NULL, },
      },
      {&point_in_time, &given_level},
   },

   {
      "convective_available_potential_energy_sfc",
      0,
      0.1,
      0,
      17000,
      {
         {"discipline", 0},
         {"parameterCategory", 7},
         {"parameterNumber", 6},
         {"typeOfFirstFixedSurface", 1},
         {"typeOfSecondFixedSurface", 8},
         {NULL, },
      },
      {&point_in_time, &predefined_thickness},
   },

   {
      "convective_inhibition_sfc",
      -1800,
      0,
      -10,
      2000,
      {
         {"discipline", 0},
         {"parameterCategory", 7},
         {"parameterNumber", 7},
         {"typeOfFirstFixedSurface", 1},
         {"typeOfSecondFixedSurface", 8},
         {NULL, },
      },
      {&point_in_time, &predefined_thickness},
   },

   {
      "field_capacity_sfc",
      1e99,
      -1e99,
      99,
      -99,
      {
         {"discipline", 2},
         {"parameterCategory", 3},
         {"parameterNumber", 12},
         {"scaleFactorOfFirstFixedSurface", 0},
         {"scaleFactorOfSecondFixedSurface", 1},
         {"scaledValueOfFirstFixedSurface", 0},
         {"scaledValueOfSecondFixedSurface", 2},
         {"typeOfFirstFixedSurface", 106},
         {"typeOfSecondFixedSurface", 106},
         {NULL, },
      },
      {&point_in_time, &given_thickness, &has_bitmap},
   },

   {
      "geopotential_height_pl",
      -810,
      20000,
      320,
      22000,
      {
         {"discipline", 0},
         {"parameterCategory", 3},
         {"parameterNumber", 5},
         {"typeOfFirstFixedSurface", 100},
         {NULL, },
      },
      {&point_in_time, &given_level, &pressure_level},
   },

   {
      "land_sea_mask_sfc",
      0,
      0,
      1,
      1,
      {
         {"discipline", 2},
         {"parameterCategory", 0},
         {"parameterNumber", 0},
         {"typeOfFirstFixedSurface", 1},
         {NULL, },
      },
      {&point_in_time, &predefined_level},
   },

   {
      "mean_sea_level_pressure_sfc",
      91000,
      102000,
      99000,
      107000,
      {
         {"discipline", 0},
         {"parameterCategory", 3},
         {"parameterNumber", 0},
         {"typeOfFirstFixedSurface", 101},
         {NULL, },
      },
      {&point_in_time, &predefined_level},
   },

   {
      "orography_sfc",
      -1300,
      0,
      2000,
      8888,
      {
         {"discipline", 0},
         {"parameterCategory", 3},
         {"parameterNumber", 5},
         {"typeOfFirstFixedSurface", 1},
         {NULL, },
      },
      {&point_in_time, &predefined_level},
   },

   {
      "potential_temperature_pv",
      220,
      265,
      380,
      1200,
      {
         {"discipline", 0},
         {"parameterCategory", 0},
         {"parameterNumber", 2},
         {"typeOfFirstFixedSurface", 109},
         {NULL, },
      },
      {&point_in_time, &given_level, &potential_vorticity_level},
   },

   {
      "potential_vorticity_pt",
      -0.005,
      -1e-6,
      1e-6,
      0.002,
      {
         {"discipline", 0},
         {"parameterCategory", 2},
         {"parameterNumber", 14},
         {"scaleFactorOfFirstFixedSurface", 0},
         {"scaledValueOfFirstFixedSurface", 320},
         {"typeOfFirstFixedSurface", 107},
         {NULL, },
      },
      {&point_in_time, &given_level, &potential_temperature_level},
   },

   {
      "skin_temperature_sfc",
      180,
      210,
      320,
      355,
      {
         {"discipline", 0},
         {"parameterCategory", 0},
         {"parameterNumber", 17},
         {"typeOfFirstFixedSurface", 1},
         {NULL, },
      },
      {&point_in_time, &predefined_level},
   },

   {
      "snow_depth_water_equivalent_sfc",
      -4e-19,
      0,
      12000,
      15000,
      {
         {"discipline", 0},
         {"parameterCategory", 1},
         {"parameterNumber", 60},
         {"typeOfFirstFixedSurface", 1},
         {NULL, },
      },
      {&point_in_time, &predefined_level},
   },

   {
      "snow_fall_water_equivalent_sfc",
      -1e-9,
      -1e-9,
      3.5,
      3.5,
      {
         {"discipline", 0},
         {"parameterCategory", 1},
         {"parameterNumber", 53},
         {"typeOfFirstFixedSurface", 1},
         {"typeOfStatisticalProcessing", 1},
         {NULL, },
      },
      {&from_start, &predefined_level},
   },

   {
      "soil_moisture_sfc",
      -1e-18,
      0,
      450,
      500,
      {
         {"discipline", 2},
         {"parameterCategory", 0},
         {"parameterNumber", 22},
         {"scaleFactorOfFirstFixedSurface", 0},
         {"scaleFactorOfSecondFixedSurface", 1},
         {"scaledValueOfFirstFixedSurface", 0},
         {"scaledValueOfSecondFixedSurface", 2},
         {"typeOfFirstFixedSurface", 106},
         {"typeOfSecondFixedSurface", 106},
         {NULL, },
      },
      {&point_in_time, &given_thickness, &has_bitmap},
   },

   {
      "soil_temperature_sfc",
      200,
      230,
      310,
      350,
      {
         {"discipline", 2},
         {"parameterCategory", 0},
         {"parameterNumber", 2},
         {"scaleFactorOfFirstFixedSurface", 0},
         {"scaleFactorOfSecondFixedSurface", 1},
         {"scaledValueOfFirstFixedSurface", 0},
         {"scaledValueOfSecondFixedSurface", 2},
         {"typeOfFirstFixedSurface", 106},
         {"typeOfSecondFixedSurface", 106},
         {NULL, },
      },
      {&point_in_time, &given_thickness},
   },

   {
      "specific_humidity_pl",
      -1e-2,
      1e-4,
      0.0001,
      0.050,
      {
         {"discipline", 0},
         {"parameterCategory", 1},
         {"parameterNumber", 0},
         {"typeOfFirstFixedSurface", 100},
         {NULL, },
      },
      {&point_in_time, &given_level, &pressure_level},
   },

   {
      "sunshine_duration_sfc",
      0,
      0,
      3600.00000001,
      3600.00000001,
      {
         {"discipline", 0},
         {"parameterCategory", 6},
         {"parameterNumber", 24},
         {"typeOfFirstFixedSurface", 1},
         {"typeOfStatisticalProcessing", 1},
         {NULL, },
      },
      {&from_start, &predefined_level},
   },

   {
      "surface_air_temperature_sfc",
      180,
      290,
      270,
      350,
      {
         {"discipline", 0},
         {"parameterCategory", 0},
         {"parameterNumber", 0},
         {"typeOfFirstFixedSurface", 103},
         {NULL, },
      },
      {&point_in_time, &given_level},
   },

   {
      "surface_air_dew_point_temperature_sfc",
      180,
      290,
      270,
      350,
      {
         {"discipline", 0},
         {"parameterCategory", 0},
         {"parameterNumber", 6},
         {"typeOfFirstFixedSurface", 103},
         {NULL, },
      },
      {&point_in_time, &given_level},
   },

   {
      "surface_air_maximum_temperature_sfc",
      190,
      230,
      310,
      330,
      {
         {"discipline", 0},
         {"parameterCategory", 0},
         {"parameterNumber", 0},
         {"typeOfFirstFixedSurface", 103},
         {"typeOfStatisticalProcessing", 2},
         {NULL, },
      },
      {&six_hourly, &given_level},
   },

   {
      "surface_air_minimum_temperature_sfc",
      190,
      230,
      310,
      320,
      {
         {"discipline", 0},
         {"parameterCategory", 0},
         {"parameterNumber", 0},
         {"typeOfFirstFixedSurface", 103},
         {"typeOfStatisticalProcessing", 3},
         {NULL, },
      },
      {&six_hourly, &given_level},
   },


   {
      "surface_pressure_sfc",
      48000,
      50500,
      103000,
      110000,
      {
         {"discipline", 0},
         {"parameterCategory", 3},
         {"parameterNumber", 0},
         {"typeOfFirstFixedSurface", 1},
         {NULL, },
      },
      {&point_in_time, &predefined_level},
   },

   {
      "temperature_pl",
      185,
      250,
      230,
      330,
      {
         {"discipline", 0},
         {"parameterCategory", 0},
         {"parameterNumber", 0},
         {"typeOfFirstFixedSurface", 100},
         {NULL, },
      },
      {&point_in_time, &given_level, &pressure_level},
   },

   {
      "time_integrated_outgoing_long_wave_radiation_sfc",
      -1.5e+6,
      -1.5e+6,
      -300000,
      -300000,
      {
         {"discipline", 0},
         {"parameterCategory", 5},
         {"parameterNumber", 5},
         {"typeOfFirstFixedSurface", 8},
         {"typeOfStatisticalProcessing", 1},
         {NULL, },
      },
      {&from_start, &predefined_level},
   },

   {
      "time_integrated_surface_latent_heat_flux_sfc",
      -4e+6,
      -4e+6,
      700000,
      700000,
      {
         {"discipline", 0},
         {"parameterCategory", 0},
         {"parameterNumber", 10},
         {"typeOfFirstFixedSurface", 1},
         {"typeOfStatisticalProcessing", 1},
         {NULL, },
      },
      {&from_start, &predefined_level},
   },

   {
      "time_integrated_surface_net_solar_radiation_sfc",
      0,
      0,
      4e+6,
      4e+6,
      {
         {"discipline", 0},
         {"parameterCategory", 4},
         {"parameterNumber", 9},
         {"typeOfFirstFixedSurface", 1},
         {"typeOfStatisticalProcessing", 1},
         {NULL, },
      },
      {&from_start, &predefined_level},
   },

   {
      "time_integrated_surface_net_thermal_radiation_sfc",
      -1.1e+6,
      -1.1e+6,
      700000,
      700000,
      {
         {"discipline", 0},
         {"parameterCategory", 5},
         {"parameterNumber", 5},
         {"typeOfFirstFixedSurface", 1},
         {"typeOfStatisticalProcessing", 1},
         {NULL, },
      },
      {&from_start, &predefined_level},
   },

   {
      "time_integrated_surface_sensible_heat_flux_sfc",
      -3e+6,
      -3e+6,
      1.5e+6,
      1.5e+6,
      {
         {"discipline", 0},
         {"parameterCategory", 0},
         {"parameterNumber", 11},
         {"typeOfFirstFixedSurface", 1},
         {"typeOfStatisticalProcessing", 1},
         {NULL, },
      },
      {&from_start, &predefined_level},
   },

   {
      "total_cloud_cover_sfc",
      0,
      1e-10,
      100,
      100.00001,
      {
         {"discipline", 0},
         {"parameterCategory", 6},
         {"parameterNumber", 1},
         {"typeOfFirstFixedSurface", 1},
         {"typeOfSecondFixedSurface", 8},
         {NULL, },
      },
      {&point_in_time, &predefined_thickness},
   },

   {
      "total_column_water_sfc",
      0.1,
      0.21,
      75,
      150,
      {
         {"discipline", 0},
         {"parameterCategory", 1},
         {"parameterNumber", 51},
         {"typeOfFirstFixedSurface", 1},
         {"typeOfSecondFixedSurface", 8},
         {NULL, },
      },
      {&point_in_time, &predefined_thickness},
   },

/*hourly extreems for cumulated parameters! */
/* 133 because of cosmo-de boundary effects when coupled with IFS */
   {
      "total_precipitation_sfc",
      -0.05,
      0.1,
      0.,
      133.,
      {
         {"discipline", 0},
         {"parameterCategory", 1},
         {"parameterNumber", 52},
         {"typeOfFirstFixedSurface", 1},
         {"typeOfStatisticalProcessing", 1},
         {NULL, },
      },
      {&from_start, &predefined_level},
   },

/*hourly extreems for cumulated parameters! */
   {
      "large_scale_precipitation_sfc",
      -0.05,
      0.1,
      0.0,
      100.,
      {
         {"discipline", 0},
         {"parameterCategory", 1},
         {"parameterNumber", 54},
         {"typeOfFirstFixedSurface", 1},
         {"typeOfStatisticalProcessing", 1},
         {NULL, },
      },
      {&from_start, &predefined_level},
   },

   {
      "u_velocity_pl",
      -120,
      -20,
      20,
      120,
      {
         {"discipline", 0},
         {"parameterCategory", 2},
         {"parameterNumber", 2},
         {"typeOfFirstFixedSurface", 100},
         {NULL, },
      },
      {&point_in_time, &given_level, &pressure_level},
   },

   {
      "u_velocity_pv",
      -120,
      -30,
      70,
      120,
      {
         {"discipline", 0},
         {"parameterCategory", 2},
         {"parameterNumber", 2},
         {"typeOfFirstFixedSurface", 109},
         {NULL, },
      },
      {&point_in_time, &given_level, &potential_vorticity_level},
   },

   {
      "v_velocity_pl",
      -120,
      -20,
      20,
      120,
      {
         {"discipline", 0},
         {"parameterCategory", 2},
         {"parameterNumber", 3},
         {"typeOfFirstFixedSurface", 100},
         {NULL, },
      },
      {&point_in_time, &given_level, &pressure_level},
   },

   {
      "v_velocity_pv",
      -120,
      -50,
      55,
      120,
      {
         {"discipline", 0},
         {"parameterCategory", 2},
         {"parameterNumber", 3},
         {"typeOfFirstFixedSurface", 109},
         {NULL, },
      },
      {&point_in_time, &given_level, &potential_vorticity_level},
   },

   {
      "wilting_point_sfc",
      1e99,
      -1e99,
      99,
      -99,
      {
         {"discipline", 2},
         {"parameterCategory", 0},
         {"parameterNumber", 26},
         {"scaleFactorOfFirstFixedSurface", 0},
         {"scaleFactorOfSecondFixedSurface", 1},
         {"scaledValueOfFirstFixedSurface", 0},
         {"scaledValueOfSecondFixedSurface", 2},
         {"typeOfFirstFixedSurface", 106},
         {"typeOfSecondFixedSurface", 106},
         {NULL, },
      },
      {&point_in_time, &given_thickness, &has_bitmap},
   },
   {
      "maximum_wind_gust",
      0,
      10,
      0,
      100,
      {
         {"discipline", 0},
         {"parameterCategory", 2},
         {"parameterNumber", 22},
         {"scaleFactorOfFirstFixedSurface", 0},
         {"scaledValueOfFirstFixedSurface", 10},
         {"typeOfFirstFixedSurface", 103},
         {NULL, },
      },
      {&three_hourly, &given_level},
   },

};
