/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache;

import io.micronaut.cache.AsyncCache;
import io.micronaut.cache.SyncCache;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

@Internal
public class DelegatingAsyncCache<C>
implements AsyncCache<C> {
    private final SyncCache<C> delegate;
    private final ExecutorService executorService;

    public DelegatingAsyncCache(SyncCache<C> delegate, ExecutorService executorService) {
        this.delegate = delegate;
        this.executorService = executorService;
    }

    @Override
    public <T> CompletableFuture<Optional<T>> get(Object key, Argument<T> requiredType) {
        return CompletableFuture.supplyAsync(() -> this.delegate.get(key, requiredType), this.executorService);
    }

    @Override
    public <T> CompletableFuture<T> get(Object key, Argument<T> requiredType, Supplier<T> supplier) {
        return CompletableFuture.supplyAsync(() -> this.delegate.get(key, requiredType, supplier), this.executorService);
    }

    @Override
    public <T> CompletableFuture<Optional<T>> putIfAbsent(Object key, T value) {
        return CompletableFuture.supplyAsync(() -> this.delegate.putIfAbsent(key, value), this.executorService);
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public C getNativeCache() {
        return this.delegate.getNativeCache();
    }

    @Override
    public CompletableFuture<Boolean> put(Object key, Object value) {
        return CompletableFuture.supplyAsync(() -> {
            this.delegate.put(key, value);
            return true;
        }, this.executorService);
    }

    @Override
    public CompletableFuture<Boolean> invalidate(Object key) {
        return CompletableFuture.supplyAsync(() -> {
            this.delegate.invalidate(key);
            return true;
        }, this.executorService);
    }

    @Override
    public CompletableFuture<Boolean> invalidateAll() {
        return CompletableFuture.supplyAsync(() -> {
            this.delegate.invalidateAll();
            return true;
        }, this.executorService);
    }
}

