/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import io.micronaut.ast.groovy.utils.AstAnnotationUtils;
import io.micronaut.ast.groovy.utils.AstGenericUtils;
import io.micronaut.ast.groovy.utils.ExtendedParameter;
import io.micronaut.ast.groovy.visitor.AbstractGroovyElement;
import io.micronaut.ast.groovy.visitor.GroovyClassElement;
import io.micronaut.ast.groovy.visitor.GroovyParameterElement;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.control.SourceUnit;

public class GroovyMethodElement
extends AbstractGroovyElement
implements MethodElement {
    private final SourceUnit sourceUnit;
    private final MethodNode methodNode;
    private final GroovyClassElement declaringClass;
    private Map<String, ClassNode> genericsSpec = null;
    private ClassElement declaringElement;
    private ParameterElement[] parameters;

    GroovyMethodElement(GroovyClassElement declaringClass, GroovyVisitorContext visitorContext, MethodNode methodNode, AnnotationMetadata annotationMetadata) {
        super(visitorContext, (AnnotatedNode)methodNode, annotationMetadata);
        this.methodNode = methodNode;
        this.sourceUnit = visitorContext.getSourceUnit();
        this.declaringClass = declaringClass;
    }

    public Set<ElementModifier> getModifiers() {
        return this.resolveModifiers(this.methodNode);
    }

    public String toString() {
        return this.methodNode.toString();
    }

    public String getName() {
        return this.methodNode.getName();
    }

    public boolean isAbstract() {
        return this.methodNode.isAbstract();
    }

    public boolean isStatic() {
        return this.methodNode.isStatic();
    }

    public boolean isPublic() {
        return this.methodNode.isPublic() || this.methodNode.isSyntheticPublic();
    }

    public boolean isPrivate() {
        return this.methodNode.isPrivate();
    }

    public boolean isFinal() {
        return this.methodNode.isFinal();
    }

    public boolean isProtected() {
        return this.methodNode.isProtected();
    }

    public Object getNativeType() {
        return this.methodNode;
    }

    @NonNull
    public ClassElement getGenericReturnType() {
        ClassNode returnType = this.methodNode.getReturnType();
        ClassElement rawElement = this.getReturnType();
        return this.getGenericElement(returnType, rawElement);
    }

    @NonNull
    ClassElement getGenericElement(@NonNull ClassNode type, @NonNull ClassElement rawElement) {
        Map<String, ClassNode> genericsSpec = this.getGenericsSpec();
        return this.getGenericElement(this.sourceUnit, type, rawElement, genericsSpec);
    }

    @NonNull
    Map<String, ClassNode> getGenericsSpec() {
        if (this.genericsSpec == null) {
            Map<String, ClassNode> typeGenericInfo;
            Map<String, Map<String, ClassNode>> info = this.declaringClass.getGenericTypeInfo();
            if (CollectionUtils.isNotEmpty(info) && CollectionUtils.isNotEmpty(typeGenericInfo = info.get(this.methodNode.getDeclaringClass().getName()))) {
                this.genericsSpec = AstGenericUtils.createGenericsSpec(this.methodNode, new HashMap<String, ClassNode>(typeGenericInfo));
            }
            if (this.genericsSpec == null) {
                this.genericsSpec = Collections.emptyMap();
            }
        }
        return this.genericsSpec;
    }

    @NonNull
    public ClassElement getReturnType() {
        return this.visitorContext.getElementFactory().newClassElement(this.methodNode.getReturnType(), AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)this.methodNode.getReturnType()));
    }

    public ParameterElement[] getParameters() {
        Parameter[] parameters = this.methodNode.getParameters();
        if (this.parameters == null) {
            this.parameters = (ParameterElement[])Arrays.stream(parameters).map(parameter -> new GroovyParameterElement(this, this.visitorContext, (Parameter)parameter, AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, new ExtendedParameter(this.methodNode, (Parameter)parameter)))).toArray(ParameterElement[]::new);
        }
        return this.parameters;
    }

    public MethodElement withNewParameters(final ParameterElement ... newParameters) {
        final ParameterElement[] existing = this.getParameters();
        return new GroovyMethodElement(this.declaringClass, this.visitorContext, this.methodNode, this.getAnnotationMetadata()){

            @Override
            public ParameterElement[] getParameters() {
                return (ParameterElement[])ArrayUtils.concat((Object[])existing, (Object[])newParameters);
            }
        };
    }

    public ClassElement getDeclaringType() {
        if (this.declaringElement == null) {
            this.declaringElement = this.visitorContext.getElementFactory().newClassElement(this.methodNode.getDeclaringClass(), AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)this.methodNode.getDeclaringClass()));
        }
        return this.declaringElement;
    }

    public ClassElement getOwningType() {
        return this.declaringClass;
    }
}

