/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.uaa.client.internal;

import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.springframework.uaa.client.ProxyService;

public class BasicProxyService
implements ProxyService {
    public Proxy setupProxy(URL url) {
        List<Proxy> proxies = null;
        try {
            proxies = ProxySelector.getDefault().select(url.toURI());
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        if (proxies != null) {
            for (Proxy proxy : proxies) {
                if (!proxy.type().equals((Object)Proxy.Type.HTTP)) continue;
                return proxy;
            }
        }
        return null;
    }

    public Authenticator setupProxyAuthentication(URL url, Proxy proxy) {
        return null;
    }

    public HttpURLConnection prepareHttpUrlConnection(URL url) throws IOException {
        Proxy proxy = this.setupProxy(url);
        Authenticator proxyAuthentication = this.setupProxyAuthentication(url, proxy);
        if (proxyAuthentication != null) {
            Authenticator.setDefault(proxyAuthentication);
        }
        HttpURLConnection connection = (HttpURLConnection)(proxy != null ? url.openConnection(proxy) : url.openConnection());
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.setUseCaches(false);
        return connection;
    }
}

