/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.collection;

import java.util.Collection;
import java.util.Map;
import org.springframework.binding.collection.MapAdaptable;
import org.springframework.util.Assert;

public class MapAccessor
implements MapAdaptable {
    private Map map;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public MapAccessor(Map map) {
        Assert.notNull((Object)map, (String)"The map to decorate is required");
        this.map = map;
    }

    public Map asMap() {
        return this.map;
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public Object get(Object key, Object defaultValue) {
        if (!this.map.containsKey(key)) {
            return defaultValue;
        }
        return this.map.get(key);
    }

    public Object get(Object key, Class requiredType) throws IllegalArgumentException {
        return this.get(key, requiredType, null);
    }

    public Object get(Object key, Class requiredType, Object defaultValue) {
        if (!this.map.containsKey(key)) {
            return defaultValue;
        }
        return this.assertKeyValueOfType(key, requiredType);
    }

    public Object getRequired(Object key) throws IllegalArgumentException {
        this.assertContainsKey(key);
        return this.map.get(key);
    }

    public Object getRequired(Object key, Class requiredType) throws IllegalArgumentException {
        this.assertContainsKey(key);
        return this.assertKeyValueOfType(key, requiredType);
    }

    public String getString(Object key) throws IllegalArgumentException {
        return this.getString(key, null);
    }

    public String getString(Object key, String defaultValue) throws IllegalArgumentException {
        if (!this.map.containsKey(key)) {
            return defaultValue;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (String)this.assertKeyValueOfType(key, clazz);
    }

    public String getRequiredString(Object key) throws IllegalArgumentException {
        this.assertContainsKey(key);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (String)this.assertKeyValueOfType(key, clazz);
    }

    public Collection getCollection(Object key) throws IllegalArgumentException {
        if (!this.map.containsKey(key)) {
            return null;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Collection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Collection)this.assertKeyValueOfType(key, clazz);
    }

    public Collection getCollection(Object key, Class requiredType) throws IllegalArgumentException {
        if (!this.map.containsKey(key)) {
            return null;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Collection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.assertAssignableTo(clazz, requiredType);
        return (Collection)this.assertKeyValueOfType(key, requiredType);
    }

    public Collection getRequiredCollection(Object key) throws IllegalArgumentException {
        this.assertContainsKey(key);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Collection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Collection)this.assertKeyValueOfType(key, clazz);
    }

    public Collection getRequiredCollection(Object key, Class requiredType) throws IllegalArgumentException {
        this.assertContainsKey(key);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Collection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.assertAssignableTo(clazz, requiredType);
        return (Collection)this.assertKeyValueOfType(key, requiredType);
    }

    public Object[] getArray(Object key, Class requiredType) throws IllegalArgumentException {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("[Ljava.lang.Object;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.assertAssignableTo(clazz, requiredType);
        if (!this.map.containsKey(key)) {
            return null;
        }
        return (Object[])this.assertKeyValueOfType(key, requiredType);
    }

    public Object[] getRequiredArray(Object key, Class requiredType) throws IllegalArgumentException {
        this.assertContainsKey(key);
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("[Ljava.lang.Object;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.assertAssignableTo(clazz, requiredType);
        return (Object[])this.assertKeyValueOfType(key, requiredType);
    }

    public Number getNumber(Object key, Class requiredType) throws IllegalArgumentException {
        return this.getNumber(key, requiredType, null);
    }

    public Number getNumber(Object key, Class requiredType, Number defaultValue) throws IllegalArgumentException {
        if (!this.map.containsKey(key)) {
            return defaultValue;
        }
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.assertAssignableTo(clazz, requiredType);
        return (Number)this.assertKeyValueOfType(key, requiredType);
    }

    public Number getRequiredNumber(Object key, Class requiredType) throws IllegalArgumentException {
        this.assertContainsKey(key);
        return (Number)this.assertKeyValueOfType(key, requiredType);
    }

    public Integer getInteger(Object key) throws IllegalArgumentException {
        return this.getInteger(key, null);
    }

    public Integer getInteger(Object key, Integer defaultValue) throws IllegalArgumentException {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Integer)this.getNumber(key, clazz, defaultValue);
    }

    public Integer getRequiredInteger(Object key) throws IllegalArgumentException {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Integer)this.getRequiredNumber(key, clazz);
    }

    public Long getLong(Object key) throws IllegalArgumentException {
        return this.getLong(key, null);
    }

    public Long getLong(Object key, Long defaultValue) throws IllegalArgumentException {
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Long)this.getNumber(key, clazz, defaultValue);
    }

    public Long getRequiredLong(Object key) throws IllegalArgumentException {
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Long)this.getRequiredNumber(key, clazz);
    }

    public Boolean getBoolean(Object key) throws IllegalArgumentException {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(Object key, Boolean defaultValue) throws IllegalArgumentException {
        if (!this.map.containsKey(key)) {
            return defaultValue;
        }
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Boolean)this.assertKeyValueOfType(key, clazz);
    }

    public Boolean getRequiredBoolean(Object key) throws IllegalArgumentException {
        this.assertContainsKey(key);
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Boolean)this.assertKeyValueOfType(key, clazz);
    }

    public void assertContainsKey(Object key) throws IllegalArgumentException {
        if (!this.map.containsKey(key)) {
            throw new IllegalArgumentException("Required attribute '" + key + "' is not present in map; attributes present are [" + this.asMap() + "]");
        }
    }

    public boolean containsKey(Object key, Class requiredType) throws IllegalArgumentException {
        if (this.map.containsKey(key)) {
            this.assertKeyValueOfType(key, requiredType);
            return true;
        }
        return false;
    }

    public Object assertKeyValueOfType(Object key, Class requiredType) {
        return this.assertKeyValueInstanceOf(key, this.map.get(key), requiredType);
    }

    public Object assertKeyValueInstanceOf(Object key, Object value, Class requiredType) {
        Assert.notNull((Object)requiredType, (String)"The required type to assert is required");
        if (value != null && !requiredType.isInstance(value)) {
            throw new IllegalArgumentException("Map key '" + key + "' has value [" + value + "] that is not of expected type [" + requiredType + "], instead it is of type [" + value.getClass().getName() + "]");
        }
        return value;
    }

    private void assertAssignableTo(Class clazz, Class requiredType) {
        Assert.isTrue((boolean)clazz.isAssignableFrom(requiredType), (String)("The provided required type must be assignable to [" + clazz + "]"));
    }
}

