+++
# -----------------------------------------------------------------------
# Do not edit this file. It is automatically generated by API Documenter.
# -----------------------------------------------------------------------
title = "DataSourceSrv"
keywords = ["grafana","documentation","sdk","@grafana/runtime"]
type = "docs"
+++

## DataSourceSrv interface

This is the entry point for communicating with a datasource that is added as a plugin (both external and internal). Via this service you will get access to the [DataSourceApi](./data/datasourceapi.md) that have a rich API for communicating with the datasource.

<b>Signature</b>

```typescript
export interface DataSourceSrv 
```
<b>Import</b>

```typescript
import { DataSourceSrv } from '@grafana/runtime';
```
<b>Methods</b>

|  Method | Description |
|  --- | --- |
|  [get(name, scopedVars)](#get-method) |  |
|  [getDataSourceSettingsByUid(uid)](#getdatasourcesettingsbyuid-method) | Returns metadata based on UID. |

### get method

<b>Signature</b>

```typescript
get(name?: string, scopedVars?: ScopedVars): Promise<DataSourceApi>;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  name | <code>string</code> | name of the datasource plugin you want to use. |
|  scopedVars | <code>ScopedVars</code> | variables used to interpolate a templated passed as name. |

<b>Returns:</b>

`Promise<DataSourceApi>`

### getDataSourceSettingsByUid method

Returns metadata based on UID.

<b>Signature</b>

```typescript
getDataSourceSettingsByUid(uid: string): DataSourceInstanceSettings | undefined;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  uid | <code>string</code> |  |

<b>Returns:</b>

`DataSourceInstanceSettings | undefined`

