+++
# -----------------------------------------------------------------------
# Do not edit this file. It is automatically generated by API Documenter.
# -----------------------------------------------------------------------
title = "PanelProps"
keywords = ["grafana","documentation","sdk","@grafana/data"]
type = "docs"
+++

## PanelProps interface

<b>Signature</b>

```typescript
export interface PanelProps<T = any> 
```
<b>Import</b>

```typescript
import { PanelProps } from '@grafana/data';
```
<b>Properties</b>

|  Property | Type | Description |
|  --- | --- | --- |
|  [data](#data-property) | <code>PanelData</code> | Result set of panel queries |
|  [fieldConfig](#fieldconfig-property) | <code>FieldConfigSource</code> | Field options configuration |
|  [height](#height-property) | <code>number</code> | Current height of the panel |
|  [id](#id-property) | <code>number</code> | ID of the panel within the current dashboard |
|  [onChangeTimeRange](#onchangetimerange-property) | <code>(timeRange: AbsoluteTimeRange) =&gt; void</code> | Time range change handler |
|  [onFieldConfigChange](#onfieldconfigchange-property) | <code>(config: FieldConfigSource) =&gt; void</code> | Field config change handler |
|  [onOptionsChange](#onoptionschange-property) | <code>(options: T) =&gt; void</code> | Panel options change handler |
|  [options](#options-property) | <code>T</code> | Panel options |
|  [replaceVariables](#replacevariables-property) | <code>InterpolateFunction</code> | Template variables interpolation function |
|  [timeRange](#timerange-property) | <code>TimeRange</code> | Time range of the current dashboard |
|  [timeZone](#timezone-property) | <code>TimeZone</code> | Time zone of the current dashboard |
|  [transparent](#transparent-property) | <code>boolean</code> | Indicathes whether or not panel should be rendered transparent |
|  [width](#width-property) | <code>number</code> | Current width of the panel |

### data property

Result set of panel queries

<b>Signature</b>

```typescript
data: PanelData;
```

### fieldConfig property

Field options configuration

<b>Signature</b>

```typescript
fieldConfig: FieldConfigSource;
```

### height property

Current height of the panel

<b>Signature</b>

```typescript
height: number;
```

### id property

ID of the panel within the current dashboard

<b>Signature</b>

```typescript
id: number;
```

### onChangeTimeRange property

Time range change handler

<b>Signature</b>

```typescript
onChangeTimeRange: (timeRange: AbsoluteTimeRange) => void;
```

### onFieldConfigChange property

Field config change handler

<b>Signature</b>

```typescript
onFieldConfigChange: (config: FieldConfigSource) => void;
```

### onOptionsChange property

Panel options change handler

<b>Signature</b>

```typescript
onOptionsChange: (options: T) => void;
```

### options property

Panel options

<b>Signature</b>

```typescript
options: T;
```

### replaceVariables property

Template variables interpolation function

<b>Signature</b>

```typescript
replaceVariables: InterpolateFunction;
```

### timeRange property

Time range of the current dashboard

<b>Signature</b>

```typescript
timeRange: TimeRange;
```

### timeZone property

Time zone of the current dashboard

<b>Signature</b>

```typescript
timeZone: TimeZone;
```

### transparent property

Indicathes whether or not panel should be rendered transparent

<b>Signature</b>

```typescript
transparent: boolean;
```

### width property

Current width of the panel

<b>Signature</b>

```typescript
width: number;
```
