+++
# -----------------------------------------------------------------------
# Do not edit this file. It is automatically generated by API Documenter.
# -----------------------------------------------------------------------
title = "FieldCache"
keywords = ["grafana","documentation","sdk","@grafana/data"]
type = "docs"
+++

## FieldCache class

<b>Signature</b>

```typescript
export declare class FieldCache 
```
<b>Import</b>

```typescript
import { FieldCache } from '@grafana/data';
```
<b>Constructors</b>

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [constructor(data)](#constructor-data) |  | Constructs a new instance of the <code>FieldCache</code> class |

<b>Properties</b>

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [fields](#fields-property) |  | <code>FieldWithIndex[]</code> |  |

<b>Methods</b>

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [getFieldByName(name)](#getfieldbyname-method) |  | Returns the first field with the given name. |
|  [getFields(type)](#getfields-method) |  |  |
|  [getFirstFieldOfType(type, includeHidden)](#getfirstfieldoftype-method) |  |  |
|  [hasFieldNamed(name)](#hasfieldnamed-method) |  |  |
|  [hasFieldOfType(type)](#hasfieldoftype-method) |  |  |
|  [hasFieldWithNameAndType(name, type)](#hasfieldwithnameandtype-method) |  |  |

### constructor(data)

Constructs a new instance of the `FieldCache` class

<b>Signature</b>

```typescript
constructor(data: DataFrame);
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  data | <code>DataFrame</code> |  |

### fields property

<b>Signature</b>

```typescript
fields: FieldWithIndex[];
```

### getFieldByName method

Returns the first field with the given name.

<b>Signature</b>

```typescript
getFieldByName(name: string): FieldWithIndex | undefined;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  name | <code>string</code> |  |

<b>Returns:</b>

`FieldWithIndex | undefined`

### getFields method

<b>Signature</b>

```typescript
getFields(type?: FieldType): FieldWithIndex[];
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  type | <code>FieldType</code> |  |

<b>Returns:</b>

`FieldWithIndex[]`

### getFirstFieldOfType method

<b>Signature</b>

```typescript
getFirstFieldOfType(type: FieldType, includeHidden?: boolean): FieldWithIndex | undefined;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  type | <code>FieldType</code> |  |
|  includeHidden | <code>boolean</code> |  |

<b>Returns:</b>

`FieldWithIndex | undefined`

### hasFieldNamed method

<b>Signature</b>

```typescript
hasFieldNamed(name: string): boolean;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  name | <code>string</code> |  |

<b>Returns:</b>

`boolean`

### hasFieldOfType method

<b>Signature</b>

```typescript
hasFieldOfType(type: FieldType): boolean;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  type | <code>FieldType</code> |  |

<b>Returns:</b>

`boolean`

### hasFieldWithNameAndType method

<b>Signature</b>

```typescript
hasFieldWithNameAndType(name: string, type: FieldType): boolean;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  name | <code>string</code> |  |
|  type | <code>FieldType</code> |  |

<b>Returns:</b>

`boolean`

