/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http.ntlm;

import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;

public class NTLMCredentials {
    private static final String DEFAULT_DOMAIN = "";
    private static final String DEFAULT_WORKSTATION = "";
    private final String domain;
    private final String username;
    private final String password;
    private final String workstation;

    public NTLMCredentials(String username, String password) {
        String domain;
        Preconditions.checkNotNull((Object)username, (Object)"Username must not be null!");
        int slashPos = username.indexOf(92);
        int n = slashPos = slashPos >= 0 ? slashPos : username.indexOf(47);
        if (slashPos >= 0) {
            domain = username.substring(0, slashPos);
            username = username.substring(slashPos + 1);
        } else {
            domain = System.getProperty("http.auth.ntlm.domain", "");
        }
        this.domain = domain == null ? null : domain.toUpperCase(Locale.ROOT);
        this.username = username;
        this.password = password;
        this.workstation = this.determineWorkstationName();
    }

    private String determineWorkstationName() {
        String sysPropWorkstation = System.getProperty("http.auth.ntlm.workstation");
        if (sysPropWorkstation != null) {
            return sysPropWorkstation;
        }
        try {
            return this.removeDotSuffix(this.getHostName()).toUpperCase(Locale.ROOT);
        }
        catch (UnknownHostException e) {
            return "";
        }
    }

    protected String getHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    private String removeDotSuffix(String val) {
        int dotPos = val.indexOf(46);
        return dotPos == -1 ? val : val.substring(0, dotPos);
    }

    public String getDomain() {
        return this.domain;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getWorkstation() {
        return this.workstation;
    }

    public String toString() {
        return String.format("NTLM Credentials [user: %s, domain: %s, workstation: %s]", this.username, this.domain, this.workstation);
    }
}

