/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.processors;

import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.internal.Factory;

public class RestartEveryNTestClassProcessor
implements TestClassProcessor {
    private final Factory<TestClassProcessor> factory;
    private final long restartEvery;
    private long testCount;
    private TestResultProcessor resultProcessor;
    private volatile boolean stoppedNow;
    private volatile TestClassProcessor processor;

    public RestartEveryNTestClassProcessor(Factory<TestClassProcessor> factory, long restartEvery) {
        this.factory = factory;
        this.restartEvery = restartEvery;
    }

    public void startProcessing(TestResultProcessor resultProcessor) {
        this.resultProcessor = resultProcessor;
    }

    public void processTestClass(TestClassRunInfo testClass) {
        if (this.stoppedNow) {
            return;
        }
        if (this.processor == null) {
            this.processor = (TestClassProcessor)this.factory.create();
            this.processor.startProcessing(this.resultProcessor);
        }
        this.processor.processTestClass(testClass);
        ++this.testCount;
        if (this.testCount == this.restartEvery) {
            this.endBatch();
        }
    }

    public void stop() {
        if (this.processor != null) {
            this.endBatch();
        }
    }

    public void stopNow() {
        this.stoppedNow = true;
        TestClassProcessor toStop = this.processor;
        if (toStop != null) {
            toStop.stopNow();
        }
    }

    private void endBatch() {
        try {
            this.processor.stop();
        }
        finally {
            this.processor = null;
            this.testCount = 0L;
        }
    }
}

