/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.gradle.internal.serialize.Decoder;

public abstract class AbstractDecoder
implements Decoder {
    private DecoderStream stream;

    @Override
    public InputStream getInputStream() {
        if (this.stream == null) {
            this.stream = new DecoderStream();
        }
        return this.stream;
    }

    @Override
    public void readBytes(byte[] buffer) throws IOException {
        this.readBytes(buffer, 0, buffer.length);
    }

    @Override
    public byte[] readBinary() throws EOFException, IOException {
        int size = this.readSmallInt();
        byte[] result = new byte[size];
        this.readBytes(result);
        return result;
    }

    @Override
    public int readSmallInt() throws EOFException, IOException {
        return this.readInt();
    }

    @Override
    public long readSmallLong() throws EOFException, IOException {
        return this.readLong();
    }

    @Override
    @Nullable
    public Integer readNullableSmallInt() throws IOException {
        if (this.readBoolean()) {
            return this.readSmallInt();
        }
        return null;
    }

    @Override
    public String readNullableString() throws EOFException, IOException {
        if (this.readBoolean()) {
            return this.readString();
        }
        return null;
    }

    @Override
    public void skipBytes(long count) throws EOFException, IOException {
        long remaining;
        long skipped;
        for (remaining = count; remaining > 0L && (skipped = this.maybeSkip(remaining)) > 0L; remaining -= skipped) {
        }
        if (remaining > 0L) {
            throw new EOFException();
        }
    }

    @Override
    public <T> T decodeChunked(Decoder.DecodeAction<Decoder, T> decodeAction) throws EOFException, Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void skipChunked() throws EOFException, IOException {
        throw new UnsupportedOperationException();
    }

    protected abstract int maybeReadBytes(byte[] var1, int var2, int var3) throws IOException;

    protected abstract long maybeSkip(long var1) throws IOException;

    private class DecoderStream
    extends InputStream {
        byte[] buffer = new byte[1];

        private DecoderStream() {
        }

        @Override
        public long skip(long n) throws IOException {
            return AbstractDecoder.this.maybeSkip(n);
        }

        @Override
        public int read() throws IOException {
            int read = AbstractDecoder.this.maybeReadBytes(this.buffer, 0, 1);
            if (read <= 0) {
                return read;
            }
            return this.buffer[0] & 0xFF;
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            return AbstractDecoder.this.maybeReadBytes(buffer, 0, buffer.length);
        }

        @Override
        public int read(byte[] buffer, int offset, int count) throws IOException {
            return AbstractDecoder.this.maybeReadBytes(buffer, offset, count);
        }
    }
}

