/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.context;

import com.google.common.base.Joiner;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.context.DaemonRequestContext;
import org.gradle.launcher.daemon.toolchain.DaemonJvmCriteria;

public class DefaultDaemonContext
implements DaemonContext {
    public static final org.gradle.internal.serialize.Serializer<DefaultDaemonContext> SERIALIZER = new Serializer();
    private final String uid;
    private final File javaHome;
    private final File daemonRegistryDir;
    private final Long pid;
    private final Integer idleTimeout;
    private final Collection<String> daemonOpts;
    private final boolean applyInstrumentationAgent;
    private final DaemonParameters.Priority priority;
    private final NativeServices.NativeServicesMode nativeServicesMode;
    private final JavaLanguageVersion javaVersion;

    public DefaultDaemonContext(String uid, File javaHome, JavaLanguageVersion javaVersion, File daemonRegistryDir, Long pid, Integer idleTimeout, Collection<String> daemonOpts, boolean applyInstrumentationAgent, NativeServices.NativeServicesMode nativeServicesMode, DaemonParameters.Priority priority) {
        this.uid = uid;
        this.javaHome = javaHome;
        this.javaVersion = javaVersion;
        this.daemonRegistryDir = daemonRegistryDir;
        this.pid = pid;
        this.idleTimeout = idleTimeout;
        this.daemonOpts = daemonOpts;
        this.applyInstrumentationAgent = applyInstrumentationAgent;
        this.priority = priority;
        this.nativeServicesMode = nativeServicesMode;
    }

    public String toString() {
        return String.format("DefaultDaemonContext[uid=%s,javaHome=%s,javaVersion=%s,daemonRegistryDir=%s,pid=%s,idleTimeout=%s,priority=%s,applyInstrumentationAgent=%s,nativeServicesMode=%s,daemonOpts=%s]", new Object[]{this.uid, this.javaHome, this.javaVersion, this.daemonRegistryDir, this.pid, this.idleTimeout, this.priority, this.applyInstrumentationAgent, this.nativeServicesMode, Joiner.on((char)',').join(this.daemonOpts)});
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public File getJavaHome() {
        return this.javaHome;
    }

    @Override
    public JavaLanguageVersion getJavaVersion() {
        return this.javaVersion;
    }

    @Override
    public File getDaemonRegistryDir() {
        return this.daemonRegistryDir;
    }

    @Override
    public Long getPid() {
        return this.pid;
    }

    @Override
    public Integer getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public Collection<String> getDaemonOpts() {
        return this.daemonOpts;
    }

    @Override
    public boolean shouldApplyInstrumentationAgent() {
        return this.applyInstrumentationAgent;
    }

    @Override
    public NativeServices.NativeServicesMode getNativeServicesMode() {
        return this.nativeServicesMode;
    }

    @Override
    public DaemonParameters.Priority getPriority() {
        return this.priority;
    }

    @Override
    public DaemonRequestContext toRequest() {
        return new DaemonRequestContext(new DaemonJvmCriteria.JavaHome(DaemonJvmCriteria.JavaHome.Source.EXISTING_DAEMON, this.javaHome), this.getDaemonOpts(), this.shouldApplyInstrumentationAgent(), this.getNativeServicesMode(), this.getPriority());
    }

    static class Serializer
    implements org.gradle.internal.serialize.Serializer<DefaultDaemonContext> {
        Serializer() {
        }

        public DefaultDaemonContext read(Decoder decoder) throws Exception {
            String uid = decoder.readNullableString();
            String pathname = decoder.readString();
            File javaHome = new File(pathname);
            JavaLanguageVersion javaVersion = JavaLanguageVersion.of((int)decoder.readSmallInt());
            File registryDir = new File(decoder.readString());
            Long pid = decoder.readBoolean() ? Long.valueOf(decoder.readLong()) : null;
            Integer idle = decoder.readBoolean() ? Integer.valueOf(decoder.readInt()) : null;
            int daemonOptCount = decoder.readInt();
            ArrayList<String> daemonOpts = new ArrayList<String>(daemonOptCount);
            for (int i = 0; i < daemonOptCount; ++i) {
                daemonOpts.add(decoder.readString());
            }
            boolean applyInstrumentationAgent = decoder.readBoolean();
            NativeServices.NativeServicesMode nativeServicesMode = NativeServices.NativeServicesMode.values()[decoder.readSmallInt()];
            DaemonParameters.Priority priority = decoder.readBoolean() ? DaemonParameters.Priority.values()[decoder.readInt()] : null;
            return new DefaultDaemonContext(uid, javaHome, javaVersion, registryDir, pid, idle, daemonOpts, applyInstrumentationAgent, nativeServicesMode, priority);
        }

        public void write(Encoder encoder, DefaultDaemonContext context) throws Exception {
            encoder.writeNullableString((CharSequence)context.uid);
            encoder.writeString((CharSequence)context.javaHome.getPath());
            encoder.writeSmallInt(context.javaVersion.asInt());
            encoder.writeString((CharSequence)context.daemonRegistryDir.getPath());
            encoder.writeBoolean(context.pid != null);
            if (context.pid != null) {
                encoder.writeLong(context.pid.longValue());
            }
            encoder.writeBoolean(context.idleTimeout != null);
            if (context.idleTimeout != null) {
                encoder.writeInt(context.idleTimeout.intValue());
            }
            encoder.writeInt(context.daemonOpts.size());
            for (String daemonOpt : context.daemonOpts) {
                encoder.writeString((CharSequence)daemonOpt);
            }
            encoder.writeBoolean(context.applyInstrumentationAgent);
            encoder.writeSmallInt(context.nativeServicesMode.ordinal());
            encoder.writeBoolean(context.priority != null);
            if (context.priority != null) {
                encoder.writeInt(context.priority.ordinal());
            }
        }
    }
}

