/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.io.File;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.JavaVersion;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.attributes.java.TargetJvmVersion;
import org.gradle.api.attributes.plugin.GradlePluginApiVersion;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.dsl.DependencyHandlerInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactoryInternal;
import org.gradle.api.internal.initialization.ScriptClassPathResolutionContext;
import org.gradle.api.internal.initialization.ScriptClassPathResolver;
import org.gradle.api.internal.initialization.transform.registration.InstrumentationTransformRegisterer;
import org.gradle.api.internal.initialization.transform.services.CacheInstrumentationDataBuildService;
import org.gradle.api.internal.initialization.transform.utils.InstrumentationClasspathMerger;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.internal.agents.AgentStatus;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.TransformedClassPath;
import org.gradle.internal.component.local.model.OpaqueComponentIdentifier;
import org.gradle.internal.lazy.Lazy;
import org.gradle.util.GradleVersion;

public class DefaultScriptClassPathResolver
implements ScriptClassPathResolver {
    private static final Set<DependencyFactoryInternal.ClassPathNotation> GRADLE_API_NOTATIONS = EnumSet.of(DependencyFactoryInternal.ClassPathNotation.GRADLE_API, DependencyFactoryInternal.ClassPathNotation.LOCAL_GROOVY);
    public static final Attribute<String> INSTRUMENTED_ATTRIBUTE = Attribute.of((String)"org.gradle.internal.instrumented", String.class);
    private final NamedObjectInstantiator instantiator;
    private final InstrumentationTransformRegisterer instrumentationTransformRegisterer;

    public DefaultScriptClassPathResolver(NamedObjectInstantiator instantiator, AgentStatus agentStatus, Gradle gradle) {
        this.instantiator = instantiator;
        this.instrumentationTransformRegisterer = new InstrumentationTransformRegisterer(agentStatus, (Lazy<BuildServiceRegistry>)Lazy.atomic().of(() -> ((Gradle)gradle).getSharedServices()));
    }

    @Override
    public ScriptClassPathResolutionContext prepareDependencyHandler(DependencyHandler dependencyHandler) {
        ((DependencyHandlerInternal)dependencyHandler).getDefaultArtifactAttributes().attribute(INSTRUMENTED_ATTRIBUTE, (Object)InstrumentationPhase.NOT_INSTRUMENTED.value);
        return this.instrumentationTransformRegisterer.registerTransforms(dependencyHandler);
    }

    @Override
    public void prepareClassPath(Configuration configuration, ScriptClassPathResolutionContext resolutionContext) {
        AttributeContainer attributes = configuration.getAttributes();
        attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)this.instantiator.named(Usage.class, "java-runtime")));
        attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.instantiator.named(Category.class, "library")));
        attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)this.instantiator.named(LibraryElements.class, "jar")));
        attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)this.instantiator.named(Bundling.class, "external")));
        attributes.attribute(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE, (Object)Integer.parseInt(JavaVersion.current().getMajorVersion()));
        attributes.attribute(GradlePluginApiVersion.GRADLE_PLUGIN_API_VERSION_ATTRIBUTE, (Object)((GradlePluginApiVersion)this.instantiator.named(GradlePluginApiVersion.class, GradleVersion.current().getVersion())));
        DependencyHandler dependencyHandler = resolutionContext.getDependencyHandler();
        configuration.getDependencyConstraints().add((Object)dependencyHandler.getConstraints().create((Object)"org.apache.logging.log4j:log4j-core", constraint -> constraint.version(version -> {
            version.require("2.17.1");
            version.reject(new String[]{"[2.0, 2.17.1)"});
        })));
    }

    @Override
    public ClassPath resolveClassPath(Configuration classpathConfiguration, ScriptClassPathResolutionContext resolutionContext) {
        long contextId = resolutionContext.getContextId();
        CacheInstrumentationDataBuildService buildService = (CacheInstrumentationDataBuildService)resolutionContext.getBuildService().get();
        try (CacheInstrumentationDataBuildService.ResolutionScope resolutionScope = buildService.newResolutionScope(contextId);){
            ArtifactView originalDependencies = DefaultScriptClassPathResolver.getOriginalDependencies(classpathConfiguration);
            resolutionScope.setTypeHierarchyAnalysisResult(this.getAnalysisResult(classpathConfiguration));
            resolutionScope.setOriginalClasspath(originalDependencies.getFiles());
            ArtifactCollection instrumentedExternalDependencies = DefaultScriptClassPathResolver.getInstrumentedExternalDependencies(classpathConfiguration);
            ArtifactCollection instrumentedProjectDependencies = DefaultScriptClassPathResolver.getInstrumentedProjectDependencies(classpathConfiguration);
            List<File> instrumentedClasspath = InstrumentationClasspathMerger.mergeToClasspath(originalDependencies.getArtifacts(), instrumentedExternalDependencies, instrumentedProjectDependencies);
            ClassPath classPath = TransformedClassPath.handleInstrumentingArtifactTransform(instrumentedClasspath);
            return classPath;
        }
    }

    private FileCollection getAnalysisResult(Configuration classpathConfiguration) {
        return classpathConfiguration.getIncoming().artifactView(config -> {
            config.attributes(attributes -> {
                attributes.attribute(INSTRUMENTED_ATTRIBUTE, (Object)InstrumentationPhase.ANALYZED_ARTIFACT.value);
                attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)this.instantiator.named(LibraryElements.class, "classes")));
            });
            config.componentFilter(componentId -> !DefaultScriptClassPathResolver.isGradleApi(componentId));
        }).getFiles();
    }

    private static ArtifactView getOriginalDependencies(Configuration classpathConfiguration) {
        return classpathConfiguration.getIncoming().artifactView(config -> config.componentFilter(it -> !DefaultScriptClassPathResolver.isGradleApi(it)));
    }

    private static ArtifactCollection getInstrumentedExternalDependencies(Configuration classpathConfiguration) {
        return classpathConfiguration.getIncoming().artifactView(config -> {
            config.attributes(it -> it.attribute(INSTRUMENTED_ATTRIBUTE, (Object)InstrumentationPhase.INSTRUMENTED_AND_UPGRADED.value));
            config.componentFilter(DefaultScriptClassPathResolver::isExternalDependency);
        }).getArtifacts();
    }

    private static ArtifactCollection getInstrumentedProjectDependencies(Configuration classpathConfiguration) {
        return classpathConfiguration.getIncoming().artifactView(config -> {
            config.attributes(it -> it.attribute(INSTRUMENTED_ATTRIBUTE, (Object)InstrumentationPhase.INSTRUMENTED_ONLY.value));
            config.componentFilter(DefaultScriptClassPathResolver::isProjectDependency);
        }).getArtifacts();
    }

    private static boolean isGradleApi(ComponentIdentifier componentId) {
        if (componentId instanceof OpaqueComponentIdentifier) {
            DependencyFactoryInternal.ClassPathNotation classPathNotation = ((OpaqueComponentIdentifier)componentId).getClassPathNotation();
            return GRADLE_API_NOTATIONS.contains((Object)classPathNotation);
        }
        return false;
    }

    private static boolean isProjectDependency(ComponentIdentifier componentId) {
        if (componentId instanceof OpaqueComponentIdentifier) {
            return ((OpaqueComponentIdentifier)componentId).getClassPathNotation() == DependencyFactoryInternal.ClassPathNotation.LOCAL_PROJECT_AS_OPAQUE_DEPENDENCY;
        }
        return componentId instanceof ProjectComponentIdentifier;
    }

    private static boolean isExternalDependency(ComponentIdentifier componentId) {
        return !DefaultScriptClassPathResolver.isGradleApi(componentId) && !DefaultScriptClassPathResolver.isProjectDependency(componentId);
    }

    public static enum InstrumentationPhase {
        NOT_INSTRUMENTED("not-instrumented"),
        ANALYZED_ARTIFACT("analyzed-artifact"),
        MERGED_ARTIFACT_ANALYSIS("merged-artifact-analysis"),
        INSTRUMENTED_AND_UPGRADED("instrumented-and-upgraded"),
        INSTRUMENTED_ONLY("instrumented-only");

        private final String value;

        private InstrumentationPhase(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

