/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.intercept;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.gradle.api.GradleException;
import org.gradle.internal.classpath.intercept.InterceptScope;
import org.gradle.internal.classpath.intercept.Invocation;
import org.gradle.internal.classpath.intercept.MethodHandleInvocation;
import org.gradle.internal.instrumentation.api.types.BytecodeInterceptor;

public abstract class CallInterceptor
implements BytecodeInterceptor {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final MethodHandle INTERCEPTOR;
    private final InterceptScope[] interceptScopes;

    protected CallInterceptor(InterceptScope ... interceptScopes) {
        this.interceptScopes = interceptScopes;
    }

    public abstract Object doIntercept(Invocation var1, String var2) throws Throwable;

    MethodHandle decorateMethodHandle(MethodHandle original, MethodHandles.Lookup caller, int flags) {
        MethodHandle spreader = original.asSpreader(Object[].class, original.type().parameterCount());
        MethodHandle decorated = MethodHandles.insertArguments(INTERCEPTOR, 0, this, spreader, flags, caller.lookupClass().getName());
        return decorated.asCollector(Object[].class, original.type().parameterCount()).asType(original.type());
    }

    private Object interceptMethodHandle(MethodHandle original, int flags, String consumer, Object[] args) throws Throwable {
        boolean isSpread = (flags & 0x10) != 0;
        return this.doIntercept(new MethodHandleInvocation(original, args, isSpread), consumer);
    }

    InterceptScope[] getInterceptScopes() {
        return this.interceptScopes;
    }

    static {
        try {
            INTERCEPTOR = LOOKUP.findVirtual(CallInterceptor.class, "interceptMethodHandle", MethodType.methodType(Object.class, MethodHandle.class, Integer.TYPE, String.class, Object[].class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new GradleException("Failed to set up an interceptor method", (Throwable)e);
        }
    }
}

