/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.events;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.BooleanUtils;
import org.gradle.internal.Either;
import org.gradle.internal.logging.events.PromptOutputEvent;

public class BooleanQuestionPromptEvent
extends PromptOutputEvent {
    private static final List<String> LENIENT_YES_NO_CHOICES = Lists.newArrayList((Object[])new String[]{"yes", "no", "y", "n"});
    private final boolean defaultValue;
    private final String defaultString;

    public BooleanQuestionPromptEvent(long timestamp, String prompt, boolean defaultValue, String defaultString) {
        super(timestamp, prompt, true);
        this.defaultValue = defaultValue;
        this.defaultString = defaultString;
    }

    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    public String getDefaultString() {
        return this.defaultString;
    }

    public Either<Boolean, String> convert(String text) {
        if (text.isEmpty()) {
            return Either.left((Object)this.defaultValue);
        }
        String trimmed = text.toLowerCase(Locale.US).trim();
        if (LENIENT_YES_NO_CHOICES.contains(trimmed)) {
            return Either.left((Object)BooleanUtils.toBoolean((String)trimmed));
        }
        return Either.right((Object)("Please enter 'yes' or 'no' (default: '" + this.defaultString + "'): "));
    }
}

