/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan.edges;

import java.util.Set;
import java.util.SortedSet;
import java.util.function.Consumer;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.NodeSets;
import org.gradle.execution.plan.edges.DependencyPredecessorsOnlyNodeSet;
import org.gradle.execution.plan.edges.DependentNodesSet;

class ComplexDependentNodesSet
implements DependentNodesSet {
    private final DependencyPredecessorsOnlyNodeSet dependencyPredecessors;
    private final SortedSet<Node> mustPredecessors = NodeSets.newSortedNodeSet();
    private final SortedSet<Node> finalizers = NodeSets.newSortedNodeSet();

    public ComplexDependentNodesSet(DependencyPredecessorsOnlyNodeSet dependencyPredecessors) {
        this.dependencyPredecessors = dependencyPredecessors;
    }

    @Override
    public SortedSet<Node> getDependencyPredecessors() {
        return this.dependencyPredecessors.getDependencyPredecessors();
    }

    @Override
    public DependentNodesSet addDependencyPredecessors(Node fromNode) {
        this.dependencyPredecessors.addDependencyPredecessors(fromNode);
        return this;
    }

    @Override
    public SortedSet<Node> getFinalizers() {
        return this.finalizers;
    }

    @Override
    public DependentNodesSet addFinalizer(Node finalizer) {
        this.finalizers.add(finalizer);
        return this;
    }

    @Override
    public Set<Node> getMustPredecessors() {
        return this.mustPredecessors;
    }

    @Override
    public DependentNodesSet addMustPredecessor(Node fromNode) {
        this.mustPredecessors.add(fromNode);
        return this;
    }

    @Override
    public void visitAllNodes(Consumer<Node> visitor) {
        this.dependencyPredecessors.visitAllNodes(visitor);
        for (Node node : this.mustPredecessors) {
            visitor.accept(node);
        }
        for (Node node : this.finalizers) {
            node.getFinalizerGroup().visitAllMembers(visitor);
        }
    }
}

