/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import javax.annotation.Nullable;

public enum TargetJdk {
    VERSION_1_3,
    VERSION_1_4,
    VERSION_1_5,
    VERSION_1_6,
    VERSION_1_7,
    VERSION_JSP;


    @Nullable
    public static TargetJdk toVersion(@Nullable Object value) throws IllegalArgumentException {
        if (value == null) {
            return null;
        }
        if (value instanceof TargetJdk) {
            return (TargetJdk)((Object)value);
        }
        String name = value.toString();
        if (name.equalsIgnoreCase("1.7")) {
            return VERSION_1_7;
        }
        if (name.equalsIgnoreCase("1.6")) {
            return VERSION_1_6;
        }
        if (name.equalsIgnoreCase("1.5")) {
            return VERSION_1_5;
        }
        if (name.equalsIgnoreCase("1.4")) {
            return VERSION_1_4;
        }
        if (name.equalsIgnoreCase("1.3")) {
            return VERSION_1_3;
        }
        if (name.equalsIgnoreCase("jsp")) {
            return VERSION_JSP;
        }
        throw new IllegalArgumentException(String.format("Could not determine targetjdk from '%s'.", name));
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name().substring("VERSION_".length()).replace('_', '.').toLowerCase();
    }
}

