/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.ReachabilityChecker;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;

class PedestrianReachabilityChecker
implements ReachabilityChecker {
    private final boolean topoSort;
    private final RevWalk walk;

    public PedestrianReachabilityChecker(boolean topoSort, RevWalk walk) {
        this.topoSort = topoSort;
        this.walk = walk;
    }

    @Override
    public Optional<RevCommit> areAllReachable(Collection<RevCommit> targets, Stream<RevCommit> starters) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.walk.reset();
        if (this.topoSort) {
            this.walk.sort(RevSort.TOPO);
        }
        for (RevCommit target : targets) {
            this.walk.markStart(target);
        }
        Iterator iterator = starters.iterator();
        while (iterator.hasNext()) {
            this.walk.markUninteresting((RevCommit)iterator.next());
        }
        return Optional.ofNullable(this.walk.next());
    }
}

