/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.gwt.dev.js.ThrowExceptionOnErrorReporter;
import org.jetbrains.kotlin.com.google.gwt.dev.js.rhino.CodePosition;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.backend.ast.DelegatingJsFunctionScopeWithTemporaryParent;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsRootScope;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.RewriteUtilsKt;
import org.jetbrains.kotlin.js.parser.ParserUtilsKt;
import org.jetbrains.kotlin.js.resolve.BindingContextSlicesJsKt;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCallChecker;
import org.jetbrains.kotlin.js.sourceMap.PsiUtils;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.AbstractCallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.FunctionImportedFromObject;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;

public final class CallExpressionTranslator
extends AbstractCallExpressionTranslator {
    @NotNull
    public static JsNode translate(@NotNull KtCallExpression expression2, @Nullable JsExpression receiver, @NotNull TranslationContext context) {
        ResolvedCall<? extends FunctionDescriptor> resolvedCall2;
        if (expression2 == null) {
            CallExpressionTranslator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            CallExpressionTranslator.$$$reportNull$$$0(1);
        }
        if (JsCallChecker.isJsCall(resolvedCall2 = CallUtilKt.getFunctionResolvedCallWithAssert(expression2, context.bindingContext()))) {
            return new CallExpressionTranslator(expression2, receiver, context).translateJsCode();
        }
        return new CallExpressionTranslator(expression2, receiver, context).translate();
    }

    public static boolean shouldBeInlined(@NotNull CallableDescriptor descriptor2, @NotNull TranslationContext context) {
        if (descriptor2 == null) {
            CallExpressionTranslator.$$$reportNull$$$0(2);
        }
        if (context == null) {
            CallExpressionTranslator.$$$reportNull$$$0(3);
        }
        if (context.getConfig().getConfiguration().getBoolean(CommonConfigurationKeys.DISABLE_INLINE)) {
            return false;
        }
        return CallExpressionTranslator.shouldBeInlined(descriptor2);
    }

    public static boolean shouldBeInlined(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            CallExpressionTranslator.$$$reportNull$$$0(4);
        }
        if (descriptor2 instanceof SimpleFunctionDescriptor || descriptor2 instanceof PropertyAccessorDescriptor || descriptor2 instanceof FunctionImportedFromObject) {
            return InlineUtil.isInline(descriptor2);
        }
        if (descriptor2 instanceof ValueParameterDescriptor) {
            return InlineUtil.isInline(descriptor2.getContainingDeclaration()) && InlineUtil.isInlineParameter((ParameterDescriptor)descriptor2) && !((ValueParameterDescriptor)descriptor2).isCrossinline();
        }
        return false;
    }

    private CallExpressionTranslator(@NotNull KtCallExpression expression2, @Nullable JsExpression receiver, @NotNull TranslationContext context) {
        if (expression2 == null) {
            CallExpressionTranslator.$$$reportNull$$$0(5);
        }
        if (context == null) {
            CallExpressionTranslator.$$$reportNull$$$0(6);
        }
        super(expression2, receiver, context);
    }

    @NotNull
    private JsExpression translate() {
        JsExpression jsExpression = CallTranslator.translate(this.context(), this.resolvedCall, this.receiver);
        if (jsExpression == null) {
            CallExpressionTranslator.$$$reportNull$$$0(7);
        }
        return jsExpression;
    }

    @NotNull
    private JsNode translateJsCode() {
        JsStatement resultStatement;
        List<KtValueArgument> arguments2 = this.expression.getValueArguments();
        KtExpression argumentExpression = ((ValueArgument)arguments2.get(0)).getArgumentExpression();
        assert (argumentExpression != null);
        List<JsStatement> statements2 = this.parseJsCode(argumentExpression);
        int size = statements2.size();
        JsNode node = size == 0 ? new JsNullLiteral() : (size > 1 ? new JsBlock(statements2) : ((resultStatement = statements2.get(0)) instanceof JsExpressionStatement ? ((JsExpressionStatement)resultStatement).getExpression() : resultStatement));
        LexicalScope lexicalScope = this.context().bindingContext().get(BindingContextSlicesJsKt.LEXICAL_SCOPE_FOR_JS, this.resolvedCall);
        HashMap<JsName, JsExpression> replacements = new HashMap<JsName, JsExpression>();
        if (lexicalScope != null) {
            Set<JsName> references = CollectUtilsKt.collectUsedNames(node);
            references.removeAll(CollectUtilsKt.collectDefinedNames(node));
            for (JsName name2 : references) {
                VariableDescriptor variable2 = CallExpressionTranslator.getVariableByName(lexicalScope, Name.identifier(name2.getIdent()));
                if (variable2 == null) continue;
                replacements.put(name2, ReferenceTranslator.translateAsValueReference(variable2, this.context()));
            }
            if (!replacements.isEmpty()) {
                node = RewriteUtilsKt.replaceNames(node, replacements);
            }
        }
        JsNode jsNode = node;
        if (jsNode == null) {
            CallExpressionTranslator.$$$reportNull$$$0(8);
        }
        return jsNode;
    }

    @Nullable
    private static VariableDescriptor getVariableByName(@NotNull LexicalScope scope2, @NotNull Name name2) {
        if (scope2 == null) {
            CallExpressionTranslator.$$$reportNull$$$0(9);
        }
        if (name2 == null) {
            CallExpressionTranslator.$$$reportNull$$$0(10);
        }
        while (true) {
            Collection<? extends VariableDescriptor> variables2;
            if (!(variables2 = scope2.getContributedVariables(name2, NoLookupLocation.FROM_BACKEND)).isEmpty()) {
                return variables2.size() == 1 ? variables2.iterator().next() : null;
            }
            if (!(scope2.getParent() instanceof LexicalScope)) break;
            LexicalScope parentScope = (LexicalScope)scope2.getParent();
            if (scope2.getOwnerDescriptor() != parentScope.getOwnerDescriptor()) break;
            scope2 = parentScope;
        }
        return null;
    }

    @NotNull
    private List<JsStatement> parseJsCode(@NotNull KtExpression jsCodeExpression) {
        JsLocation location;
        if (jsCodeExpression == null) {
            CallExpressionTranslator.$$$reportNull$$$0(11);
        }
        String jsCode = JsCallChecker.extractStringValue(ConstantExpressionEvaluator.getConstant(jsCodeExpression, this.context().bindingContext()));
        assert (jsCode != null) : "jsCode must be compile time string " + jsCodeExpression.getText();
        JsScope currentScope2 = this.context().scope();
        assert (currentScope2 instanceof JsFunctionScope) : "Usage of js outside of function is unexpected";
        JsRootScope temporaryRootScope = new JsRootScope(new JsProgram());
        DelegatingJsFunctionScopeWithTemporaryParent scope2 = new DelegatingJsFunctionScopeWithTemporaryParent((JsFunctionScope)currentScope2, temporaryRootScope);
        try {
            location = PsiUtils.extractLocationFromPsi(jsCodeExpression, this.context().getSourceFilePathResolver());
        }
        catch (IOException e) {
            location = new JsLocation(jsCodeExpression.getContainingKtFile().getName(), 0, 0);
        }
        List<JsStatement> statements2 = ParserUtilsKt.parseExpressionOrStatement(jsCode, ThrowExceptionOnErrorReporter.INSTANCE, scope2, new CodePosition(location.getStartLine(), location.getStartChar()), location.getFile());
        List<JsStatement> list2 = statements2 != null ? statements2 : Collections.emptyList();
        if (list2 == null) {
            CallExpressionTranslator.$$$reportNull$$$0(12);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsCodeExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "translateJsCode";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "parseJsCode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "translate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeInlined";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 12: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVariableByName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseJsCode";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 8: 
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

