/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.lang;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.lang.ClassPath;
import org.jetbrains.kotlin.com.intellij.util.lang.ClasspathCache;
import org.jetbrains.kotlin.com.intellij.util.lang.JarLoader;
import org.jetbrains.kotlin.com.intellij.util.lang.Resource;
import org.jetbrains.kotlin.com.intellij.util.lang.ResourceFile;
import org.jetbrains.kotlin.com.intellij.util.lang.SecureJarLoader;

final class JdkZipResourceFile
implements ResourceFile {
    private volatile SoftReference<ZipFile> zipFileSoftReference;
    private final boolean lockJars;
    private final File file;
    private final boolean isSecureLoader;
    private static final Object lock = new Object();

    JdkZipResourceFile(@NotNull Path path2, boolean lockJars, boolean isSecureLoader) {
        if (path2 == null) {
            JdkZipResourceFile.$$$reportNull$$$0(0);
        }
        this.lockJars = lockJars;
        this.file = path2.toFile();
        this.isSecureLoader = isSecureLoader;
    }

    private static byte @NotNull [] loadBytes(@NotNull InputStream stream, int length) throws IOException {
        int n;
        if (stream == null) {
            JdkZipResourceFile.$$$reportNull$$$0(1);
        }
        byte[] bytes = new byte[length];
        for (int count = 0; count < length && (n = stream.read(bytes, count, length - count)) > 0; count += n) {
        }
        if (bytes == null) {
            JdkZipResourceFile.$$$reportNull$$$0(2);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    ZipFile getZipFile() throws IOException {
        ZipFile zipFile2;
        if (!this.lockJars) {
            ZipFile zipFile3 = this.createZipFile(this.file);
            if (zipFile3 == null) {
                JdkZipResourceFile.$$$reportNull$$$0(3);
            }
            return zipFile3;
        }
        SoftReference<ZipFile> ref = this.zipFileSoftReference;
        ZipFile zipFile4 = zipFile2 = ref == null ? null : ref.get();
        if (zipFile2 != null) {
            ZipFile zipFile5 = zipFile2;
            if (zipFile5 == null) {
                JdkZipResourceFile.$$$reportNull$$$0(4);
            }
            return zipFile5;
        }
        Object object = lock;
        synchronized (object) {
            ref = this.zipFileSoftReference;
            ZipFile zipFile6 = zipFile2 = ref == null ? null : ref.get();
            if (zipFile2 != null) {
                ZipFile zipFile7 = zipFile2;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl19 : MonitorExitStatement: MONITOREXIT : var3_3
                if (zipFile7 == null) {
                    JdkZipResourceFile.$$$reportNull$$$0(5);
                }
                return zipFile7;
            }
            zipFile2 = this.createZipFile(this.file);
            this.zipFileSoftReference = new SoftReference<ZipFile>(zipFile2);
        }
        ZipFile zipFile8 = zipFile2;
        if (zipFile8 == null) {
            JdkZipResourceFile.$$$reportNull$$$0(6);
        }
        return zipFile8;
    }

    private ZipFile createZipFile(@NotNull File file2) throws IOException {
        if (file2 == null) {
            JdkZipResourceFile.$$$reportNull$$$0(7);
        }
        return this.isSecureLoader ? new JarFile(file2) : new ZipFile(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Class<?> findClass(@NotNull String fileName, String className2, JarLoader jarLoader, ClassPath.ClassDataConsumer classConsumer) throws IOException {
        if (fileName == null) {
            JdkZipResourceFile.$$$reportNull$$$0(8);
        }
        ZipFile zipFile2 = this.getZipFile();
        try {
            byte[] bytes;
            ZipEntry entry = zipFile2.getEntry(fileName);
            if (entry == null) {
                Class<?> clazz = null;
                return clazz;
            }
            try (InputStream stream = zipFile2.getInputStream(entry);){
                bytes = JdkZipResourceFile.loadBytes(stream, (int)entry.getSize());
            }
            ProtectionDomain protectionDomain = jarLoader instanceof SecureJarLoader ? ((SecureJarLoader)jarLoader).getProtectionDomain((JarEntry)entry, new URL(jarLoader.url, entry.getName())) : null;
            Class<?> clazz = classConsumer.consumeClassData(className2, bytes, jarLoader, protectionDomain);
            return clazz;
        }
        finally {
            if (!this.lockJars) {
                zipFile2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Resource getResource(@NotNull String name2, @NotNull JarLoader jarLoader) throws IOException {
        if (name2 == null) {
            JdkZipResourceFile.$$$reportNull$$$0(12);
        }
        if (jarLoader == null) {
            JdkZipResourceFile.$$$reportNull$$$0(13);
        }
        ZipFile zipFile2 = this.getZipFile();
        try {
            ZipEntry entry = zipFile2.getEntry(name2);
            if (entry == null) {
                Resource resource = null;
                return resource;
            }
            if (this.isSecureLoader) {
                SecureJarResource secureJarResource = new SecureJarResource(jarLoader.url, (JarEntry)entry, (SecureJarLoader)jarLoader);
                return secureJarResource;
            }
            ZipFileResource zipFileResource = new ZipFileResource(jarLoader.url, entry, this);
            return zipFileResource;
        }
        finally {
            if (!this.lockJars) {
                zipFile2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Attributes loadManifestAttributes() throws IOException {
        ZipFile zipFile2 = this.getZipFile();
        try {
            Attributes attributes2;
            block14: {
                ZipEntry entry = zipFile2.getEntry("META-INF/MANIFEST.MF");
                if (entry == null) {
                    Attributes attributes3 = null;
                    return attributes3;
                }
                InputStream stream = zipFile2.getInputStream(entry);
                try {
                    attributes2 = new Manifest(stream).getMainAttributes();
                    if (stream == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        Attributes attributes4 = null;
                        return attributes4;
                    }
                }
                stream.close();
            }
            return attributes2;
        }
        finally {
            if (!this.lockJars) {
                zipFile2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ClasspathCache.IndexRegistrar buildClassPathCacheData() throws IOException {
        ZipFile zipFile2 = this.getZipFile();
        ClasspathCache.LoaderDataBuilder builder2 = new ClasspathCache.LoaderDataBuilder(true);
        Enumeration<? extends ZipEntry> entries = zipFile2.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name2 = entry.getName();
            if (name2.endsWith(".class")) {
                builder2.addClassPackageFromName(name2);
                builder2.andClassName(name2);
                continue;
            }
            builder2.addResourcePackageFromName(name2);
            builder2.addResourceName(name2, name2.endsWith("/") ? name2.length() - 1 : name2.length());
        }
        ClasspathCache.LoaderDataBuilder loaderDataBuilder = builder2;
        ClasspathCache.LoaderDataBuilder loaderDataBuilder2 = loaderDataBuilder;
        if (loaderDataBuilder2 == null) {
            JdkZipResourceFile.$$$reportNull$$$0(14);
        }
        return loaderDataBuilder2;
        finally {
            if (!this.lockJars) {
                zipFile2.close();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/lang/JdkZipResourceFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/lang/JdkZipResourceFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBytes";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getZipFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildClassPathCacheData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadBytes";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createZipFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processResources";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getResource";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class SecureJarResource
    extends ZipFileResource {
        SecureJarResource(@NotNull URL baseUrl, @NotNull JarEntry entry, @NotNull SecureJarLoader jarLoader) {
            if (baseUrl == null) {
                SecureJarResource.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                SecureJarResource.$$$reportNull$$$0(1);
            }
            if (jarLoader == null) {
                SecureJarResource.$$$reportNull$$$0(2);
            }
            super(baseUrl, entry, (JdkZipResourceFile)jarLoader.zipFile);
        }

        /*
         * Loose catch block
         */
        @Override
        public byte @NotNull [] getBytes() throws IOException {
            byte[] byArray;
            InputStream stream;
            ZipFile zipFile2;
            block11: {
                block10: {
                    zipFile2 = this.file.getZipFile();
                    stream = zipFile2.getInputStream(this.entry);
                    byArray = JdkZipResourceFile.loadBytes(stream, (int)this.entry.getSize());
                    if (stream == null) break block10;
                    stream.close();
                }
                if (byArray != null) break block11;
                SecureJarResource.$$$reportNull$$$0(3);
            }
            return byArray;
            {
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            finally {
                if (!this.file.lockJars) {
                    zipFile2.close();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseUrl";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jarLoader";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/lang/JdkZipResourceFile$SecureJarResource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/lang/JdkZipResourceFile$SecureJarResource";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBytes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ZipFileResource
    implements Resource {
        protected final URL baseUrl;
        private URL url;
        protected final ZipEntry entry;
        protected final JdkZipResourceFile file;

        private ZipFileResource(@NotNull URL baseUrl, @NotNull ZipEntry entry, @NotNull JdkZipResourceFile file2) {
            if (baseUrl == null) {
                ZipFileResource.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                ZipFileResource.$$$reportNull$$$0(1);
            }
            if (file2 == null) {
                ZipFileResource.$$$reportNull$$$0(2);
            }
            this.baseUrl = baseUrl;
            this.entry = entry;
            this.file = file2;
        }

        public String toString() {
            return this.url.toString();
        }

        @Override
        @NotNull
        public URL getURL() {
            URL result2 = this.url;
            if (result2 == null) {
                try {
                    result2 = new URL(this.baseUrl, this.entry.getName());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
                this.url = result2;
            }
            URL uRL = result2;
            if (uRL == null) {
                ZipFileResource.$$$reportNull$$$0(3);
            }
            return uRL;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.getBytes());
        }

        /*
         * Loose catch block
         */
        public byte @NotNull [] getBytes() throws IOException {
            byte[] byArray;
            InputStream stream;
            ZipFile zipFile2;
            block11: {
                block10: {
                    zipFile2 = this.file.getZipFile();
                    stream = zipFile2.getInputStream(this.entry);
                    byArray = JdkZipResourceFile.loadBytes(stream, (int)this.entry.getSize());
                    if (stream == null) break block10;
                    stream.close();
                }
                if (byArray != null) break block11;
                ZipFileResource.$$$reportNull$$$0(4);
            }
            return byArray;
            {
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            finally {
                if (!this.file.lockJars) {
                    zipFile2.close();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseUrl";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/lang/JdkZipResourceFile$ZipFileResource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/lang/JdkZipResourceFile$ZipFileResource";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getURL";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBytes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

