/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.phaser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.LoggingContext;
import org.jetbrains.kotlin.backend.common.phaser.AbstractNamedCompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhaseKt;
import org.jetbrains.kotlin.backend.common.phaser.CrossFileCallAdjuster;
import org.jetbrains.kotlin.backend.common.phaser.PerformByIrFileKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfigurationService;
import org.jetbrains.kotlin.backend.common.phaser.PhaserState;
import org.jetbrains.kotlin.backend.common.phaser.SameTypeCompilerPhase;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u0003B-\u0012\u001e\u0010\u0005\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ0\u0010\f\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u000e\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f0\r0\u00062\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J3\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0018J;\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u001bJ3\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0005\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/backend/common/phaser/PerformByIrFilePhase;", "Context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "Lorg/jetbrains/kotlin/backend/common/phaser/SameTypeCompilerPhase;", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "lower", "", "Lorg/jetbrains/kotlin/backend/common/phaser/CompilerPhase;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "copyBeforeLowering", "", "(Ljava/util/List;Z)V", "getNamedSubphases", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/backend/common/phaser/AbstractNamedCompilerPhase;", "startDepth", "invoke", "phaseConfig", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfigurationService;", "phaserState", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaserState;", "context", "input", "(Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfigurationService;Lorg/jetbrains/kotlin/backend/common/phaser/PhaserState;Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;)Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "invokeParallel", "nThreads", "(Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfigurationService;Lorg/jetbrains/kotlin/backend/common/phaser/PhaserState;Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;I)Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "invokeSequential", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nperformByIrFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 performByIrFile.kt\norg/jetbrains/kotlin/backend/common/phaser/PerformByIrFilePhase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,224:1\n1549#2:225\n1620#2,3:226\n1549#2:230\n1620#2,3:231\n1360#2:234\n1446#2,5:235\n1#3:229\n*S KotlinDebug\n*F\n+ 1 performByIrFile.kt\norg/jetbrains/kotlin/backend/common/phaser/PerformByIrFilePhase\n*L\n93#1:225\n93#1:226,3\n130#1:230\n130#1:231,3\n146#1:234\n146#1:235,5\n*E\n"})
final class PerformByIrFilePhase<Context extends CommonBackendContext>
implements SameTypeCompilerPhase<Context, IrModuleFragment> {
    @NotNull
    private final List<CompilerPhase<Context, IrFile, IrFile>> lower;
    private final boolean copyBeforeLowering;

    public PerformByIrFilePhase(@NotNull List<? extends CompilerPhase<? super Context, IrFile, IrFile>> lower2, boolean copyBeforeLowering) {
        Intrinsics.checkNotNullParameter(lower2, (String)"lower");
        this.lower = lower2;
        this.copyBeforeLowering = copyBeforeLowering;
    }

    @Override
    @NotNull
    public IrModuleFragment invoke(@NotNull PhaseConfigurationService phaseConfig, @NotNull PhaserState<IrModuleFragment> phaserState, @NotNull Context context, @NotNull IrModuleFragment input) {
        int nThreads;
        Intrinsics.checkNotNullParameter((Object)phaseConfig, (String)"phaseConfig");
        Intrinsics.checkNotNullParameter(phaserState, (String)"phaserState");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Integer n = context.getConfiguration().get(CommonConfigurationKeys.PARALLEL_BACKEND_THREADS);
        if (n == null) {
            n = 1;
        }
        return (nThreads = ((Number)n).intValue()) > 1 ? this.invokeParallel(phaseConfig, phaserState, context, input, nThreads) : this.invokeSequential(phaseConfig, phaserState, context, input);
    }

    private final IrModuleFragment invokeSequential(PhaseConfigurationService phaseConfig, PhaserState<IrModuleFragment> phaserState, Context context, IrModuleFragment input) {
        for (IrFile irFile : input.getFiles()) {
            try {
                PhaserState filePhaserState = CompilerPhaseKt.changePhaserStateType(phaserState);
                for (CompilerPhase<LoggingContext, IrFile, IrFile> compilerPhase : this.lower) {
                    compilerPhase.invoke(phaseConfig, filePhaserState, (LoggingContext)context, irFile);
                }
            }
            catch (Throwable e) {
                CodegenUtil.reportBackendException$default(e, "IR lowering", irFile.getFileEntry().getName(), null, (Function1)new Function1<Integer, Pair<? extends Integer, ? extends Integer>>(irFile){
                    final /* synthetic */ IrFile $irFile;
                    {
                        this.$irFile = $irFile;
                        super(1);
                    }

                    @Nullable
                    public final Pair<Integer, Integer> invoke(int offset2) {
                        Pair pair;
                        IrFileEntry irFileEntry;
                        IrFileEntry it = irFileEntry = this.$irFile.getFileEntry();
                        boolean bl = false;
                        IrFileEntry irFileEntry2 = it.getSupportsDebugInfo() ? irFileEntry : null;
                        if (irFileEntry2 != null) {
                            it = irFileEntry2;
                            boolean bl2 = false;
                            pair = TuplesKt.to((Object)it.getLineNumber(offset2), (Object)it.getColumnNumber(offset2));
                        } else {
                            pair = null;
                        }
                        return pair;
                    }
                }, 8, null);
                throw null;
            }
        }
        return input;
    }

    /*
     * WARNING - void declaration
     */
    private final IrModuleFragment invokeParallel(PhaseConfigurationService phaseConfig, PhaserState<IrModuleFragment> phaserState, Context context, IrModuleFragment input, int nThreads) {
        IrFile irFile;
        List<IrFile> list2;
        Pair $this$mapTo$iv$iv2;
        if (input.getFiles().isEmpty()) {
            return input;
        }
        AtomicReference<Object> thrownFromThread = new AtomicReference<Object>(null);
        Map remappedFiles = new LinkedHashMap();
        Map remappedFunctions = new LinkedHashMap();
        Map remappedClasses = new LinkedHashMap();
        Iterable $this$map$iv = input.getFiles();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        List<IrFile> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            IrFile irFile2 = (IrFile)item$iv$iv;
            list2 = destination$iv$iv;
            boolean bl = false;
            list2.add((IrFile)(this.copyBeforeLowering ? TuplesKt.to((Object)PerformByIrFileKt.copySavingMappings((IrFile)it, remappedFiles, remappedFunctions, remappedClasses), phaserState.copyOf()) : TuplesKt.to((Object)it, phaserState.copyOf())));
        }
        List filesAndStates = destination$iv$iv;
        ExecutorService executor2 = Executors.newFixedThreadPool(nThreads);
        for (Pair $this$mapTo$iv$iv2 : filesAndStates) {
            irFile = (IrFile)$this$mapTo$iv$iv2.component1();
            PhaserState state = (PhaserState)$this$mapTo$iv$iv2.component2();
            executor2.execute(() -> PerformByIrFilePhase.invokeParallel$lambda$1(state, this, phaseConfig, context, irFile, thrownFromThread));
        }
        executor2.shutdown();
        executor2.awaitTermination(1L, TimeUnit.DAYS);
        Object $i$f$map22 = thrownFromThread.get();
        if ($i$f$map22 != null) {
            irFile = $i$f$map22;
            boolean bl = false;
            Throwable e = (Throwable)irFile.component1();
            IrFile irFile3 = (IrFile)irFile.component2();
            CodegenUtil.reportBackendException$default(e, "Experimental parallel IR backend", irFile3.getFileEntry().getName(), null, (Function1)new Function1<Integer, Pair<? extends Integer, ? extends Integer>>(irFile3){
                final /* synthetic */ IrFile $irFile;
                {
                    this.$irFile = $irFile;
                    super(1);
                }

                @Nullable
                public final Pair<Integer, Integer> invoke(int offset2) {
                    Pair pair;
                    IrFileEntry irFileEntry;
                    IrFileEntry it = irFileEntry = this.$irFile.getFileEntry();
                    boolean bl = false;
                    IrFileEntry irFileEntry2 = it.getSupportsDebugInfo() ? irFileEntry : null;
                    if (irFileEntry2 != null) {
                        it = irFileEntry2;
                        boolean bl2 = false;
                        pair = TuplesKt.to((Object)it.getLineNumber(offset2), (Object)it.getColumnNumber(offset2));
                    } else {
                        pair = null;
                    }
                    return pair;
                }
            }, 8, null);
            throw null;
        }
        phaserState.getAlreadyDone().addAll((Collection)((PhaserState)((Pair)filesAndStates.get(0)).getSecond()).getAlreadyDone());
        if (this.copyBeforeLowering) {
            void $this$mapTo$iv$iv3;
            void $this$map$iv2;
            input.getFiles().clear();
            $i$f$map22 = filesAndStates;
            list2 = input.getFiles();
            boolean $i$f$map = false;
            irFile = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                IrFile irFile4 = (IrFile)pair.component1();
                collection.add(irFile4);
            }
            list2.addAll(CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2)));
            PerformByIrFileKt.access$adjustDefaultArgumentStubs(context, remappedFunctions);
            context.handleDeepCopy(remappedFiles, remappedClasses, remappedFunctions);
            PerformByIrFileKt.access$adjustDefaultArgumentStubs(context, remappedFunctions);
            IrElementTransformerVoidKt.transformChildrenVoid(input, new CrossFileCallAdjuster(remappedFunctions));
        }
        return input;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<Integer, AbstractNamedCompilerPhase<Context, ?, ?>>> getNamedSubphases(int startDepth) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.lower;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            CompilerPhase it = (CompilerPhase)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getNamedSubphases(startDepth);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void invokeParallel$lambda$1(PhaserState $state, PerformByIrFilePhase this$0, PhaseConfigurationService $phaseConfig, CommonBackendContext $context, IrFile $irFile, AtomicReference $thrownFromThread) {
        Intrinsics.checkNotNullParameter((Object)$state, (String)"$state");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$phaseConfig, (String)"$phaseConfig");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$irFile, (String)"$irFile");
        Intrinsics.checkNotNullParameter((Object)$thrownFromThread, (String)"$thrownFromThread");
        try {
            PhaserState filePhaserState = CompilerPhaseKt.changePhaserStateType($state);
            for (CompilerPhase<LoggingContext, IrFile, IrFile> compilerPhase : this$0.lower) {
                compilerPhase.invoke($phaseConfig, filePhaserState, $context, $irFile);
            }
        }
        catch (Throwable e) {
            $thrownFromThread.set(new Pair((Object)e, (Object)$irFile));
        }
    }
}

