/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectHierarchyUtils;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.plugins.ide.internal.tooling.ToolingModelBuilderSupport;
import org.gradle.plugins.ide.internal.tooling.model.DefaultGradleProject;
import org.gradle.plugins.ide.internal.tooling.model.LaunchableGradleProjectTask;
import org.gradle.plugins.ide.internal.tooling.model.LaunchableGradleTask;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.provider.model.ToolingModelBuilder;

public class GradleProjectBuilder
implements ToolingModelBuilder {
    public boolean canBuild(String modelName) {
        return modelName.equals("org.gradle.tooling.model.GradleProject");
    }

    public Object buildAll(String modelName, Project project) {
        return this.buildHierarchy(project.getRootProject());
    }

    public DefaultGradleProject buildAll(Project project) {
        return this.buildHierarchy(project.getRootProject());
    }

    private DefaultGradleProject buildHierarchy(Project project) {
        List children = ProjectHierarchyUtils.getChildProjectsForInternalUse((Project)project).stream().map(this::buildHierarchy).collect(Collectors.toList());
        String projectIdentityPath = ((ProjectInternal)project).getIdentityPath().getPath();
        DefaultGradleProject gradleProject = new DefaultGradleProject().setProjectIdentifier(new DefaultProjectIdentifier(project.getRootDir(), project.getPath())).setName(project.getName()).setDescription(project.getDescription()).setBuildDirectory(project.getBuildDir()).setProjectDirectory(project.getProjectDir()).setBuildTreePath(projectIdentityPath).setChildren(children);
        gradleProject.getBuildScript().setSourceFile(project.getBuildFile());
        String projectOptions = System.getProperty("org.gradle.internal.GradleProjectBuilderOptions", "unmodified");
        List<LaunchableGradleTask> tasks = GradleProjectBuilder.tasks(gradleProject, (TaskContainerInternal)project.getTasks(), projectOptions);
        if (!"skip_task_serialization".equals(projectOptions)) {
            gradleProject.setTasks(tasks);
        }
        for (DefaultGradleProject child : children) {
            child.setParent(gradleProject);
        }
        return gradleProject;
    }

    private static List<LaunchableGradleTask> tasks(DefaultGradleProject owner, TaskContainerInternal tasks, String projectOptions) {
        if ("omit_all_tasks".equals(projectOptions)) {
            return ImmutableList.of();
        }
        if ("skip_task_graph_realization".equals(projectOptions)) {
            return tasks.getNames().stream().map(taskName -> GradleProjectBuilder.buildFromTaskName(new LaunchableGradleProjectTask(), owner.getProjectIdentifier(), taskName).setBuildTreePath(owner.getBuildTreePath() + ":" + taskName)).collect(Collectors.toList());
        }
        tasks.discoverTasks();
        tasks.realize();
        return tasks.getNames().stream().map(arg_0 -> ((TaskContainerInternal)tasks).findByName(arg_0)).filter(Objects::nonNull).map(task -> ToolingModelBuilderSupport.buildFromTask(new LaunchableGradleProjectTask(), owner.getProjectIdentifier(), task).setProject(owner).setBuildTreePath(GradleProjectBuilder.getBuildTreePath(owner, task))).collect(Collectors.toList());
    }

    private static String getBuildTreePath(DefaultGradleProject owner, Task task) {
        String ownerBuildTreePath = owner.getBuildTreePath();
        String buildTreePath = ":" + task.getName();
        if (":".equals(ownerBuildTreePath)) {
            return buildTreePath;
        }
        return ownerBuildTreePath + buildTreePath;
    }

    public static <T extends LaunchableGradleTask> T buildFromTaskName(T target, DefaultProjectIdentifier projectIdentifier, String taskName) {
        String taskPath = projectIdentifier.getProjectPath() + ":" + taskName;
        target.setPath(taskPath).setName(taskName).setGroup("undefined").setDisplayName(taskPath).setDescription("").setPublic(true).setProjectIdentifier(projectIdentifier);
        return target;
    }
}

