/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.transform.ComponentVariantIdentifier;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependencies;
import org.gradle.api.internal.artifacts.transform.TransformationNode;
import org.gradle.api.internal.artifacts.transform.TransformationStep;
import org.gradle.internal.id.ConfigurationCacheableIdFactory;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.BuildTree.class)
@ThreadSafe
public class TransformationNodeFactory {
    private final ConfigurationCacheableIdFactory idFactory;

    public TransformationNodeFactory(ConfigurationCacheableIdFactory idFactory) {
        this.idFactory = idFactory;
    }

    public TransformationNode.InitialTransformationNode createInitial(ComponentVariantIdentifier targetComponentVariant, AttributeContainer sourceAttributes, TransformationStep initial, ResolvableArtifact artifact, TransformUpstreamDependencies upstreamDependencies, BuildOperationExecutor buildOperationExecutor, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        long id = this.idFactory.createId();
        return new TransformationNode.InitialTransformationNode(id, targetComponentVariant, sourceAttributes, initial, artifact, upstreamDependencies, buildOperationExecutor, calculatedValueContainerFactory);
    }

    public TransformationNode.InitialTransformationNode recreateInitial(long transformationNodeId, ComponentVariantIdentifier targetComponentVariant, AttributeContainer sourceAttributes, TransformationStep initial, ResolvableArtifact artifact, TransformUpstreamDependencies upstreamDependencies, BuildOperationExecutor buildOperationExecutor, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.idFactory.idRecreated();
        return new TransformationNode.InitialTransformationNode(transformationNodeId, targetComponentVariant, sourceAttributes, initial, artifact, upstreamDependencies, buildOperationExecutor, calculatedValueContainerFactory);
    }

    public TransformationNode.ChainedTransformationNode createChained(ComponentVariantIdentifier targetComponentVariant, AttributeContainer sourceAttributes, TransformationStep current, TransformationNode previous, TransformUpstreamDependencies upstreamDependencies, BuildOperationExecutor buildOperationExecutor, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        long id = this.idFactory.createId();
        return new TransformationNode.ChainedTransformationNode(id, targetComponentVariant, sourceAttributes, current, previous, upstreamDependencies, buildOperationExecutor, calculatedValueContainerFactory);
    }

    public TransformationNode.ChainedTransformationNode recreateChained(long transformationNodeId, ComponentVariantIdentifier targetComponentVariant, AttributeContainer sourceAttributes, TransformationStep current, TransformationNode previous, TransformUpstreamDependencies upstreamDependencies, BuildOperationExecutor buildOperationExecutor, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.idFactory.idRecreated();
        return new TransformationNode.ChainedTransformationNode(transformationNodeId, targetComponentVariant, sourceAttributes, current, previous, upstreamDependencies, buildOperationExecutor, calculatedValueContainerFactory);
    }
}

