/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.Mapping;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.lower.ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt;
import org.jetbrains.kotlin.backend.wasm.lower.ComplexExternalDeclarationsUsageLowering;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.TransformKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0002\b\u0011\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsUsageLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "declarationTransformer", "org/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsUsageLowering$declarationTransformer$1", "Lorg/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsUsageLowering$declarationTransformer$1;", "nestedExternalToNewTopLevelFunctions", "Lorg/jetbrains/kotlin/backend/common/Mapping$Delegate;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "objectToGetInstanceFunctions", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "usagesTransformer", "org/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsUsageLowering$usagesTransformer$1", "Lorg/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsUsageLowering$usagesTransformer$1;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.wasm"})
public final class ComplexExternalDeclarationsUsageLowering
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final Mapping.Delegate<IrFunction, IrSimpleFunction> nestedExternalToNewTopLevelFunctions;
    @NotNull
    private final Mapping.Delegate<IrClass, IrSimpleFunction> objectToGetInstanceFunctions;
    @NotNull
    private final declarationTransformer.1 declarationTransformer;
    @NotNull
    private final usagesTransformer.1 usagesTransformer;

    public ComplexExternalDeclarationsUsageLowering(@NotNull WasmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.nestedExternalToNewTopLevelFunctions = this.context.getMapping().getWasmNestedExternalToNewTopLevelFunction();
        this.objectToGetInstanceFunctions = this.context.getMapping().getWasmExternalObjectToGetInstanceFunction();
        this.declarationTransformer = new IrElementVisitorVoid(this){
            final /* synthetic */ ComplexExternalDeclarationsUsageLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitElement(@NotNull IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                IrVisitorsKt.acceptChildrenVoid(element, this);
            }

            public void visitFile(@NotNull IrFile declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                this.process(declaration);
            }

            public void visitClass(@NotNull IrClass declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                if (!declaration.isExternal()) {
                    this.process(declaration);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void process(IrDeclarationContainer container) {
                void $this$transformFlat$iv;
                List<IrDeclaration> list2 = container.getDeclarations();
                ComplexExternalDeclarationsUsageLowering complexExternalDeclarationsUsageLowering = this.this$0;
                boolean $i$f$transformFlat = false;
                int i$iv = 0;
                while (i$iv < $this$transformFlat$iv.size()) {
                    List list3;
                    void member2;
                    E item$iv = $this$transformFlat$iv.get(i$iv);
                    IrDeclaration irDeclaration2 = (IrDeclaration)item$iv;
                    void var9_9 = $this$transformFlat$iv;
                    boolean bl = false;
                    if (CollectionsKt.contains((Iterable)ComplexExternalDeclarationsUsageLowering.access$getNestedExternalToNewTopLevelFunctions$p(complexExternalDeclarationsUsageLowering).getKeys(), (Object)member2)) {
                        list3 = CollectionsKt.emptyList();
                    } else {
                        IrVisitorsKt.acceptVoid((IrElement)member2, this);
                        list3 = null;
                    }
                    i$iv = TransformKt.replaceInPlace(var9_9, list3, i$iv);
                }
            }

            public void visitBody(@NotNull IrBody body2) {
                Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
                IrElementTransformerVoidKt.transformChildrenVoid(body2, ComplexExternalDeclarationsUsageLowering.access$getUsagesTransformer$p(this.this$0));
            }

            public void visitElement(@NotNull IrElement element, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data2);
            }

            public void visitFile(@NotNull IrFile declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data2);
            }

            public void visitClass(@NotNull IrClass declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data2);
            }

            public void visitBody(@NotNull IrBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data2);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
            }

            public void visitBlock(@NotNull IrBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
            }

            public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data2);
            }

            public void visitBranch(@NotNull IrBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
            }

            public void visitBranch(@NotNull IrBranch branch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data2);
            }

            public void visitBreak(@NotNull IrBreak jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
            }

            public void visitBreak(@NotNull IrBreak jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data2);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data2);
            }

            public void visitCall(@NotNull IrCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
            }

            public void visitCall(@NotNull IrCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data2);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data2);
            }

            public void visitCatch(@NotNull IrCatch aCatch) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
            }

            public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data2);
            }

            public void visitComposite(@NotNull IrComposite expression2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
            }

            public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data2);
            }

            public void visitConst(@NotNull IrConst<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
            }

            public void visitConst(@NotNull IrConst<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data2);
            }

            public void visitConstantArray(@NotNull IrConstantArray expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
            }

            public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data2);
            }

            public void visitConstantObject(@NotNull IrConstantObject expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
            }

            public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data2);
            }

            public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
            }

            public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
            }

            public void visitConstantValue(@NotNull IrConstantValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
            }

            public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data2);
            }

            public void visitConstructor(@NotNull IrConstructor declaration) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
            }

            public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data2);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data2);
            }

            public void visitContinue(@NotNull IrContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
            }

            public void visitContinue(@NotNull IrContinue jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data2);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data2);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data2);
            }

            public void visitExpression(@NotNull IrExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
            }

            public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data2);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
            }

            public void visitField(@NotNull IrField declaration) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
            }

            public void visitField(@NotNull IrField declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data2);
            }

            public void visitFunction(@NotNull IrFunction declaration) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
            }

            public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data2);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data2);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data2);
            }

            public void visitGetField(@NotNull IrGetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
            }

            public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
            }

            public void visitLoop(@NotNull IrLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
            }

            public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data2);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data2);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data2);
            }

            public void visitProperty(@NotNull IrProperty declaration) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
            }

            public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data2);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
            }

            public void visitReturn(@NotNull IrReturn expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
            }

            public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data2);
            }

            public void visitScript(@NotNull IrScript declaration) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration);
            }

            public void visitScript(@NotNull IrScript declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration, data2);
            }

            public void visitSetField(@NotNull IrSetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
            }

            public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data2);
            }

            public void visitSetValue(@NotNull IrSetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
            }

            public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data2);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data2);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data2);
            }

            public void visitThrow(@NotNull IrThrow expression2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
            }

            public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data2);
            }

            public void visitTry(@NotNull IrTry aTry) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
            }

            public void visitTry(@NotNull IrTry aTry, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data2);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data2);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data2);
            }

            public void visitValueAccess(@NotNull IrValueAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
            }

            public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data2);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data2);
            }

            public void visitVararg(@NotNull IrVararg expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
            }

            public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data2);
            }

            public void visitVariable(@NotNull IrVariable declaration) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
            }

            public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data2);
            }

            public void visitWhen(@NotNull IrWhen expression2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
            }

            public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data2);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data2);
            }
        };
        this.usagesTransformer = new IrElementTransformerVoid(this){
            final /* synthetic */ ComplexExternalDeclarationsUsageLowering this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                this.transformChildrenVoid(expression2);
                return this.transformCall(expression2);
            }

            @NotNull
            public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                this.transformChildrenVoid(expression2);
                return this.transformCall(expression2);
            }

            @NotNull
            public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrSimpleFunction irSimpleFunction = (IrSimpleFunction)ComplexExternalDeclarationsUsageLowering.access$getObjectToGetInstanceFunctions$p(this.this$0).get((IrDeclaration)expression2.getSymbol().getOwner());
                if (irSimpleFunction == null) {
                    return expression2;
                }
                IrSimpleFunction externalGetInstance = irSimpleFunction;
                int n = expression2.getStartOffset();
                int n2 = expression2.getEndOffset();
                IrType irType = expression2.getType();
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = externalGetInstance.getSymbol();
                return new IrCallImpl(n, n2, irType, irSimpleFunctionSymbol, 0, 0, null, null, 192, null);
            }

            @NotNull
            public final IrExpression transformCall(@NotNull IrFunctionAccessExpression call2) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                IrFunction oldFun = IrResolveUtilsKt.getRealOverrideTarget(((IrFunctionSymbol)call2.getSymbol()).getOwner());
                IrSimpleFunction irSimpleFunction = (IrSimpleFunction)ComplexExternalDeclarationsUsageLowering.access$getNestedExternalToNewTopLevelFunctions$p(this.this$0).get((IrDeclaration)oldFun);
                if (irSimpleFunction == null) {
                    return call2;
                }
                IrSimpleFunction newFun = irSimpleFunction;
                IrCall newCall = IrUtilsKt.irCall$default(call2, newFun, true, false, null, null, 56, null);
                int numDefaultParameters = ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt.access$numDefaultParametersForExternalFunction(oldFun);
                int firstDefaultFlagArgumentIdx = newFun.getValueParameters().size() - numDefaultParameters;
                int firstOldDefaultArgumentIdx = call2.getValueArgumentsCount() - numDefaultParameters;
                ComplexExternalDeclarationsUsageLowering complexExternalDeclarationsUsageLowering = this.this$0;
                for (int i = 0; i < numDefaultParameters; ++i) {
                    int it = i;
                    boolean bl = false;
                    int value2 = call2.getValueArgument(firstOldDefaultArgumentIdx + it) == null ? 1 : 0;
                    newCall.putValueArgument(firstDefaultFlagArgumentIdx + it, IrConstImpl.Companion.int(-1, -1, complexExternalDeclarationsUsageLowering.getContext().getIrBuiltIns().getIntType(), value2));
                }
                return newCall;
            }
        };
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrVisitorsKt.acceptVoid(irFile, this.declarationTransformer);
    }

    public static final /* synthetic */ usagesTransformer.1 access$getUsagesTransformer$p(ComplexExternalDeclarationsUsageLowering $this) {
        return $this.usagesTransformer;
    }

    public static final /* synthetic */ Mapping.Delegate access$getNestedExternalToNewTopLevelFunctions$p(ComplexExternalDeclarationsUsageLowering $this) {
        return $this.nestedExternalToNewTopLevelFunctions;
    }

    public static final /* synthetic */ Mapping.Delegate access$getObjectToGetInstanceFunctions$p(ComplexExternalDeclarationsUsageLowering $this) {
        return $this.objectToGetInstanceFunctions;
    }
}

