/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.problems.internal.rendering;

import com.google.common.base.Strings;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import org.gradle.api.NonNullApi;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.util.internal.TextUtil;

@NonNullApi
public class ProblemRenderer {
    private final PrintWriter output;

    public ProblemRenderer(Writer writer) {
        this.output = new PrintWriter(writer);
    }

    public void render(List<InternalProblem> problems) {
        ProblemRenderer.render(this.output, problems);
    }

    public void render(InternalProblem problem) {
        this.render(Collections.singletonList(problem));
    }

    private static void render(PrintWriter output, List<InternalProblem> problems) {
        String sep = "";
        for (InternalProblem problem : problems) {
            output.printf(sep, new Object[0]);
            ProblemRenderer.renderProblem(output, problem);
            sep = "%n";
        }
    }

    static void renderProblem(PrintWriter output, InternalProblem problem) {
        boolean isJavaCompilationProblem = problem.getDefinition().getId().getGroup().equals(GradleCoreProblemGroup.compilation().java());
        if (isJavaCompilationProblem) {
            ProblemRenderer.formatMultiline(output, problem.getDetails(), 0);
        } else {
            if (problem.getContextualLabel() != null) {
                ProblemRenderer.formatMultiline(output, problem.getContextualLabel(), 1);
            } else {
                ProblemRenderer.formatMultiline(output, problem.getDefinition().getId().getDisplayName(), 1);
            }
            if (problem.getDetails() != null) {
                output.printf("%n", new Object[0]);
                ProblemRenderer.formatMultiline(output, problem.getDetails(), 2);
            }
        }
    }

    static void formatMultiline(PrintWriter output, String message, int level) {
        if (message == null) {
            return;
        }
        String prefix = Strings.repeat((String)" ", (int)(level * 2));
        String formatted = TextUtil.indent((String)message, (String)prefix);
        output.print(formatted);
    }
}

