/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import net.rubygrapefruit.platform.SystemInfo;
import net.rubygrapefruit.platform.WindowsRegistry;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.AbstractWindowsKitComponentLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsKitSdkInstall;
import org.gradle.util.internal.VersionNumber;

public class WindowsKitWindowsSdkLocator
extends AbstractWindowsKitComponentLocator<WindowsKitSdkInstall> {
    private static final String COMPONENT_NAME = "um";
    private static final String DISPLAY_NAME = "Windows SDK";
    private static final String RC_EXE = "rc.exe";
    private final SystemInfo systemInfo;

    public WindowsKitWindowsSdkLocator(WindowsRegistry windowsRegistry, SystemInfo systemInfo) {
        super(windowsRegistry);
        this.systemInfo = systemInfo;
    }

    @Override
    String getComponentName() {
        return COMPONENT_NAME;
    }

    @Override
    String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    boolean isValidComponentBinDir(File binDir) {
        for (String platform : PLATFORMS) {
            if (new File(binDir, platform + "/" + RC_EXE).exists()) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean isValidComponentIncludeDir(File includeDir) {
        return new File(includeDir, "windows.h").exists();
    }

    @Override
    boolean isValidComponentLibDir(File libDir) {
        for (String platform : PLATFORMS) {
            if (new File(libDir, platform + "/kernel32.lib").exists()) continue;
            return false;
        }
        return true;
    }

    @Override
    WindowsKitSdkInstall newComponent(File baseDir, File binDir, VersionNumber version, AbstractWindowsKitComponentLocator.DiscoveryType discoveryType) {
        return new WindowsKitSdkInstall(baseDir, version, binDir, this.getVersionedDisplayName(version, discoveryType), this.systemInfo);
    }
}

