/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations;

import com.google.common.collect.Interner;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependencyCapabilitiesHandler;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.DefaultProjectDependencyFactory;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultProjectDependencyConstraint;
import org.gradle.api.internal.artifacts.dependencies.DependencyVariant;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.notations.DependencyConstraintProjectNotationConverter;
import org.gradle.api.internal.notations.DependencyMapNotationConverter;
import org.gradle.api.internal.notations.DependencyStringNotationConverter;
import org.gradle.api.provider.Provider;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationConverterToNotationParserAdapter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.internal.typeconversion.TypedNotationConverter;

public class DependencyConstraintNotationParser {
    private final NotationParser<Object, DependencyConstraint> notationParser;
    private final NotationParser<String, ? extends DependencyConstraint> stringNotationParser;
    private final NotationParser<MinimalExternalModuleDependency, ? extends DependencyConstraint> minimalExternalModuleDependencyNotationParser;
    private final NotationParser<ProjectDependency, ? extends DependencyConstraint> projectDependencyNotationParser;

    public static DependencyConstraintNotationParser parser(Instantiator instantiator, DefaultProjectDependencyFactory dependencyFactory, Interner<String> stringInterner, ImmutableAttributesFactory attributesFactory) {
        DependencyStringNotationConverter<DefaultDependencyConstraint> stringNotationConverter = new DependencyStringNotationConverter<DefaultDependencyConstraint>(instantiator, DefaultDependencyConstraint.class, stringInterner);
        MinimalExternalDependencyNotationConverter minimalExternalDependencyNotationConverter = new MinimalExternalDependencyNotationConverter(instantiator, attributesFactory);
        ProjectDependencyNotationConverter projectDependencyNotationConverter = new ProjectDependencyNotationConverter(instantiator);
        NotationParser notationParser = NotationParserBuilder.toType(DependencyConstraint.class).fromType(MinimalExternalModuleDependency.class, (NotationConverter)minimalExternalDependencyNotationConverter).fromCharSequence(stringNotationConverter).converter(new DependencyMapNotationConverter<DefaultDependencyConstraint>(instantiator, DefaultDependencyConstraint.class)).fromType(Project.class, (NotationConverter)new DependencyConstraintProjectNotationConverter(instantiator, dependencyFactory)).converter((NotationConverter)projectDependencyNotationConverter).invalidNotationMessage("Comprehensive documentation on dependency notations is available in DSL reference for DependencyHandler type.").toComposite();
        return new DependencyConstraintNotationParser((NotationParser<Object, DependencyConstraint>)notationParser, (NotationParser<String, ? extends DependencyConstraint>)new NotationConverterToNotationParserAdapter(stringNotationConverter), (NotationParser<MinimalExternalModuleDependency, ? extends DependencyConstraint>)new NotationConverterToNotationParserAdapter((NotationConverter)minimalExternalDependencyNotationConverter), (NotationParser<ProjectDependency, ? extends DependencyConstraint>)new NotationConverterToNotationParserAdapter((NotationConverter)projectDependencyNotationConverter));
    }

    private DependencyConstraintNotationParser(NotationParser<Object, DependencyConstraint> notationParser, NotationParser<String, ? extends DependencyConstraint> stringNotationParser, NotationParser<MinimalExternalModuleDependency, ? extends DependencyConstraint> minimalExternalModuleDependencyNotationParser, NotationParser<ProjectDependency, ? extends DependencyConstraint> projectDependencyNotationParser) {
        this.notationParser = notationParser;
        this.stringNotationParser = stringNotationParser;
        this.minimalExternalModuleDependencyNotationParser = minimalExternalModuleDependencyNotationParser;
        this.projectDependencyNotationParser = projectDependencyNotationParser;
    }

    public NotationParser<Object, DependencyConstraint> getNotationParser() {
        return this.notationParser;
    }

    public NotationParser<String, ? extends DependencyConstraint> getStringNotationParser() {
        return this.stringNotationParser;
    }

    public NotationParser<MinimalExternalModuleDependency, ? extends DependencyConstraint> getMinimalExternalModuleDependencyNotationParser() {
        return this.minimalExternalModuleDependencyNotationParser;
    }

    public NotationParser<ProjectDependency, ? extends DependencyConstraint> getProjectDependencyNotationParser() {
        return this.projectDependencyNotationParser;
    }

    private static final class UnsupportedCapabilitiesHandler
    implements ModuleDependencyCapabilitiesHandler {
        private static final UnsupportedCapabilitiesHandler INSTANCE = new UnsupportedCapabilitiesHandler();

        private UnsupportedCapabilitiesHandler() {
        }

        public void requireCapability(Object capabilityNotation) {
            throw new InvalidUserDataException("Capabilities are not supported by dependency constraints");
        }

        public void requireCapabilities(Object ... capabilityNotations) {
            throw new InvalidUserDataException("Capabilities are not supported by dependency constraints");
        }

        public void requireFeature(String featureName) {
            throw new InvalidUserDataException("Capabilities are not supported by dependency constraints");
        }

        public void requireFeature(Provider<String> featureName) {
            throw new InvalidUserDataException("Capabilities are not supported by dependency constraints");
        }
    }

    private static class MinimalExternalDependencyNotationConverter
    implements NotationConverter<MinimalExternalModuleDependency, DefaultDependencyConstraint> {
        private final Instantiator instantiator;
        private final ImmutableAttributesFactory attributesFactory;

        public MinimalExternalDependencyNotationConverter(Instantiator instantiator, ImmutableAttributesFactory attributesFactory) {
            this.instantiator = instantiator;
            this.attributesFactory = attributesFactory;
        }

        public void convert(MinimalExternalModuleDependency notation, NotationConvertResult<? super DefaultDependencyConstraint> result) throws TypeConversionException {
            DefaultDependencyConstraint dependencyConstraint = (DefaultDependencyConstraint)this.instantiator.newInstance(DefaultDependencyConstraint.class, new Object[]{notation.getModule(), notation.getVersionConstraint()});
            if (notation instanceof DependencyVariant) {
                dependencyConstraint.setAttributesFactory(this.attributesFactory);
                DependencyVariant dependencyVariant = (DependencyVariant)notation;
                dependencyConstraint.attributes((Action<? super AttributeContainer>)((Action)dependencyVariant::mutateAttributes));
                dependencyVariant.mutateCapabilities(UnsupportedCapabilitiesHandler.INSTANCE);
                String classifier = dependencyVariant.getClassifier();
                String artifactType = dependencyVariant.getArtifactType();
                if (classifier != null || artifactType != null) {
                    throw new InvalidUserDataException("Classifier and artifact types aren't supported by dependency constraints");
                }
            }
            result.converted((Object)dependencyConstraint);
        }

        public void describe(DiagnosticsVisitor visitor) {
        }
    }

    private static class ProjectDependencyNotationConverter
    extends TypedNotationConverter<ProjectDependency, DependencyConstraint> {
        private final Instantiator instantiator;

        public ProjectDependencyNotationConverter(Instantiator instantiator) {
            super(ProjectDependency.class);
            this.instantiator = instantiator;
        }

        protected DependencyConstraint parseType(ProjectDependency notation) {
            return (DependencyConstraint)this.instantiator.newInstance(DefaultProjectDependencyConstraint.class, new Object[]{notation});
        }
    }
}

