/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.workspace.impl;

import java.io.Closeable;
import java.io.File;
import java.util.UUID;
import org.gradle.api.internal.cache.CacheConfigurationsInternal;
import org.gradle.api.provider.Provider;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.DefaultCacheCleanupStrategy;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.FilesFinder;
import org.gradle.cache.internal.LeastRecentlyUsedCacheCleanup;
import org.gradle.cache.internal.SingleDepthFilesFinder;
import org.gradle.internal.execution.workspace.ImmutableWorkspaceProvider;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.file.impl.SingleDepthFileAccessTracker;

public class CacheBasedImmutableWorkspaceProvider
implements ImmutableWorkspaceProvider,
Closeable {
    private static final int DEFAULT_FILE_TREE_DEPTH_TO_TRACK_AND_CLEANUP = 1;
    private final SingleDepthFileAccessTracker fileAccessTracker;
    private final File baseDirectory;
    private final PersistentCache cache;

    public static CacheBasedImmutableWorkspaceProvider createWorkspaceProvider(CacheBuilder cacheBuilder, FileAccessTimeJournal fileAccessTimeJournal, CacheConfigurationsInternal cacheConfigurations) {
        return CacheBasedImmutableWorkspaceProvider.createWorkspaceProvider(cacheBuilder, fileAccessTimeJournal, 1, cacheConfigurations);
    }

    public static CacheBasedImmutableWorkspaceProvider createWorkspaceProvider(CacheBuilder cacheBuilder, FileAccessTimeJournal fileAccessTimeJournal, int treeDepthToTrackAndCleanup, CacheConfigurationsInternal cacheConfigurations) {
        return new CacheBasedImmutableWorkspaceProvider(cacheBuilder, fileAccessTimeJournal, treeDepthToTrackAndCleanup, cacheConfigurations);
    }

    private CacheBasedImmutableWorkspaceProvider(CacheBuilder cacheBuilder, FileAccessTimeJournal fileAccessTimeJournal, int treeDepthToTrackAndCleanup, CacheConfigurationsInternal cacheConfigurations) {
        PersistentCache cache;
        this.cache = cache = cacheBuilder.withCleanupStrategy(CacheBasedImmutableWorkspaceProvider.createCacheCleanupStrategy(fileAccessTimeJournal, treeDepthToTrackAndCleanup, cacheConfigurations)).withInitialLockMode(FileLockManager.LockMode.None).open();
        this.baseDirectory = cache.getBaseDir();
        this.fileAccessTracker = new SingleDepthFileAccessTracker(fileAccessTimeJournal, this.baseDirectory, treeDepthToTrackAndCleanup);
    }

    private static CacheCleanupStrategy createCacheCleanupStrategy(FileAccessTimeJournal fileAccessTimeJournal, int treeDepthToTrackAndCleanup, CacheConfigurationsInternal cacheConfigurations) {
        return DefaultCacheCleanupStrategy.from((CleanupAction)CacheBasedImmutableWorkspaceProvider.createCleanupAction(fileAccessTimeJournal, treeDepthToTrackAndCleanup, cacheConfigurations), () -> ((Provider)cacheConfigurations.getCleanupFrequency()).get());
    }

    private static CleanupAction createCleanupAction(FileAccessTimeJournal fileAccessTimeJournal, int treeDepthToTrackAndCleanup, CacheConfigurationsInternal cacheConfigurations) {
        return new LeastRecentlyUsedCacheCleanup((FilesFinder)new SingleDepthFilesFinder(treeDepthToTrackAndCleanup), fileAccessTimeJournal, cacheConfigurations.getCreatedResources().getRemoveUnusedEntriesOlderThanAsSupplier());
    }

    @Override
    public ImmutableWorkspaceProvider.ImmutableWorkspace getWorkspace(final String path) {
        final File immutableWorkspace = new File(this.baseDirectory, path);
        this.fileAccessTracker.markAccessed(immutableWorkspace);
        return new ImmutableWorkspaceProvider.ImmutableWorkspace(){

            @Override
            public File getImmutableLocation() {
                return immutableWorkspace;
            }

            @Override
            public <T> T withTemporaryWorkspace(ImmutableWorkspaceProvider.ImmutableWorkspace.TemporaryWorkspaceAction<T> action) {
                String temporaryLocation = path + "-" + UUID.randomUUID();
                File temporaryWorkspace = new File(CacheBasedImmutableWorkspaceProvider.this.baseDirectory, temporaryLocation);
                return action.executeInTemporaryWorkspace(temporaryWorkspace);
            }
        };
    }

    @Override
    public void close() {
        this.cache.close();
    }
}

