/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import groovy.lang.Closure;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.DependencyConstraintSet;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.CompositeDomainObjectSet;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.DefaultDependencyConstraintSet;
import org.gradle.api.internal.artifacts.DefaultDependencySet;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultPublishArtifactSet;
import org.gradle.api.internal.artifacts.DefaultResolverResults;
import org.gradle.api.internal.artifacts.ExcludeRuleNotationConverter;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.component.ComponentIdentifierFactory;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRoles;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DefaultArtifactCollection;
import org.gradle.api.internal.artifacts.configurations.DefaultConfigurationFactory;
import org.gradle.api.internal.artifacts.configurations.DefaultConfigurationPublications;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.DetachedConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.configurations.OutgoingVariant;
import org.gradle.api.internal.artifacts.configurations.ProjectDependencyObservedListener;
import org.gradle.api.internal.artifacts.configurations.PublishArtifactSetProvider;
import org.gradle.api.internal.artifacts.configurations.ResolutionBackedFileCollection;
import org.gradle.api.internal.artifacts.configurations.ResolutionHost;
import org.gradle.api.internal.artifacts.configurations.ResolutionResultProvider;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.configurations.ResolvableDependenciesInternal;
import org.gradle.api.internal.artifacts.configurations.ResolveConfigurationResolutionBuildOperationDetails;
import org.gradle.api.internal.artifacts.configurations.ResolveConfigurationResolutionBuildOperationResult;
import org.gradle.api.internal.artifacts.configurations.ResolveExceptionWithHints;
import org.gradle.api.internal.artifacts.configurations.TasksFromDependentProjects;
import org.gradle.api.internal.artifacts.configurations.TasksFromProjectDependencies;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DependencyConstraintInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingState;
import org.gradle.api.internal.artifacts.ivyservice.DefaultLenientConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.projectresult.ResolvedProjectConfiguration;
import org.gradle.api.internal.artifacts.transform.DefaultExtraExecutionGraphDependenciesResolverFactory;
import org.gradle.api.internal.artifacts.transform.ExtraExecutionGraphDependenciesResolverFactory;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributeContainerWithErrorMessage;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.attributes.IncubatingAttributesChecker;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.initialization.ResettableConfiguration;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.configuration.internal.UserCodeApplicationContext;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ProjectDerivedCapability;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.LocalComponentDependencyMetadata;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.deprecation.DocumentedFailure;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.model.CalculatedModelValue;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resolve.ModuleVersionNotFoundException;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.work.WorkerThreadRegistry;
import org.gradle.operations.dependencies.configurations.ConfigurationIdentity;
import org.gradle.util.Path;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.ConfigureUtil;
import org.gradle.util.internal.WrapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfiguration
extends AbstractFileCollection
implements ConfigurationInternal,
MutationValidator,
ResettableConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConfiguration.class);
    private static final Action<Throwable> DEFAULT_ERROR_HANDLER = throwable -> {
        throw UncheckedException.throwAsUncheckedException((Throwable)throwable);
    };
    private final ConfigurationResolver resolver;
    private final DependencyMetaDataProvider metaDataProvider;
    private final ComponentIdentifierFactory componentIdentifierFactory;
    private final DependencyLockingProvider dependencyLockingProvider;
    private final DefaultDependencySet dependencies;
    private final DefaultDependencyConstraintSet dependencyConstraints;
    private final DefaultDomainObjectSet<Dependency> ownDependencies;
    private final DefaultDomainObjectSet<DependencyConstraint> ownDependencyConstraints;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final ProjectStateRegistry projectStateRegistry;
    private CompositeDomainObjectSet<Dependency> inheritedDependencies;
    private CompositeDomainObjectSet<DependencyConstraint> inheritedDependencyConstraints;
    private DefaultDependencySet allDependencies;
    private DefaultDependencyConstraintSet allDependencyConstraints;
    private ImmutableActionSet<DependencySet> defaultDependencyActions = ImmutableActionSet.empty();
    private ImmutableActionSet<DependencySet> withDependencyActions = ImmutableActionSet.empty();
    private final DefaultPublishArtifactSet artifacts;
    private final DefaultDomainObjectSet<PublishArtifact> ownArtifacts;
    private CompositeDomainObjectSet<PublishArtifact> inheritedArtifacts;
    private DefaultPublishArtifactSet allArtifacts;
    private final ConfigurationResolvableDependencies resolvableDependencies;
    private ListenerBroadcast<DependencyResolutionListener> dependencyResolutionListeners;
    private final ProjectDependencyObservedListener dependencyObservedBroadcast;
    private final BuildOperationExecutor buildOperationExecutor;
    private final Instantiator instantiator;
    private Factory<ResolutionStrategyInternal> resolutionStrategyFactory;
    private ResolutionStrategyInternal resolutionStrategy;
    private final FileCollectionFactory fileCollectionFactory;
    private final DocumentationRegistry documentationRegistry;
    private final Set<MutationValidator> childMutationValidators = Sets.newHashSet();
    private final MutationValidator parentMutationValidator = this::validateParentMutation;
    private final RootComponentMetadataBuilder rootComponentMetadataBuilder;
    private final ConfigurationsProvider configurationsProvider;
    private final Path identityPath;
    private final Path path;
    private final String name;
    private final DefaultConfigurationPublications outgoing;
    private boolean visible = true;
    private boolean transitive = true;
    private Set<Configuration> extendsFrom = new LinkedHashSet<Configuration>();
    private String description;
    private final Set<Object> excludeRules = new LinkedHashSet<Object>();
    private Set<ExcludeRule> parsedExcludeRules;
    private boolean returnAllVariants = false;
    private final Object observationLock = new Object();
    private volatile ConfigurationInternal.InternalState observedState = ConfigurationInternal.InternalState.UNRESOLVED;
    private boolean insideBeforeResolve;
    private boolean dependenciesModified;
    private boolean canBeConsumed;
    private boolean canBeResolved;
    private boolean canBeDeclaredAgainst;
    private boolean consumptionDeprecated;
    private boolean resolutionDeprecated;
    private boolean declarationDeprecated;
    private boolean usageCanBeMutated = true;
    private final ConfigurationRole roleAtCreation;
    private boolean canBeMutated = true;
    private AttributeContainerInternal configurationAttributes;
    private final DomainObjectContext domainObjectContext;
    private final ImmutableAttributesFactory attributesFactory;
    private final ResolutionBackedFileCollection intrinsicFiles;
    private final DisplayName displayName;
    private final UserCodeApplicationContext userCodeApplicationContext;
    private final WorkerThreadRegistry workerThreadRegistry;
    private final DomainObjectCollectionFactory domainObjectCollectionFactory;
    private final Lazy<List<? extends DependencyMetadata>> syntheticDependencies = Lazy.unsafe().of(this::generateSyntheticDependencies);
    private final AtomicInteger copyCount = new AtomicInteger();
    private Action<? super ConfigurationInternal> beforeLocking;
    private List<String> declarationAlternatives;
    private DeprecationMessageBuilder.WithDocumentation consumptionDeprecation;
    private List<String> resolutionAlternatives;
    private final CalculatedModelValue<ResolveState> currentResolveState;
    private ConfigurationInternal consistentResolutionSource;
    private String consistentResolutionReason;
    private ExtraExecutionGraphDependenciesResolverFactory dependenciesResolverFactory;
    private final DefaultConfigurationFactory defaultConfigurationFactory;

    public DefaultConfiguration(DomainObjectContext domainObjectContext, String name, ConfigurationsProvider configurationsProvider, ConfigurationResolver resolver, ListenerBroadcast<DependencyResolutionListener> dependencyResolutionListeners, ProjectDependencyObservedListener dependencyObservedBroadcast, DependencyMetaDataProvider metaDataProvider, ComponentIdentifierFactory componentIdentifierFactory, DependencyLockingProvider dependencyLockingProvider, Factory<ResolutionStrategyInternal> resolutionStrategyFactory, FileCollectionFactory fileCollectionFactory, BuildOperationExecutor buildOperationExecutor, Instantiator instantiator, NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser, NotationParser<Object, Capability> capabilityNotationParser, ImmutableAttributesFactory attributesFactory, RootComponentMetadataBuilder rootComponentMetadataBuilder, DocumentationRegistry documentationRegistry, UserCodeApplicationContext userCodeApplicationContext, ProjectStateRegistry projectStateRegistry, WorkerThreadRegistry workerThreadRegistry, DomainObjectCollectionFactory domainObjectCollectionFactory, CalculatedValueContainerFactory calculatedValueContainerFactory, DefaultConfigurationFactory defaultConfigurationFactory, TaskDependencyFactory taskDependencyFactory, ConfigurationRole roleAtCreation, boolean lockUsage) {
        super(taskDependencyFactory);
        this.userCodeApplicationContext = userCodeApplicationContext;
        this.projectStateRegistry = projectStateRegistry;
        this.workerThreadRegistry = workerThreadRegistry;
        this.domainObjectCollectionFactory = domainObjectCollectionFactory;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.identityPath = domainObjectContext.identityPath(name);
        this.name = name;
        this.configurationsProvider = configurationsProvider;
        this.resolver = resolver;
        this.metaDataProvider = metaDataProvider;
        this.componentIdentifierFactory = componentIdentifierFactory;
        this.dependencyLockingProvider = dependencyLockingProvider;
        this.resolutionStrategyFactory = resolutionStrategyFactory;
        this.fileCollectionFactory = fileCollectionFactory;
        this.dependencyResolutionListeners = dependencyResolutionListeners;
        this.dependencyObservedBroadcast = dependencyObservedBroadcast;
        this.buildOperationExecutor = buildOperationExecutor;
        this.instantiator = instantiator;
        this.attributesFactory = attributesFactory;
        this.configurationAttributes = attributesFactory.mutable();
        this.domainObjectContext = domainObjectContext;
        this.intrinsicFiles = this.fileCollectionFromSpec((Spec<? super Dependency>)Specs.satisfyAll());
        this.documentationRegistry = documentationRegistry;
        this.resolvableDependencies = (ConfigurationResolvableDependencies)instantiator.newInstance(ConfigurationResolvableDependencies.class, new Object[]{this});
        this.displayName = Describables.memoize((Describable)new ConfigurationDescription(this.identityPath));
        this.ownDependencies = (DefaultDomainObjectSet)domainObjectCollectionFactory.newDomainObjectSet(Dependency.class);
        this.ownDependencies.beforeCollectionChanges(DefaultConfiguration.validateMutationType(this, MutationValidator.MutationType.DEPENDENCIES));
        this.ownDependencyConstraints = (DefaultDomainObjectSet)domainObjectCollectionFactory.newDomainObjectSet(DependencyConstraint.class);
        this.ownDependencyConstraints.beforeCollectionChanges(DefaultConfiguration.validateMutationType(this, MutationValidator.MutationType.DEPENDENCIES));
        this.dependencies = new DefaultDependencySet((Describable)Describables.of((Object)this.displayName, (Object)"dependencies"), this, (DomainObjectSet<Dependency>)this.ownDependencies);
        this.dependencyConstraints = new DefaultDependencyConstraintSet((Describable)Describables.of((Object)this.displayName, (Object)"dependency constraints"), this, (DomainObjectSet<DependencyConstraint>)this.ownDependencyConstraints);
        this.ownArtifacts = (DefaultDomainObjectSet)domainObjectCollectionFactory.newDomainObjectSet(PublishArtifact.class);
        this.ownArtifacts.beforeCollectionChanges(DefaultConfiguration.validateMutationType(this, MutationValidator.MutationType.ARTIFACTS));
        this.artifacts = new DefaultPublishArtifactSet((Describable)Describables.of((Object)this.displayName, (Object)"artifacts"), (DomainObjectSet<PublishArtifact>)this.ownArtifacts, fileCollectionFactory, taskDependencyFactory);
        this.outgoing = (DefaultConfigurationPublications)instantiator.newInstance(DefaultConfigurationPublications.class, new Object[]{this.displayName, this.artifacts, new AllArtifactsProvider(), this.configurationAttributes, instantiator, artifactNotationParser, capabilityNotationParser, fileCollectionFactory, attributesFactory, domainObjectCollectionFactory, taskDependencyFactory});
        this.rootComponentMetadataBuilder = rootComponentMetadataBuilder;
        this.currentResolveState = domainObjectContext.getModel().newCalculatedValue((Object)ResolveState.NOT_RESOLVED);
        this.path = domainObjectContext.projectPath(name);
        this.defaultConfigurationFactory = defaultConfigurationFactory;
        this.canBeConsumed = roleAtCreation.isConsumable();
        this.canBeResolved = roleAtCreation.isResolvable();
        this.canBeDeclaredAgainst = roleAtCreation.isDeclarableAgainst();
        if (roleAtCreation.isConsumptionDeprecated()) {
            this.deprecateForConsumption();
        }
        if (roleAtCreation.isResolutionDeprecated()) {
            this.deprecateForResolution(new String[0]);
        }
        if (roleAtCreation.isDeclarationAgainstDeprecated()) {
            this.deprecateForDeclarationAgainst(new String[0]);
        }
        if (lockUsage) {
            this.preventUsageMutation();
        }
        this.roleAtCreation = roleAtCreation;
    }

    private static Action<Void> validateMutationType(MutationValidator mutationValidator, MutationValidator.MutationType type) {
        return arg -> mutationValidator.validateMutation(type);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Configuration.State getState() {
        ResolveState currentState = (ResolveState)this.currentResolveState.get();
        ConfigurationInternal.InternalState resolvedState = currentState.state;
        if (resolvedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED || resolvedState == ConfigurationInternal.InternalState.GRAPH_RESOLVED) {
            if (currentState.hasError()) {
                return Configuration.State.RESOLVED_WITH_FAILURES;
            }
            return Configuration.State.RESOLVED;
        }
        return Configuration.State.UNRESOLVED;
    }

    @VisibleForTesting
    public ConfigurationInternal.InternalState getResolvedState() {
        return ((ResolveState)this.currentResolveState.get()).state;
    }

    public Module getModule() {
        return this.metaDataProvider.getModule();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Configuration setVisible(boolean visible) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.visible = visible;
        return this;
    }

    public Set<Configuration> getExtendsFrom() {
        return Collections.unmodifiableSet(this.extendsFrom);
    }

    public Configuration setExtendsFrom(Iterable<Configuration> extendsFrom) {
        this.validateMutation(MutationValidator.MutationType.HIERARCHY);
        for (Configuration configuration : this.extendsFrom) {
            if (this.inheritedArtifacts != null) {
                this.inheritedArtifacts.removeCollection((DomainObjectCollection)configuration.getAllArtifacts());
            }
            if (this.inheritedDependencies != null) {
                this.inheritedDependencies.removeCollection((DomainObjectCollection)configuration.getAllDependencies());
            }
            if (this.inheritedDependencyConstraints != null) {
                this.inheritedDependencyConstraints.removeCollection((DomainObjectCollection)configuration.getAllDependencyConstraints());
            }
            ((ConfigurationInternal)configuration).removeMutationValidator(this.parentMutationValidator);
        }
        this.extendsFrom = new LinkedHashSet<Configuration>();
        for (Configuration configuration : extendsFrom) {
            this.extendsFrom(configuration);
        }
        return this;
    }

    public Configuration extendsFrom(Configuration ... extendsFrom) {
        this.validateMutation(MutationValidator.MutationType.HIERARCHY);
        for (Configuration configuration : extendsFrom) {
            if (configuration.getHierarchy().contains(this)) {
                throw new InvalidUserDataException(String.format("Cyclic extendsFrom from %s and %s is not allowed. See existing hierarchy: %s", this, configuration, configuration.getHierarchy()));
            }
            if (!this.extendsFrom.add(configuration)) continue;
            if (this.inheritedArtifacts != null) {
                this.inheritedArtifacts.addCollection((DomainObjectCollection)configuration.getAllArtifacts());
            }
            if (this.inheritedDependencies != null) {
                this.inheritedDependencies.addCollection((DomainObjectCollection)configuration.getAllDependencies());
            }
            if (this.inheritedDependencyConstraints != null) {
                this.inheritedDependencyConstraints.addCollection((DomainObjectCollection)configuration.getAllDependencyConstraints());
            }
            ((ConfigurationInternal)configuration).addMutationValidator(this.parentMutationValidator);
        }
        return this;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public Configuration setTransitive(boolean transitive) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.transitive = transitive;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public Configuration setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    public Set<Configuration> getHierarchy() {
        if (this.extendsFrom.isEmpty()) {
            return Collections.singleton(this);
        }
        Set result = WrapUtil.toLinkedSet((Object[])new Configuration[]{this});
        this.collectSuperConfigs(this, result);
        return result;
    }

    private void collectSuperConfigs(Configuration configuration, Set<Configuration> result) {
        for (Configuration superConfig : configuration.getExtendsFrom()) {
            result.remove(superConfig);
            result.add(superConfig);
            this.collectSuperConfigs(superConfig, result);
        }
    }

    public Configuration defaultDependencies(Action<? super DependencySet> action) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.defaultDependencyActions = this.defaultDependencyActions.add(dependencies -> {
            if (dependencies.isEmpty()) {
                action.execute(dependencies);
            }
        });
        return this;
    }

    public Configuration withDependencies(Action<? super DependencySet> action) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.withDependencyActions = this.withDependencyActions.add(action);
        return this;
    }

    @Override
    public void runDependencyActions() {
        this.defaultDependencyActions.execute((Object)this.dependencies);
        this.withDependencyActions.execute((Object)this.dependencies);
        this.defaultDependencyActions = ImmutableActionSet.empty();
        this.withDependencyActions = ImmutableActionSet.empty();
        for (Configuration superConfig : this.extendsFrom) {
            ((ConfigurationInternal)superConfig).runDependencyActions();
        }
    }

    public Set<Configuration> getAll() {
        return ImmutableSet.copyOf(this.configurationsProvider.getAll());
    }

    public Set<File> resolve() {
        return this.getFiles();
    }

    public Iterator<File> iterator() {
        return this.intrinsicFiles.iterator();
    }

    protected void visitContents(FileCollectionStructureVisitor visitor) {
        this.intrinsicFiles.visitStructure(visitor);
    }

    protected void appendContents(TreeFormatter formatter) {
        formatter.node("configuration: " + this.getIdentityPath());
    }

    public boolean contains(File file) {
        return this.intrinsicFiles.contains(file);
    }

    public boolean isEmpty() {
        return this.intrinsicFiles.isEmpty();
    }

    public Set<File> files(Dependency ... dependencies) {
        return this.fileCollection(dependencies).getFiles();
    }

    public Set<File> files(Closure dependencySpecClosure) {
        return this.fileCollection(dependencySpecClosure).getFiles();
    }

    public Set<File> files(Spec<? super Dependency> dependencySpec) {
        return this.fileCollection(dependencySpec).getFiles();
    }

    public FileCollection fileCollection(Spec<? super Dependency> dependencySpec) {
        this.assertIsResolvable();
        return this.fileCollectionFromSpec(dependencySpec);
    }

    private ResolutionBackedFileCollection fileCollectionFromSpec(Spec<? super Dependency> dependencySpec) {
        return new ResolutionBackedFileCollection(new SelectedArtifactsProvider(dependencySpec, this.configurationAttributes, (Spec<? super ComponentIdentifier>)Specs.satisfyAll(), false, false, new VisitedArtifactsSetProvider()), false, new DefaultResolutionHost(), this.taskDependencyFactory);
    }

    public FileCollection fileCollection(Closure dependencySpecClosure) {
        return this.fileCollection((Spec<? super Dependency>)Specs.convertClosureToSpec((Closure)dependencySpecClosure));
    }

    public FileCollection fileCollection(Dependency ... dependencies) {
        Set deps = WrapUtil.toLinkedSet((Object[])dependencies);
        return this.fileCollection((Spec<? super Dependency>)((Spec)deps::contains));
    }

    @Override
    public void markAsObserved(ConfigurationInternal.InternalState requestedState) {
        this.markThisObserved(requestedState);
        this.markParentsObserved(requestedState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markThisObserved(ConfigurationInternal.InternalState requestedState) {
        Object object = this.observationLock;
        synchronized (object) {
            if (this.observedState.compareTo(requestedState) < 0) {
                this.observedState = requestedState;
            }
        }
    }

    private void markParentsObserved(ConfigurationInternal.InternalState requestedState) {
        for (Configuration configuration : this.extendsFrom) {
            ((ConfigurationInternal)configuration).markAsObserved(requestedState);
        }
    }

    public ResolvedConfiguration getResolvedConfiguration() {
        return this.resolveToStateOrLater(ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED).getResolvedConfiguration();
    }

    private ResolveState resolveToStateOrLater(ConfigurationInternal.InternalState requestedState) {
        this.assertIsResolvable();
        this.warnIfConfigurationIsDeprecatedForResolving();
        this.logIfImproperConfiguration();
        ResolveState currentState = (ResolveState)this.currentResolveState.get();
        if (currentState.state.compareTo(requestedState) >= 0) {
            return currentState;
        }
        if (!this.domainObjectContext.getModel().hasMutableState()) {
            if (!this.workerThreadRegistry.isWorkerThread()) {
                throw new IllegalStateException("The configuration " + this.identityPath.toString() + " was resolved from a thread not managed by Gradle.");
            }
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateBehaviour((String)("Resolution of the configuration " + this.identityPath.toString() + " was attempted from a context different than the project context. Have a look at the documentation to understand why this is a problem and how it can be resolved.")).willBecomeAnErrorInGradle9().withUserManual("viewing_debugging_dependencies", "sub:resolving-unsafe-configuration-resolution-errors")).nagUser();
            return (ResolveState)this.domainObjectContext.getModel().fromMutableState(p -> this.resolveExclusively(requestedState));
        }
        return this.resolveExclusively(requestedState);
    }

    private void warnIfConfigurationIsDeprecatedForResolving() {
        if (this.resolutionAlternatives != null) {
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateConfiguration)DeprecationLogger.deprecateConfiguration((String)this.name).forResolution().replaceWith(this.resolutionAlternatives)).willBecomeAnErrorInGradle9().withUpgradeGuideSection(5, "dependencies_should_no_longer_be_declared_using_the_compile_and_runtime_configurations")).nagUser();
        }
    }

    private ResolveState resolveExclusively(ConfigurationInternal.InternalState requestedState) {
        return (ResolveState)this.currentResolveState.update(initial -> {
            ResolveState current = initial;
            if (requestedState == ConfigurationInternal.InternalState.GRAPH_RESOLVED || requestedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) {
                current = this.resolveGraphIfRequired(requestedState, current);
            }
            if (requestedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) {
                current = this.resolveArtifactsIfRequired(current);
            }
            return current;
        });
    }

    private ResolveState resolveGraphIfRequired(final ConfigurationInternal.InternalState requestedState, ResolveState currentState) {
        if (currentState.state == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED || currentState.state == ConfigurationInternal.InternalState.GRAPH_RESOLVED) {
            if (this.dependenciesModified) {
                throw new InvalidUserDataException(String.format("Attempted to resolve %s that has been resolved previously.", this.getDisplayName()));
            }
            return currentState;
        }
        return (ResolveState)this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<ResolveState>(){

            public ResolveState call(BuildOperationContext context) {
                DefaultConfiguration.this.runDependencyActions();
                DefaultConfiguration.this.preventFromFurtherMutation();
                ResolvableDependenciesInternal incoming = (ResolvableDependenciesInternal)DefaultConfiguration.this.getIncoming();
                DefaultConfiguration.this.performPreResolveActions(incoming);
                DefaultResolverResults results = new DefaultResolverResults();
                DefaultConfiguration.this.resolver.resolveGraph(DefaultConfiguration.this, results);
                DefaultConfiguration.this.dependenciesModified = false;
                ResolveState newState = new GraphResolved(results);
                DefaultConfiguration.this.currentResolveState.set((Object)newState);
                DefaultConfiguration.this.markParentsObserved(requestedState);
                DefaultConfiguration.this.markReferencedProjectConfigurationsObserved(requestedState, results);
                if (!((ResolveState)newState).hasError()) {
                    ((DependencyResolutionListener)DefaultConfiguration.this.dependencyResolutionListeners.getSource()).afterResolve((ResolvableDependencies)incoming);
                    DefaultConfiguration.this.dependencyResolutionListeners.removeAll();
                    newState = (ResolveState)DefaultConfiguration.this.currentResolveState.get();
                }
                this.captureBuildOperationResult(context, results);
                return newState;
            }

            private void captureBuildOperationResult(BuildOperationContext context, ResolverResults results) {
                Throwable failure = results.getFailure();
                if (failure != null) {
                    context.failed(failure);
                }
                ResolutionResult resolutionResult = results.getResolutionResult();
                context.setResult((Object)ResolveConfigurationResolutionBuildOperationResult.create(resolutionResult, DefaultConfiguration.this.attributesFactory));
            }

            public BuildOperationDescriptor.Builder description() {
                String displayName = "Resolve dependencies of " + DefaultConfiguration.this.identityPath;
                Path projectPath = DefaultConfiguration.this.domainObjectContext.getProjectPath();
                String projectPathString = null;
                if (!DefaultConfiguration.this.domainObjectContext.isScript() && projectPath != null) {
                    projectPathString = projectPath.getPath();
                }
                return BuildOperationDescriptor.displayName((String)displayName).progressDisplayName(displayName).details((Object)new ResolveConfigurationResolutionBuildOperationDetails(DefaultConfiguration.this.getName(), DefaultConfiguration.this.domainObjectContext.isScript(), DefaultConfiguration.this.getDescription(), DefaultConfiguration.this.domainObjectContext.getBuildPath().getPath(), projectPathString, DefaultConfiguration.this.isVisible(), DefaultConfiguration.this.isTransitive(), DefaultConfiguration.this.resolver.getRepositories()));
            }
        });
    }

    @Override
    public ConfigurationInternal getConsistentResolutionSource() {
        return this.consistentResolutionSource;
    }

    private Stream<DependencyConstraint> getConsistentResolutionConstraints() {
        if (this.consistentResolutionSource == null) {
            return Stream.empty();
        }
        this.assertThatConsistentResolutionIsPropertyConfigured();
        return this.consistentResolutionSource.getIncoming().getResolutionResult().getAllComponents().stream().map(this::registerConsistentResolutionConstraint).filter(Objects::nonNull);
    }

    private void assertThatConsistentResolutionIsPropertyConfigured() {
        if (!this.consistentResolutionSource.isCanBeResolved()) {
            throw new InvalidUserCodeException("You can't use " + this.consistentResolutionSource + " as a consistent resolution source for " + this + " because it isn't a resolvable configuration.");
        }
        this.assertNoDependencyResolutionConsistencyCycle();
    }

    @Override
    public ResolveException maybeAddContext(ResolveException e) {
        return this.failuresWithHint(e.getCauses()).orElse(e);
    }

    private Optional<ResolveException> failuresWithHint(Collection<? extends Throwable> causes) {
        try {
            if (this.ignoresSettingsRepositories()) {
                boolean hasModuleNotFound = causes.stream().anyMatch(ModuleVersionNotFoundException.class::isInstance);
                if (hasModuleNotFound) {
                    return Optional.of(new ResolveExceptionWithHints(this.getDisplayName(), causes, "The project declares repositories, effectively ignoring the repositories you have declared in the settings.", "You can figure out how project repositories are declared by configuring your build to fail on project repositories.", "See " + this.documentationRegistry.getDocumentationFor("declaring_repositories", "sub:fail_build_on_project_repositories") + " for details."));
                }
            }
        }
        catch (Throwable e) {
            return Optional.of(new ResolveException(this.getDisplayName(), (Iterable)ImmutableList.builder().addAll(causes).add((Object)e).build()));
        }
        return Optional.empty();
    }

    private boolean ignoresSettingsRepositories() {
        if (this.domainObjectContext instanceof ProjectInternal) {
            ProjectInternal project = (ProjectInternal)this.domainObjectContext;
            return !project.getRepositories().isEmpty() && !project.getGradle().getSettings().getDependencyResolutionManagement().getRepositories().isEmpty();
        }
        return false;
    }

    private void assertNoDependencyResolutionConsistencyCycle() {
        LinkedHashSet sources = Sets.newLinkedHashSet();
        for (ConfigurationInternal src = this; src != null; src = src.getConsistentResolutionSource()) {
            if (sources.add(src)) continue;
            String cycle = sources.stream().map(Configuration::getName).collect(Collectors.joining(" -> ")) + " -> " + this.getName();
            throw new InvalidUserDataException("Cycle detected in consistent resolution sources: " + cycle);
        }
    }

    @Nullable
    private DependencyConstraint registerConsistentResolutionConstraint(ResolvedComponentResult result) {
        if (result.getId() instanceof ModuleComponentIdentifier) {
            ModuleVersionIdentifier moduleVersion = result.getModuleVersion();
            DefaultDependencyConstraint constraint = DefaultDependencyConstraint.strictly(moduleVersion.getGroup(), moduleVersion.getName(), moduleVersion.getVersion());
            constraint.because(this.consistentResolutionReason);
            return constraint;
        }
        return null;
    }

    private void performPreResolveActions(ResolvableDependencies incoming) {
        DependencyResolutionListener dependencyResolutionListener = (DependencyResolutionListener)this.dependencyResolutionListeners.getSource();
        this.insideBeforeResolve = true;
        try {
            dependencyResolutionListener.beforeResolve(incoming);
        }
        finally {
            this.insideBeforeResolve = false;
        }
    }

    private void markReferencedProjectConfigurationsObserved(ConfigurationInternal.InternalState requestedState, ResolverResults results) {
        ProjectInternal consumingProject = this.domainObjectContext.getProject();
        ProjectState consumingProjectState = consumingProject == null ? null : consumingProject.getOwner();
        for (ResolvedProjectConfiguration projectResult : results.getResolvedLocalComponents().getResolvedProjectConfigurations()) {
            ProjectState targetProjectState = this.projectStateRegistry.stateFor(projectResult.getId());
            this.dependencyObservedBroadcast.dependencyObserved(consumingProjectState, targetProjectState, requestedState, projectResult);
        }
    }

    private ResolveState resolveArtifactsIfRequired(ResolveState currentState) {
        if (currentState.state == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) {
            return currentState;
        }
        if (currentState.state != ConfigurationInternal.InternalState.GRAPH_RESOLVED) {
            throw new IllegalStateException("Cannot resolve artifacts before graph has been resolved.");
        }
        ResolverResults results = currentState.getCachedResolverResults();
        this.resolver.resolveArtifacts(this, results);
        return new ArtifactsResolved(results);
    }

    @Override
    public ExtraExecutionGraphDependenciesResolverFactory getDependenciesResolver() {
        if (this.dependenciesResolverFactory == null) {
            this.dependenciesResolverFactory = new DefaultExtraExecutionGraphDependenciesResolverFactory(this.getIdentity(), new DefaultResolutionResultProvider(), this.domainObjectContext, this.calculatedValueContainerFactory, (attributes, filter) -> {
                ImmutableAttributes fullAttributes = this.attributesFactory.concat(this.configurationAttributes.asImmutable(), attributes);
                return new ResolutionBackedFileCollection(new SelectedArtifactsProvider((Spec<? super Dependency>)Specs.satisfyAll(), (AttributeContainerInternal)fullAttributes, (Spec<? super ComponentIdentifier>)filter, false, false, new VisitedArtifactsSetProvider()), false, new DefaultResolutionHost(), this.taskDependencyFactory);
            });
        }
        return this.dependenciesResolverFactory;
    }

    public void resetResolutionState() {
        this.currentResolveState.set((Object)ResolveState.NOT_RESOLVED);
    }

    private ResolverResults getResultsForBuildDependencies() {
        ResolveState currentState = (ResolveState)this.currentResolveState.get();
        if (currentState.state == ConfigurationInternal.InternalState.UNRESOLVED) {
            throw new IllegalStateException("Cannot query results until resolution has happened.");
        }
        return currentState.getCachedResolverResults();
    }

    private ResolverResults resolveGraphForBuildDependenciesIfRequired() {
        if (this.getResolutionStrategy().resolveGraphToDetermineTaskDependencies()) {
            return this.resolveToStateOrLater(ConfigurationInternal.InternalState.GRAPH_RESOLVED).getCachedResolverResults();
        }
        ResolveState currentState = (ResolveState)this.currentResolveState.update(initial -> {
            if (initial.state == ConfigurationInternal.InternalState.UNRESOLVED) {
                DefaultResolverResults results = new DefaultResolverResults();
                this.resolver.resolveBuildDependencies(this, results);
                this.markReferencedProjectConfigurationsObserved(ConfigurationInternal.InternalState.BUILD_DEPENDENCIES_RESOLVED, results);
                return new BuildDependenciesResolved(results);
            }
            return initial;
        });
        return currentState.getCachedResolverResults();
    }

    private ResolverResults getResultsForArtifacts() {
        ResolveState currentState = (ResolveState)this.currentResolveState.get();
        if (currentState.state != ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) {
            currentState = this.resolveExclusively(ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED);
        }
        return currentState.getCachedResolverResults();
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        this.assertIsResolvable();
        context.add((Object)this.intrinsicFiles);
    }

    public TaskDependency getTaskDependencyFromProjectDependency(boolean useDependedOn, String taskName) {
        if (useDependedOn) {
            return new TasksFromProjectDependencies(taskName, this::getAllDependencies, this.taskDependencyFactory);
        }
        return new TasksFromDependentProjects(taskName, this.getName(), this.taskDependencyFactory);
    }

    public DependencySet getDependencies() {
        return this.dependencies;
    }

    public DependencySet getAllDependencies() {
        if (this.allDependencies == null) {
            this.initAllDependencies();
        }
        return this.allDependencies;
    }

    private synchronized void initAllDependencies() {
        if (this.allDependencies != null) {
            return;
        }
        this.inheritedDependencies = this.domainObjectCollectionFactory.newDomainObjectSet(Dependency.class, this.ownDependencies);
        for (Configuration configuration : this.extendsFrom) {
            this.inheritedDependencies.addCollection((DomainObjectCollection)configuration.getAllDependencies());
        }
        this.allDependencies = new DefaultDependencySet((Describable)Describables.of((Object)this.displayName, (Object)"all dependencies"), this, (DomainObjectSet<Dependency>)this.inheritedDependencies);
    }

    public DependencyConstraintSet getDependencyConstraints() {
        return this.dependencyConstraints;
    }

    public DependencyConstraintSet getAllDependencyConstraints() {
        if (this.allDependencyConstraints == null) {
            this.initAllDependencyConstraints();
        }
        return this.allDependencyConstraints;
    }

    private synchronized void initAllDependencyConstraints() {
        if (this.allDependencyConstraints != null) {
            return;
        }
        this.inheritedDependencyConstraints = this.domainObjectCollectionFactory.newDomainObjectSet(DependencyConstraint.class, this.ownDependencyConstraints);
        for (Configuration configuration : this.extendsFrom) {
            this.inheritedDependencyConstraints.addCollection((DomainObjectCollection)configuration.getAllDependencyConstraints());
        }
        this.allDependencyConstraints = new DefaultDependencyConstraintSet((Describable)Describables.of((Object)this.displayName, (Object)"all dependency constraints"), this, (DomainObjectSet<DependencyConstraint>)this.inheritedDependencyConstraints);
    }

    public PublishArtifactSet getArtifacts() {
        return this.artifacts;
    }

    public PublishArtifactSet getAllArtifacts() {
        this.initAllArtifacts();
        return this.allArtifacts;
    }

    private synchronized void initAllArtifacts() {
        if (this.allArtifacts != null) {
            return;
        }
        DisplayName displayName = Describables.of((Object)this.displayName, (Object)"all artifacts");
        if (!this.canBeMutated && this.extendsFrom.isEmpty()) {
            this.allArtifacts = new DefaultPublishArtifactSet((Describable)displayName, (DomainObjectSet<PublishArtifact>)this.ownArtifacts, this.fileCollectionFactory, this.taskDependencyFactory);
            return;
        }
        if (this.canBeMutated) {
            this.inheritedArtifacts = this.domainObjectCollectionFactory.newDomainObjectSet(PublishArtifact.class, this.ownArtifacts);
        }
        for (Configuration configuration : this.extendsFrom) {
            PublishArtifactSet allArtifacts = configuration.getAllArtifacts();
            if (this.inheritedArtifacts == null && allArtifacts.isEmpty()) continue;
            if (this.inheritedArtifacts == null) {
                this.inheritedArtifacts = this.domainObjectCollectionFactory.newDomainObjectSet(PublishArtifact.class, this.ownArtifacts);
            }
            this.inheritedArtifacts.addCollection((DomainObjectCollection)allArtifacts);
        }
        this.allArtifacts = this.inheritedArtifacts != null ? new DefaultPublishArtifactSet((Describable)displayName, (DomainObjectSet<PublishArtifact>)this.inheritedArtifacts, this.fileCollectionFactory, this.taskDependencyFactory) : new DefaultPublishArtifactSet((Describable)displayName, (DomainObjectSet<PublishArtifact>)this.ownArtifacts, this.fileCollectionFactory, this.taskDependencyFactory);
    }

    public Set<ExcludeRule> getExcludeRules() {
        this.initExcludeRules();
        return Collections.unmodifiableSet(this.parsedExcludeRules);
    }

    @Override
    public Set<ExcludeRule> getAllExcludeRules() {
        LinkedHashSet result = Sets.newLinkedHashSet();
        result.addAll(this.getExcludeRules());
        for (Configuration config : this.extendsFrom) {
            result.addAll(((ConfigurationInternal)config).getAllExcludeRules());
        }
        return result;
    }

    private synchronized void initExcludeRules() {
        if (this.parsedExcludeRules == null) {
            NotationParser parser = ExcludeRuleNotationConverter.parser();
            this.parsedExcludeRules = Sets.newLinkedHashSet();
            for (Object excludeRule : this.excludeRules) {
                this.parsedExcludeRules.add((ExcludeRule)parser.parseNotation(excludeRule));
            }
        }
    }

    public void setExcludeRules(Set<ExcludeRule> excludeRules) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.parsedExcludeRules = null;
        this.excludeRules.clear();
        this.excludeRules.addAll(excludeRules);
    }

    public DefaultConfiguration exclude(Map<String, String> excludeRuleArgs) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.parsedExcludeRules = null;
        this.excludeRules.add(excludeRuleArgs);
        return this;
    }

    @Deprecated
    public String getUploadTaskName() {
        return Configurations.uploadTaskName(this.getName());
    }

    @Override
    public String getDisplayName() {
        return this.displayName.getDisplayName();
    }

    public ResolvableDependencies getIncoming() {
        return this.resolvableDependencies;
    }

    public ConfigurationPublications getOutgoing() {
        return this.outgoing;
    }

    @Override
    public OutgoingVariant convertToOutgoingVariant() {
        return this.outgoing.convertToOutgoingVariant();
    }

    @Override
    public void collectVariants(ConfigurationInternal.VariantVisitor visitor) {
        this.outgoing.collectVariants(visitor);
    }

    @Override
    public void beforeLocking(Action<? super ConfigurationInternal> action) {
        if (this.canBeMutated) {
            this.beforeLocking = this.beforeLocking != null ? Actions.composite((Action[])new Action[]{this.beforeLocking, action}) : action;
        }
    }

    @Override
    public boolean isCanBeMutated() {
        return this.canBeMutated;
    }

    public void preventFromFurtherMutation() {
        this.preventFromFurtherMutation(false);
    }

    @Override
    public List<? extends GradleException> preventFromFurtherMutationLenient() {
        return this.preventFromFurtherMutation(true);
    }

    private List<? extends GradleException> preventFromFurtherMutation(boolean lenient) {
        if (this.canBeMutated) {
            if (this.beforeLocking != null) {
                this.beforeLocking.execute((Object)this);
                this.beforeLocking = null;
            }
            ImmutableAttributes delegatee = this.configurationAttributes.asImmutable();
            this.configurationAttributes = new ImmutableAttributeContainerWithErrorMessage((AttributeContainerInternal)delegatee, (Describable)this.displayName);
            this.outgoing.preventFromFurtherMutation();
            this.canBeMutated = false;
            this.preventUsageMutation();
            this.logIfImproperConfiguration();
            if (this.mustHaveUniqueAttributes(this) && !this.getAttributes().isEmpty()) {
                return this.ensureUniqueAttributes(lenient);
            }
        }
        return Collections.emptyList();
    }

    private List<? extends GradleException> ensureUniqueAttributes(boolean lenient) {
        Set<? extends ConfigurationInternal> all;
        Set<? extends ConfigurationInternal> set = all = this.configurationsProvider != null ? this.configurationsProvider.getAll() : null;
        if (all != null) {
            Collection<? extends Capability> allCapabilities = this.allCapabilitiesIncludingDefault(this);
            Predicate<ConfigurationInternal> isDuplicate = otherConfiguration -> this.hasSameCapabilitiesAs(allCapabilities, (ConfigurationInternal)otherConfiguration) && this.hasSameAttributesAs((ConfigurationInternal)otherConfiguration);
            List collisions = all.stream().filter(c -> c != this).filter(this::mustHaveUniqueAttributes).filter(c -> !c.isCanBeMutated()).filter(isDuplicate).map(ResolveContext::getDisplayName).collect(Collectors.toList());
            if (!collisions.isEmpty()) {
                DocumentedFailure.Builder builder = DocumentedFailure.builder();
                String advice = "Consider adding an additional attribute to one of the configurations to disambiguate them.";
                if (!lenient) {
                    advice = advice + "  Run the 'outgoingVariants' task for more details.";
                }
                GradleException gradleException = ((DocumentedFailure.Builder)builder.withSummary("Consumable configurations with identical capabilities within a project (other than the default configuration) must have unique attributes, but " + this.getDisplayName() + " and " + collisions + " contain identical attribute sets.").withAdvice(advice).withUserManual("upgrading_version_7", "unique_attribute_sets")).build();
                if (lenient) {
                    return Collections.singletonList(gradleException);
                }
                throw gradleException;
            }
        }
        return Collections.emptyList();
    }

    private boolean mustHaveUniqueAttributes(Configuration configuration) {
        return configuration.isCanBeConsumed() && !configuration.isCanBeResolved() && !"default".equals(configuration.getName());
    }

    private Collection<? extends Capability> allCapabilitiesIncludingDefault(Configuration conf) {
        if (conf.getOutgoing().getCapabilities().isEmpty()) {
            ProjectInternal project = this.domainObjectContext.getProject();
            if (project == null) {
                throw new IllegalStateException("Project is null for configuration '" + conf.getName() + "'.");
            }
            return Collections.singleton(new ProjectDerivedCapability((Project)project));
        }
        return conf.getOutgoing().getCapabilities();
    }

    private boolean hasSameCapabilitiesAs(Collection<? extends Capability> allMyCapabilities, ConfigurationInternal other) {
        Collection<? extends Capability> allOtherCapabilities = this.allCapabilitiesIncludingDefault(other);
        return allMyCapabilities.size() == allOtherCapabilities.size() && allMyCapabilities.containsAll(allOtherCapabilities);
    }

    private boolean hasSameAttributesAs(ConfigurationInternal other) {
        return other.getAttributes().asMap().equals(this.getAttributes().asMap());
    }

    @Override
    public boolean isIncubating() {
        return IncubatingAttributesChecker.isAnyIncubating((AttributeContainer)this.getAttributes());
    }

    public void outgoing(Action<? super ConfigurationPublications> action) {
        action.execute((Object)this.outgoing);
    }

    public ConfigurationInternal copy() {
        return this.createCopy((Set<Dependency>)this.getDependencies(), (Set<DependencyConstraint>)this.getDependencyConstraints());
    }

    public Configuration copyRecursive() {
        return this.createCopy((Set<Dependency>)this.getAllDependencies(), (Set<DependencyConstraint>)this.getAllDependencyConstraints());
    }

    public Configuration copy(Spec<? super Dependency> dependencySpec) {
        return this.createCopy(CollectionUtils.filter((Set)this.getDependencies(), dependencySpec), (Set<DependencyConstraint>)this.getDependencyConstraints());
    }

    public Configuration copyRecursive(Spec<? super Dependency> dependencySpec) {
        return this.createCopy(CollectionUtils.filter((Set)this.getAllDependencies(), dependencySpec), (Set<DependencyConstraint>)this.getAllDependencyConstraints());
    }

    private DefaultConfiguration createCopy(Set<Dependency> dependencies, Set<DependencyConstraint> dependencyConstraints) {
        ConfigurationRole adjustedCurrentUsage = ConfigurationRole.forUsage((boolean)true, (boolean)true, (boolean)true, (!this.canBeConsumed || this.consumptionDeprecation != null ? 1 : 0) != 0, (!this.canBeResolved || this.resolutionAlternatives != null ? 1 : 0) != 0, (!this.canBeDeclaredAgainst || this.declarationAlternatives != null ? 1 : 0) != 0);
        DefaultConfiguration copiedConfiguration = this.newConfiguration(adjustedCurrentUsage, this.usageCanBeMutated);
        copiedConfiguration.visible = this.visible;
        copiedConfiguration.transitive = this.transitive;
        copiedConfiguration.description = this.description;
        copiedConfiguration.defaultDependencyActions = this.defaultDependencyActions;
        copiedConfiguration.withDependencyActions = this.withDependencyActions;
        copiedConfiguration.dependencyResolutionListeners = this.dependencyResolutionListeners.copy();
        copiedConfiguration.declarationAlternatives = this.canBeDeclaredAgainst || this.declarationAlternatives != null ? this.declarationAlternatives : Collections.emptyList();
        copiedConfiguration.resolutionAlternatives = this.canBeResolved || this.resolutionAlternatives != null ? this.resolutionAlternatives : Collections.emptyList();
        copiedConfiguration.consumptionDeprecation = this.canBeConsumed || this.consumptionDeprecation != null ? this.consumptionDeprecation : (DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateConfiguration((String)this.name).forConsumption().willBecomeAnErrorInGradle9().undocumented();
        copiedConfiguration.getArtifacts().addAll((Collection)this.getAllArtifacts());
        if (!this.configurationAttributes.isEmpty()) {
            for (Attribute attribute : this.configurationAttributes.keySet()) {
                Object value = this.configurationAttributes.getAttribute(attribute);
                copiedConfiguration.getAttributes().attribute((Attribute)Cast.uncheckedNonnullCast((Object)attribute), value);
            }
        }
        for (ExcludeRule excludeRule : this.getAllExcludeRules()) {
            copiedConfiguration.excludeRules.add(new DefaultExcludeRule(excludeRule.getGroup(), excludeRule.getModule()));
        }
        DependencySet copiedDependencies = copiedConfiguration.getDependencies();
        for (Dependency dependency : dependencies) {
            copiedDependencies.add((Object)dependency.copy());
        }
        DependencyConstraintSet dependencyConstraintSet = copiedConfiguration.getDependencyConstraints();
        for (DependencyConstraint dependencyConstraint : dependencyConstraints) {
            dependencyConstraintSet.add((Object)((DependencyConstraintInternal)dependencyConstraint).copy());
        }
        return copiedConfiguration;
    }

    private DefaultConfiguration newConfiguration(ConfigurationRole role, boolean usageCanBeMutated) {
        DetachedConfigurationsProvider configurationsProvider = new DetachedConfigurationsProvider();
        RootComponentMetadataBuilder rootComponentMetadataBuilder = this.rootComponentMetadataBuilder.withConfigurationsProvider(configurationsProvider);
        String newName = this.getNameWithCopySuffix();
        Factory childResolutionStrategy = this.resolutionStrategy != null ? Factories.constant((Object)this.resolutionStrategy.copy()) : this.resolutionStrategyFactory;
        DefaultConfiguration copiedConfiguration = this.defaultConfigurationFactory.create(newName, configurationsProvider, (Factory<ResolutionStrategyInternal>)childResolutionStrategy, rootComponentMetadataBuilder, role, usageCanBeMutated);
        configurationsProvider.setTheOnlyConfiguration(copiedConfiguration);
        return copiedConfiguration;
    }

    private String getNameWithCopySuffix() {
        int count = this.copyCount.incrementAndGet();
        String copyName = this.name + "Copy";
        return count == 1 ? copyName : copyName + count;
    }

    public Configuration copy(Closure dependencySpec) {
        return this.copy((Spec<? super Dependency>)Specs.convertClosureToSpec((Closure)dependencySpec));
    }

    public Configuration copyRecursive(Closure dependencySpec) {
        return this.copyRecursive((Spec<? super Dependency>)Specs.convertClosureToSpec((Closure)dependencySpec));
    }

    @Override
    public ResolutionStrategyInternal getResolutionStrategy() {
        if (this.resolutionStrategy == null) {
            this.resolutionStrategy = (ResolutionStrategyInternal)this.resolutionStrategyFactory.create();
            this.resolutionStrategy.setMutationValidator(this);
            this.resolutionStrategyFactory = null;
        }
        return this.resolutionStrategy;
    }

    @Override
    public LocalComponentMetadata toRootComponentMetaData() {
        return this.rootComponentMetadataBuilder.toRootComponentMetaData();
    }

    @Override
    public List<? extends DependencyMetadata> getSyntheticDependencies() {
        return (List)this.syntheticDependencies.get();
    }

    private List<? extends DependencyMetadata> generateSyntheticDependencies() {
        ComponentIdentifier componentIdentifier = this.componentIdentifierFactory.createComponentIdentifier(this.getModule());
        Stream<Object> dependencyLockingConstraintMetadata = Stream.empty();
        if (this.getResolutionStrategy().isDependencyLockingEnabled()) {
            DependencyLockingState dependencyLockingState = this.dependencyLockingProvider.loadLockState(this.name);
            boolean strict = dependencyLockingState.mustValidateLockState();
            dependencyLockingConstraintMetadata = dependencyLockingState.getLockedDependencies().stream().map(lockedDependency -> {
                String lockedVersion = lockedDependency.getVersion();
                DefaultMutableVersionConstraint versionConstraint = strict ? DefaultMutableVersionConstraint.withStrictVersion(lockedVersion) : DefaultMutableVersionConstraint.withVersion(lockedVersion);
                ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(lockedDependency.getGroup(), lockedDependency.getModule()), versionConstraint);
                return new LocalComponentDependencyMetadata(componentIdentifier, (ComponentSelector)selector, this.name, (AttributeContainer)this.getAttributes(), (AttributeContainer)ImmutableAttributes.EMPTY, null, Collections.emptyList(), Collections.emptyList(), false, false, false, true, false, true, this.getLockReason(strict, lockedVersion));
            });
        }
        Stream<LocalComponentDependencyMetadata> consistentResolutionConstraintMetadata = this.getConsistentResolutionConstraints().map(dc -> {
            ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(dc.getGroup(), dc.getName()), dc.getVersionConstraint());
            return new LocalComponentDependencyMetadata(componentIdentifier, (ComponentSelector)selector, this.name, (AttributeContainer)this.getAttributes(), (AttributeContainer)ImmutableAttributes.EMPTY, null, Collections.emptyList(), Collections.emptyList(), false, false, false, true, false, true, dc.getReason());
        });
        return (List)Stream.concat(dependencyLockingConstraintMetadata, consistentResolutionConstraintMetadata).collect(ImmutableList.toImmutableList());
    }

    private String getLockReason(boolean strict, String lockedVersion) {
        if (strict) {
            return "dependency was locked to version '" + lockedVersion + "'";
        }
        return "dependency was locked to version '" + lockedVersion + "' (update/lenient mode)";
    }

    @Override
    public String getPath() {
        return this.path.getPath();
    }

    @Override
    public Path getIdentityPath() {
        return this.identityPath;
    }

    @Override
    public void setReturnAllVariants(boolean returnAllVariants) {
        if (!this.canBeMutated) {
            throw new IllegalStateException("Configuration is unmodifiable");
        }
        this.returnAllVariants = returnAllVariants;
    }

    @Override
    public boolean getReturnAllVariants() {
        return this.returnAllVariants;
    }

    public Configuration resolutionStrategy(Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)this.getResolutionStrategy());
        return this;
    }

    public Configuration resolutionStrategy(Action<? super ResolutionStrategy> action) {
        action.execute((Object)this.getResolutionStrategy());
        return this;
    }

    @Override
    public void addMutationValidator(MutationValidator validator) {
        this.childMutationValidators.add(validator);
    }

    @Override
    public void removeMutationValidator(MutationValidator validator) {
        this.childMutationValidators.remove(validator);
    }

    private void validateParentMutation(MutationValidator.MutationType type) {
        if (type == MutationValidator.MutationType.STRATEGY) {
            return;
        }
        this.preventIllegalParentMutation(type);
        this.markAsModified(type);
        this.notifyChildren(type);
    }

    @Override
    public void validateMutation(MutationValidator.MutationType type) {
        this.preventIllegalMutation(type);
        this.markAsModified(type);
        this.notifyChildren(type);
    }

    private void preventIllegalParentMutation(MutationValidator.MutationType type) {
        if (type == MutationValidator.MutationType.DEPENDENCY_ATTRIBUTES) {
            return;
        }
        ConfigurationInternal.InternalState resolvedState = ((ResolveState)this.currentResolveState.get()).state;
        if (resolvedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) {
            throw new InvalidUserDataException(String.format("Cannot change %s of parent of %s after it has been resolved", new Object[]{type, this.getDisplayName()}));
        }
        if (resolvedState == ConfigurationInternal.InternalState.GRAPH_RESOLVED && type == MutationValidator.MutationType.DEPENDENCIES) {
            throw new InvalidUserDataException(String.format("Cannot change %s of parent of %s after task dependencies have been resolved", new Object[]{type, this.getDisplayName()}));
        }
    }

    private void preventIllegalMutation(MutationValidator.MutationType type) {
        if (type == MutationValidator.MutationType.DEPENDENCY_ATTRIBUTES) {
            this.assertIsDeclarableAgainst();
            return;
        }
        ConfigurationInternal.InternalState resolvedState = ((ResolveState)this.currentResolveState.get()).state;
        if (resolvedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) {
            throw new InvalidUserDataException(String.format("Cannot change %s of dependency %s after it has been resolved.", new Object[]{type, this.getDisplayName()}));
        }
        if (resolvedState == ConfigurationInternal.InternalState.GRAPH_RESOLVED) {
            throw new InvalidUserDataException(String.format("Cannot change %s of dependency %s after task dependencies have been resolved", new Object[]{type, this.getDisplayName()}));
        }
        if ((this.observedState == ConfigurationInternal.InternalState.GRAPH_RESOLVED || this.observedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) && type != MutationValidator.MutationType.STRATEGY) {
            String extraMessage = this.insideBeforeResolve ? " Use 'defaultDependencies' instead of 'beforeResolve' to specify default dependencies for a configuration." : "";
            throw new InvalidUserDataException(String.format("Cannot change %s of dependency %s after it has been included in dependency resolution.%s", new Object[]{type, this.getDisplayName(), extraMessage}));
        }
        if (type == MutationValidator.MutationType.USAGE) {
            this.assertUsageIsMutable();
        }
    }

    private void markAsModified(MutationValidator.MutationType type) {
        if (type == MutationValidator.MutationType.DEPENDENCY_ATTRIBUTES) {
            return;
        }
        if (type == MutationValidator.MutationType.STRATEGY) {
            return;
        }
        this.dependenciesModified = true;
    }

    private void notifyChildren(MutationValidator.MutationType type) {
        for (MutationValidator validator : this.childMutationValidators) {
            validator.validateMutation(type);
        }
    }

    private ConfigurationIdentity getIdentity() {
        String name = this.getName();
        String projectPath = this.domainObjectContext.getProjectPath() == null ? null : this.domainObjectContext.getProjectPath().toString();
        String buildPath = this.domainObjectContext.getBuildPath().toString();
        return new DefaultConfigurationIdentity(buildPath, projectPath, name);
    }

    private Optional<? extends RuntimeException> mapFailure(String type, Collection<Throwable> failures) {
        if (failures.isEmpty()) {
            return Optional.empty();
        }
        if (failures.size() == 1) {
            Optional<ResolveException> resolveException = this.failuresWithHint(failures);
            if (resolveException.isPresent()) {
                return resolveException;
            }
            resolveException.ifPresent(UncheckedException::throwAsUncheckedException);
            Throwable failure = failures.iterator().next();
            if (failure instanceof ResolveException) {
                return Optional.of((ResolveException)failure);
            }
        }
        return Optional.of(new DefaultLenientConfiguration.ArtifactResolveException(type, this.getIdentityPath().toString(), this.getDisplayName(), failures));
    }

    private void assertIsResolvable() {
        if (!this.canBeResolved) {
            throw new IllegalStateException("Resolving dependency configuration '" + this.name + "' is not allowed as it is defined as 'canBeResolved=false'.\nInstead, a resolvable ('canBeResolved=true') dependency configuration that extends '" + this.name + "' should be resolved.");
        }
    }

    private void assertIsDeclarableAgainst() {
        if (!this.canBeDeclaredAgainst) {
            throw new IllegalStateException("Declaring dependencies for configuration '" + this.name + "' is not allowed as it is defined as 'canBeDeclared=false'.");
        }
    }

    private void logIfImproperConfiguration() {
        if (this.roleAtCreation != ConfigurationRoles.LEGACY) {
            if (this.canBeConsumed && this.canBeResolved) {
                LOGGER.info("The configuration " + this.identityPath.toString() + " is both resolvable and consumable. This is considered a legacy configuration and it will eventually only be possible to be one of these.");
            }
            if (this.canBeConsumed && this.canBeDeclaredAgainst) {
                LOGGER.info("The configuration " + this.identityPath.toString() + " is both consumable and declarable. This combination is incorrect, only one of these flags should be set.");
            }
        }
    }

    protected void assertCanCarryBuildDependencies() {
        this.assertIsResolvable();
    }

    @Override
    public AttributeContainerInternal getAttributes() {
        return this.configurationAttributes;
    }

    public Configuration attributes(Action<? super AttributeContainer> action) {
        action.execute((Object)this.configurationAttributes);
        return this;
    }

    public void preventUsageMutation() {
        this.usageCanBeMutated = false;
    }

    @VisibleForTesting
    public boolean isUsageMutable() {
        return this.usageCanBeMutated;
    }

    private void assertUsageIsMutable() {
        if (!this.usageCanBeMutated) {
            if (this.roleAtCreation != ConfigurationRoles.LEGACY) {
                throw new GradleException(String.format("Cannot change the allowed usage of %s, as it was locked upon creation to the role: '%s'.\nThis role permits the following usage:\n%s\nIdeally, each configuration should be used for a single purpose.", this.getDisplayName(), this.roleAtCreation.getName(), this.roleAtCreation.describeUsage()));
            }
            throw new GradleException(String.format("Cannot change the allowed usage of %s, as it has been locked.", this.getDisplayName()));
        }
    }

    private void maybeWarnOnChangingUsage(String usage, boolean current) {
        if (!this.isSpecialCaseOfChangingUsage(usage, current)) {
            String msgTemplate = "Allowed usage is changing for %s, %s. Ideally, usage should be fixed upon creation.";
            String changingUsage = usage + " was " + !current + " and is now " + current;
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)String.format(msgTemplate, this.getDisplayName(), changingUsage)).withAdvice("Usage should be fixed upon creation.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "configurations_allowed_usage")).nagUser();
        }
    }

    private boolean isSpecialCaseOfChangingUsage(String usage, boolean current) {
        boolean isInitializing = this.roleAtCreation == null;
        boolean isDetachedConfiguration = this.configurationsProvider instanceof DetachedConfigurationsProvider;
        boolean isLegacyRole = this.roleAtCreation == ConfigurationRoles.LEGACY;
        boolean isPermittedConfigurationChangeForKotlin = this.name.equals("apiElements") || this.name.equals("runtimeElements") && usage.equals("consumable") && !current;
        return isInitializing || isDetachedConfiguration || isLegacyRole || isPermittedConfigurationChangeForKotlin;
    }

    public boolean isDeprecatedForConsumption() {
        return this.consumptionDeprecated;
    }

    public boolean isDeprecatedForResolution() {
        return this.resolutionDeprecated;
    }

    public boolean isDeprecatedForDeclarationAgainst() {
        return this.declarationDeprecated;
    }

    public boolean isCanBeConsumed() {
        return this.canBeConsumed;
    }

    public void setCanBeConsumed(boolean allowed) {
        if (this.canBeConsumed != allowed) {
            this.validateMutation(MutationValidator.MutationType.USAGE);
            this.canBeConsumed = allowed;
            this.maybeWarnOnChangingUsage("consumable", allowed);
        }
    }

    public boolean isCanBeResolved() {
        return this.canBeResolved;
    }

    public void setCanBeResolved(boolean allowed) {
        if (this.canBeResolved != allowed) {
            this.validateMutation(MutationValidator.MutationType.USAGE);
            this.canBeResolved = allowed;
            this.maybeWarnOnChangingUsage("resolvable", allowed);
        }
    }

    public boolean isCanBeDeclaredAgainst() {
        return this.canBeDeclaredAgainst;
    }

    public void setCanBeDeclaredAgainst(boolean allowed) {
        if (this.canBeDeclaredAgainst != allowed) {
            this.validateMutation(MutationValidator.MutationType.USAGE);
            this.canBeDeclaredAgainst = allowed;
            this.maybeWarnOnChangingUsage("declarable against", allowed);
        }
    }

    @VisibleForTesting
    ListenerBroadcast<DependencyResolutionListener> getDependencyResolutionListeners() {
        return this.dependencyResolutionListeners;
    }

    @Nullable
    public List<String> getDeclarationAlternatives() {
        return this.declarationAlternatives;
    }

    @Nullable
    public DeprecationMessageBuilder.WithDocumentation getConsumptionDeprecation() {
        return this.consumptionDeprecation;
    }

    @Nullable
    public List<String> getResolutionAlternatives() {
        return this.resolutionAlternatives;
    }

    public DeprecatableConfiguration deprecateForDeclarationAgainst(String ... alternativesForDeclaring) {
        this.validateMutation(MutationValidator.MutationType.USAGE);
        this.declarationAlternatives = ImmutableList.copyOf((Object[])alternativesForDeclaring);
        if (!this.declarationDeprecated) {
            this.maybeWarnOnChangingUsage("deprecated for declaration against", true);
        }
        this.declarationDeprecated = true;
        return this;
    }

    public DeprecatableConfiguration deprecateForResolution(String ... alternativesForResolving) {
        this.validateMutation(MutationValidator.MutationType.USAGE);
        this.resolutionAlternatives = ImmutableList.copyOf((Object[])alternativesForResolving);
        if (!this.consumptionDeprecated) {
            this.maybeWarnOnChangingUsage("deprecated for resolution", true);
        }
        this.resolutionDeprecated = true;
        return this;
    }

    public DeprecatableConfiguration deprecateForConsumption(Function<DeprecationMessageBuilder.DeprecateConfiguration, DeprecationMessageBuilder.WithDocumentation> deprecation) {
        this.validateMutation(MutationValidator.MutationType.USAGE);
        this.consumptionDeprecation = deprecation.apply(DeprecationLogger.deprecateConfiguration((String)this.name).forConsumption());
        if (!this.consumptionDeprecated) {
            this.maybeWarnOnChangingUsage("deprecated for consumption", true);
        }
        this.consumptionDeprecated = true;
        return this;
    }

    public Configuration shouldResolveConsistentlyWith(Configuration versionsSource) {
        this.consistentResolutionSource = (ConfigurationInternal)versionsSource;
        this.consistentResolutionReason = "version resolved in " + versionsSource + " by consistent resolution";
        return this;
    }

    public Configuration disableConsistentResolution() {
        this.consistentResolutionSource = null;
        this.consistentResolutionReason = null;
        return this;
    }

    public String dump() {
        StringBuilder reply = new StringBuilder();
        reply.append("\nConfiguration:");
        reply.append("  class='").append(this.getClass()).append("'");
        reply.append("  name='").append(this.getName()).append("'");
        reply.append("  hashcode='").append(this.hashCode()).append("'");
        reply.append("\nLocal Dependencies:");
        if (this.getDependencies().size() > 0) {
            for (Dependency d : this.getDependencies()) {
                reply.append("\n   ").append(d);
            }
        } else {
            reply.append("\n   none");
        }
        reply.append("\nLocal Artifacts:");
        if (this.getArtifacts().size() > 0) {
            for (PublishArtifact a : this.getArtifacts()) {
                reply.append("\n   ").append(a);
            }
        } else {
            reply.append("\n   none");
        }
        reply.append("\nAll Dependencies:");
        if (this.getAllDependencies().size() > 0) {
            for (Dependency d : this.getAllDependencies()) {
                reply.append("\n   ").append(d);
            }
        } else {
            reply.append("\n   none");
        }
        reply.append("\nAll Artifacts:");
        if (this.getAllArtifacts().size() > 0) {
            for (PublishArtifact a : this.getAllArtifacts()) {
                reply.append("\n   ").append(a);
            }
        } else {
            reply.append("\n   none");
        }
        return reply.toString();
    }

    private DefaultArtifactCollection artifactCollection(AttributeContainerInternal attributes, Spec<? super ComponentIdentifier> componentFilter, boolean lenient, boolean allowNoMatchingVariants, boolean selectFromAllVariants) {
        ImmutableAttributes viewAttributes = attributes.asImmutable();
        DefaultResolutionHost failureHandler = new DefaultResolutionHost();
        ResolutionBackedFileCollection files = new ResolutionBackedFileCollection(new SelectedArtifactsProvider((Spec<? super Dependency>)Specs.satisfyAll(), (AttributeContainerInternal)viewAttributes, componentFilter, allowNoMatchingVariants, selectFromAllVariants, new VisitedArtifactsSetProvider()), lenient, failureHandler, this.taskDependencyFactory);
        return new DefaultArtifactCollection(files, lenient, failureHandler, this.calculatedValueContainerFactory);
    }

    @Override
    public ConfigurationRole getRoleAtCreation() {
        return this.roleAtCreation;
    }

    private class DefaultResolutionHost
    implements ResolutionHost {
        private DefaultResolutionHost() {
        }

        @Override
        public String getDisplayName() {
            return DefaultConfiguration.this.getDisplayName();
        }

        @Override
        public DisplayName displayName(String type) {
            return Describables.of((Object)DefaultConfiguration.this, (Object)type);
        }

        @Override
        public Optional<? extends RuntimeException> mapFailure(String type, Collection<Throwable> failures) {
            return DefaultConfiguration.this.mapFailure(type, failures);
        }
    }

    private class AllArtifactsProvider
    implements PublishArtifactSetProvider {
        private AllArtifactsProvider() {
        }

        @Override
        public PublishArtifactSet getPublishArtifactSet() {
            return DefaultConfiguration.this.getAllArtifacts();
        }
    }

    public static class ArtifactViewConfiguration
    implements ArtifactView.ViewConfiguration {
        private final ImmutableAttributesFactory attributesFactory;
        private final AttributeContainerInternal configurationAttributes;
        private AttributeContainerInternal viewAttributes;
        private Spec<? super ComponentIdentifier> componentFilter;
        private boolean lenient;
        private boolean reselectVariant;
        private boolean attributesUsed;

        public ArtifactViewConfiguration(ImmutableAttributesFactory attributesFactory, AttributeContainerInternal configurationAttributes) {
            this.attributesFactory = attributesFactory;
            this.configurationAttributes = configurationAttributes;
        }

        public AttributeContainer getAttributes() {
            if (this.viewAttributes == null) {
                this.viewAttributes = this.reselectVariant ? this.attributesFactory.mutable() : this.attributesFactory.mutable(this.configurationAttributes);
                this.attributesUsed = true;
            }
            return this.viewAttributes;
        }

        public ArtifactViewConfiguration attributes(Action<? super AttributeContainer> action) {
            action.execute((Object)this.getAttributes());
            return this;
        }

        public ArtifactViewConfiguration componentFilter(Spec<? super ComponentIdentifier> componentFilter) {
            this.assertComponentFilterUnset();
            this.componentFilter = componentFilter;
            return this;
        }

        public boolean isLenient() {
            return this.lenient;
        }

        public void setLenient(boolean lenient) {
            this.lenient = lenient;
        }

        public ArtifactViewConfiguration lenient(boolean lenient) {
            this.lenient = lenient;
            return this;
        }

        public ArtifactViewConfiguration withVariantReselection() {
            this.reselectVariant = true;
            return this;
        }

        private void assertComponentFilterUnset() {
            if (this.componentFilter != null) {
                throw new IllegalStateException("The component filter can only be set once before the view was computed");
            }
        }

        private Spec<? super ComponentIdentifier> lockComponentFilter() {
            if (this.componentFilter == null) {
                this.componentFilter = Specs.satisfyAll();
            }
            return this.componentFilter;
        }

        private ImmutableAttributes lockViewAttributes() {
            this.viewAttributes = this.viewAttributes == null ? this.configurationAttributes.asImmutable() : this.viewAttributes.asImmutable();
            return this.viewAttributes.asImmutable();
        }
    }

    public class ConfigurationResolvableDependencies
    implements ResolvableDependenciesInternal {
        public String getName() {
            return DefaultConfiguration.this.name;
        }

        public String getPath() {
            return DefaultConfiguration.this.path.getPath();
        }

        public String toString() {
            return "dependencies '" + DefaultConfiguration.this.getIdentityPath() + "'";
        }

        public FileCollection getFiles() {
            DefaultConfiguration.this.assertIsResolvable();
            return DefaultConfiguration.this.intrinsicFiles;
        }

        public DependencySet getDependencies() {
            DefaultConfiguration.this.runDependencyActions();
            return DefaultConfiguration.this.getAllDependencies();
        }

        public DependencyConstraintSet getDependencyConstraints() {
            DefaultConfiguration.this.runDependencyActions();
            return DefaultConfiguration.this.getAllDependencyConstraints();
        }

        public void beforeResolve(Action<? super ResolvableDependencies> action) {
            DefaultConfiguration.this.dependencyResolutionListeners.add("beforeResolve", DefaultConfiguration.this.userCodeApplicationContext.reapplyCurrentLater(action));
        }

        public void beforeResolve(Closure action) {
            this.beforeResolve((Action<? super ResolvableDependencies>)ConfigureUtil.configureUsing((Closure)action));
        }

        public void afterResolve(Action<? super ResolvableDependencies> action) {
            DefaultConfiguration.this.dependencyResolutionListeners.add("afterResolve", DefaultConfiguration.this.userCodeApplicationContext.reapplyCurrentLater(action));
        }

        public void afterResolve(Closure action) {
            this.afterResolve((Action<? super ResolvableDependencies>)ConfigureUtil.configureUsing((Closure)action));
        }

        public ResolutionResult getResolutionResult() {
            DefaultConfiguration.this.assertIsResolvable();
            return new LenientResolutionResult(DEFAULT_ERROR_HANDLER);
        }

        public ArtifactCollection getArtifacts() {
            return DefaultConfiguration.this.artifactCollection(DefaultConfiguration.this.configurationAttributes, (Spec<? super ComponentIdentifier>)Specs.satisfyAll(), false, false, false);
        }

        public ArtifactView artifactView(Action<? super ArtifactView.ViewConfiguration> configAction) {
            ArtifactViewConfiguration config = this.createArtifactViewConfiguration();
            configAction.execute((Object)config);
            return this.createArtifactView(config);
        }

        private ArtifactView createArtifactView(ArtifactViewConfiguration config) {
            ImmutableAttributes viewAttributes = config.lockViewAttributes();
            boolean allowNoMatchingVariants = config.attributesUsed;
            ConfigurationArtifactView view = new ConfigurationArtifactView(viewAttributes, (Spec<? super ComponentIdentifier>)config.lockComponentFilter(), config.lenient, allowNoMatchingVariants, config.reselectVariant);
            return view;
        }

        private ArtifactViewConfiguration createArtifactViewConfiguration() {
            return (ArtifactViewConfiguration)DefaultConfiguration.this.instantiator.newInstance(ArtifactViewConfiguration.class, new Object[]{DefaultConfiguration.this.attributesFactory, DefaultConfiguration.this.configurationAttributes});
        }

        public AttributeContainer getAttributes() {
            return DefaultConfiguration.this.configurationAttributes;
        }

        @Override
        public ResolutionResult getResolutionResult(Action<? super Throwable> errorHandler) {
            return new LenientResolutionResult(errorHandler);
        }

        private class LenientResolutionResult
        implements ResolutionResult {
            private final Action<? super Throwable> errorHandler;
            private volatile ResolutionResult delegate;

            private LenientResolutionResult(Action<? super Throwable> errorHandler) {
                this.errorHandler = errorHandler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void resolve() {
                if (this.delegate == null) {
                    LenientResolutionResult lenientResolutionResult = this;
                    synchronized (lenientResolutionResult) {
                        if (this.delegate == null) {
                            ResolveState currentState = DefaultConfiguration.this.resolveToStateOrLater(ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED);
                            this.delegate = currentState.getCachedResolverResults().getResolutionResult();
                            ResolveException failure = currentState.getCachedResolverResults().consumeNonFatalFailure();
                            if (failure != null) {
                                this.errorHandler.execute((Object)failure);
                            }
                        }
                    }
                }
            }

            public ResolvedComponentResult getRoot() {
                this.resolve();
                return this.delegate.getRoot();
            }

            public Provider<ResolvedComponentResult> getRootComponent() {
                return new DefaultProvider(this::getRoot);
            }

            public Set<? extends DependencyResult> getAllDependencies() {
                this.resolve();
                return this.delegate.getAllDependencies();
            }

            public void allDependencies(Action<? super DependencyResult> action) {
                this.resolve();
                this.delegate.allDependencies(action);
            }

            public void allDependencies(Closure closure) {
                this.resolve();
                this.delegate.allDependencies(closure);
            }

            public Set<ResolvedComponentResult> getAllComponents() {
                this.resolve();
                return this.delegate.getAllComponents();
            }

            public void allComponents(Action<? super ResolvedComponentResult> action) {
                this.resolve();
                this.delegate.allComponents(action);
            }

            public void allComponents(Closure closure) {
                this.resolve();
                this.delegate.allComponents(closure);
            }

            public AttributeContainer getRequestedAttributes() {
                return this.delegate.getRequestedAttributes();
            }

            public int hashCode() {
                this.resolve();
                return this.delegate.hashCode();
            }

            public boolean equals(Object obj) {
                if (obj instanceof LenientResolutionResult) {
                    this.resolve();
                    return this.delegate.equals(((LenientResolutionResult)obj).delegate);
                }
                return false;
            }

            public String toString() {
                return "lenient resolution result for " + this.delegate;
            }
        }

        private class ConfigurationArtifactView
        implements ArtifactView {
            private final ImmutableAttributes viewAttributes;
            private final Spec<? super ComponentIdentifier> componentFilter;
            private final boolean lenient;
            private final boolean allowNoMatchingVariants;
            private final boolean selectFromAllVariants;

            ConfigurationArtifactView(ImmutableAttributes viewAttributes, Spec<? super ComponentIdentifier> componentFilter, boolean lenient, boolean allowNoMatchingVariants, boolean selectFromAllVariants) {
                this.viewAttributes = viewAttributes;
                this.componentFilter = componentFilter;
                this.lenient = lenient;
                this.allowNoMatchingVariants = allowNoMatchingVariants;
                this.selectFromAllVariants = selectFromAllVariants;
            }

            public AttributeContainer getAttributes() {
                return this.viewAttributes;
            }

            public ArtifactCollection getArtifacts() {
                return DefaultConfiguration.this.artifactCollection((AttributeContainerInternal)this.viewAttributes, (Spec<? super ComponentIdentifier>)this.componentFilter, this.lenient, this.allowNoMatchingVariants, this.selectFromAllVariants);
            }

            public FileCollection getFiles() {
                return new ResolutionBackedFileCollection(new SelectedArtifactsProvider((Spec<? super Dependency>)Specs.satisfyAll(), (AttributeContainerInternal)this.viewAttributes, this.componentFilter, this.allowNoMatchingVariants, this.selectFromAllVariants, new VisitedArtifactsSetProvider()), this.lenient, new DefaultResolutionHost(), DefaultConfiguration.this.taskDependencyFactory);
            }
        }
    }

    private static class ArtifactsResolved
    extends WithResults {
        public ArtifactsResolved(ResolverResults results) {
            super(ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED, results);
        }
    }

    private static class GraphResolved
    extends WithResults {
        public GraphResolved(ResolverResults cachedResolverResults) {
            super(ConfigurationInternal.InternalState.GRAPH_RESOLVED, cachedResolverResults);
        }
    }

    private static class BuildDependenciesResolved
    extends WithResults {
        public BuildDependenciesResolved(ResolverResults results) {
            super(ConfigurationInternal.InternalState.BUILD_DEPENDENCIES_RESOLVED, results);
        }
    }

    private static class WithResults
    extends ResolveState {
        final ResolverResults cachedResolverResults;

        WithResults(ConfigurationInternal.InternalState state, ResolverResults cachedResolverResults) {
            super(state);
            this.cachedResolverResults = cachedResolverResults;
        }

        @Override
        boolean hasError() {
            return this.cachedResolverResults.hasError();
        }

        @Override
        public ResolverResults getCachedResolverResults() {
            return this.cachedResolverResults;
        }

        @Override
        public ResolvedConfiguration getResolvedConfiguration() {
            return this.cachedResolverResults.getResolvedConfiguration();
        }
    }

    private static abstract class ResolveState {
        static final ResolveState NOT_RESOLVED = new ResolveState(ConfigurationInternal.InternalState.UNRESOLVED){

            @Override
            public ResolvedConfiguration getResolvedConfiguration() {
                throw new IllegalStateException();
            }

            @Override
            public ResolverResults getCachedResolverResults() {
                throw new IllegalStateException();
            }

            @Override
            public boolean hasError() {
                return false;
            }
        };
        final ConfigurationInternal.InternalState state;

        ResolveState(ConfigurationInternal.InternalState state) {
            this.state = state;
        }

        abstract boolean hasError();

        public abstract ResolvedConfiguration getResolvedConfiguration();

        public abstract ResolverResults getCachedResolverResults();
    }

    private static class SelectedArtifactsProvider
    implements ResolutionResultProvider<SelectedArtifactSet> {
        private final Spec<? super Dependency> dependencySpec;
        private final AttributeContainerInternal viewAttributes;
        private final Spec<? super ComponentIdentifier> componentSpec;
        private final boolean allowNoMatchingVariants;
        private final boolean selectFromAllVariants;
        private final ResolutionResultProvider<VisitedArtifactSet> resultProvider;

        public SelectedArtifactsProvider(Spec<? super Dependency> dependencySpec, AttributeContainerInternal viewAttributes, Spec<? super ComponentIdentifier> componentSpec, boolean allowNoMatchingVariants, boolean selectFromAllVariants, ResolutionResultProvider<VisitedArtifactSet> resultProvider) {
            this.dependencySpec = dependencySpec;
            this.viewAttributes = viewAttributes;
            this.componentSpec = componentSpec;
            this.allowNoMatchingVariants = allowNoMatchingVariants;
            this.selectFromAllVariants = selectFromAllVariants;
            this.resultProvider = resultProvider;
        }

        @Override
        public SelectedArtifactSet getTaskDependencyValue() {
            return this.resultProvider.getTaskDependencyValue().select(this.dependencySpec, this.viewAttributes, this.componentSpec, this.allowNoMatchingVariants, this.selectFromAllVariants);
        }

        @Override
        public SelectedArtifactSet getValue() {
            return this.resultProvider.getValue().select(this.dependencySpec, this.viewAttributes, this.componentSpec, this.allowNoMatchingVariants, this.selectFromAllVariants);
        }
    }

    private class VisitedArtifactsSetProvider
    implements ResolutionResultProvider<VisitedArtifactSet> {
        private VisitedArtifactsSetProvider() {
        }

        @Override
        public VisitedArtifactSet getTaskDependencyValue() {
            DefaultConfiguration.this.assertIsResolvable();
            return DefaultConfiguration.this.resolveGraphForBuildDependenciesIfRequired().getVisitedArtifacts();
        }

        @Override
        public VisitedArtifactSet getValue() {
            DefaultConfiguration.this.assertIsResolvable();
            ResolveState currentState = DefaultConfiguration.this.resolveToStateOrLater(ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED);
            return currentState.getCachedResolverResults().getVisitedArtifacts();
        }
    }

    private class DefaultResolutionResultProvider
    implements ResolutionResultProvider<ResolutionResult> {
        private DefaultResolutionResultProvider() {
        }

        @Override
        public ResolutionResult getTaskDependencyValue() {
            return DefaultConfiguration.this.getResultsForBuildDependencies().getResolutionResult();
        }

        @Override
        public ResolutionResult getValue() {
            return DefaultConfiguration.this.getResultsForArtifacts().getResolutionResult();
        }
    }

    private static class DefaultConfigurationIdentity
    implements ConfigurationIdentity {
        private final String buildPath;
        private final String projectPath;
        private final String name;

        public DefaultConfigurationIdentity(String buildPath, @Nullable String projectPath, String name) {
            this.buildPath = buildPath;
            this.projectPath = projectPath;
            this.name = name;
        }

        public String getBuildPath() {
            return this.buildPath;
        }

        @Nullable
        public String getProjectPath() {
            return this.projectPath;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            Path path = Path.path((String)this.buildPath);
            if (this.projectPath != null) {
                path = path.append(Path.path((String)this.projectPath));
            }
            path = path.child(this.name);
            return "Configuration '" + path.toString() + "'";
        }
    }

    private static class ConfigurationDescription
    implements Describable {
        private final Path identityPath;

        ConfigurationDescription(Path identityPath) {
            this.identityPath = identityPath;
        }

        public String getDisplayName() {
            return "configuration '" + this.identityPath + "'";
        }
    }
}

