/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.scopeids;

import java.io.File;
import org.gradle.cache.PersistentStateCache;
import org.gradle.cache.scopes.BuildTreeScopedCache;
import org.gradle.cache.scopes.GlobalScopedCache;
import org.gradle.cache.scopes.ScopedCache;
import org.gradle.internal.Factory;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.scopeids.PersistentScopeIdLoader;
import org.gradle.internal.scopeids.PersistentScopeIdStoreFactory;
import org.gradle.internal.scopeids.id.UserScopeId;
import org.gradle.internal.scopeids.id.WorkspaceScopeId;

class DefaultPersistentScopeIdLoader
implements PersistentScopeIdLoader {
    private static final String USER_ID_FILENAME = "user-id.txt";
    private static final String WORKSPACE_ID_FILENAME = "workspace-id.txt";
    private final Factory<UniqueId> generator;
    private final PersistentScopeIdStoreFactory storeFactory;
    private final GlobalScopedCache globalScopedCache;
    private final BuildTreeScopedCache buildTreeScopedCache;

    DefaultPersistentScopeIdLoader(GlobalScopedCache globalScopedCache, BuildTreeScopedCache buildTreeScopedCache, PersistentScopeIdStoreFactory storeFactory, Factory<UniqueId> generator) {
        this.globalScopedCache = globalScopedCache;
        this.buildTreeScopedCache = buildTreeScopedCache;
        this.generator = generator;
        this.storeFactory = storeFactory;
    }

    @Override
    public UserScopeId getUser() {
        UniqueId uniqueId = this.get(new ScopeParams((ScopedCache)this.userScopeCacheScopeMarker(), USER_ID_FILENAME, "User ID"));
        return new UserScopeId(uniqueId);
    }

    @Override
    public WorkspaceScopeId getWorkspace() {
        UniqueId uniqueId = this.get(new ScopeParams((ScopedCache)this.workspaceScopeCacheScopeMarker(), WORKSPACE_ID_FILENAME, "Workspace ID"));
        return new WorkspaceScopeId(uniqueId);
    }

    private GlobalScopedCache userScopeCacheScopeMarker() {
        return this.globalScopedCache;
    }

    private BuildTreeScopedCache workspaceScopeCacheScopeMarker() {
        return this.buildTreeScopedCache;
    }

    private UniqueId get(ScopeParams params) {
        PersistentStateCache<UniqueId> store = this.store(params);
        return (UniqueId)store.maybeUpdate((PersistentStateCache.UpdateAction)new PersistentStateCache.UpdateAction<UniqueId>(){

            public UniqueId update(UniqueId oldValue) {
                if (oldValue == null) {
                    return (UniqueId)DefaultPersistentScopeIdLoader.this.generator.create();
                }
                return oldValue;
            }
        });
    }

    private PersistentStateCache<UniqueId> store(ScopeParams params) {
        File file = params.scopedCache.baseDirForCrossVersionCache(params.fileName);
        return this.storeFactory.create(file, params.description);
    }

    private static class ScopeParams {
        private final ScopedCache scopedCache;
        private final String fileName;
        private final String description;

        private ScopeParams(ScopedCache scopedCache, String fileName, String description) {
            this.scopedCache = scopedCache;
            this.fileName = fileName;
            this.description = description;
        }
    }
}

