/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.buildsrc;

import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.plugin.GradlePluginApiVersion;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.initialization.buildsrc.BuildSrcProjectConfigurationAction;
import org.gradle.util.GradleVersion;

public class GradlePluginApiVersionAttributeConfigurationAction
implements BuildSrcProjectConfigurationAction {
    public void execute(ProjectInternal project) {
        project.getPlugins().withType(JavaBasePlugin.class, javaBasePlugin -> this.addGradlePluginApiVersionAttributeToClasspath(project));
    }

    private void addGradlePluginApiVersionAttributeToClasspath(ProjectInternal project) {
        NamedObjectInstantiator instantiator = (NamedObjectInstantiator)project.getServices().get(NamedObjectInstantiator.class);
        ConfigurationContainer configurations = project.getConfigurations();
        ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().all(sourceSet -> this.setAttributeForSourceSet((SourceSet)sourceSet, configurations, instantiator));
    }

    private void setAttributeForSourceSet(SourceSet sourceSet, ConfigurationContainer configurations, NamedObjectInstantiator instantiator) {
        GradlePluginApiVersionAttributeConfigurationAction.setAttributeForConfiguration((NamedDomainObjectProvider<Configuration>)configurations.named(sourceSet.getCompileClasspathConfigurationName()), instantiator);
        GradlePluginApiVersionAttributeConfigurationAction.setAttributeForConfiguration((NamedDomainObjectProvider<Configuration>)configurations.named(sourceSet.getRuntimeClasspathConfigurationName()), instantiator);
    }

    private static void setAttributeForConfiguration(NamedDomainObjectProvider<Configuration> configurationProvider, NamedObjectInstantiator instantiator) {
        configurationProvider.configure(configuration -> configuration.getAttributes().attribute(GradlePluginApiVersion.GRADLE_PLUGIN_API_VERSION_ATTRIBUTE, (Object)((GradlePluginApiVersion)instantiator.named(GradlePluginApiVersion.class, GradleVersion.current().getVersion()))));
    }
}

