/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.dependencies.internal;

import com.googlecode.jatl.Html;
import java.io.Writer;
import java.util.Date;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.reporting.HtmlPageBuilder;
import org.gradle.reporting.ReportRenderer;
import org.gradle.util.GradleVersion;

public class ProjectPageRenderer
extends ReportRenderer<Project, HtmlPageBuilder<Writer>> {
    private final Transformer<String, Project> namingScheme;

    public ProjectPageRenderer(Transformer<String, Project> namingScheme) {
        this.namingScheme = namingScheme;
    }

    public void render(final Project project, final HtmlPageBuilder<Writer> builder) {
        final String baseCssLink = this.requireClassResource("/org/gradle/reporting/base-style.css", builder);
        final String cssLink = this.requireReportResource("style.css", builder);
        final String jqueryLink = this.requireClassResource("/org/gradle/reporting/jquery.min-3.5.1.js", builder);
        final String jtreeLink = this.requireReportResource("jquery.jstree.js", builder);
        final String scriptLink = this.requireReportResource("script.js", builder);
        this.requireReportResource("tree.css", builder);
        this.requireReportResource("d.gif", builder);
        this.requireReportResource("d.png", builder);
        this.requireReportResource("throbber.gif", builder);
        new Html((Writer)builder.getOutput()){
            {
                super(writer);
                this.html();
                this.head();
                ((Html)((Html)this.meta()).httpEquiv("Content-Type")).content("text/html; charset=utf-8");
                ((Html)((Html)this.meta()).httpEquiv("x-ua-compatible")).content("IE=edge");
                ((Html)((Html)((Html)((Html)this.link()).rel("stylesheet")).type("text/css")).href(baseCssLink)).end();
                ((Html)((Html)((Html)((Html)this.link()).rel("stylesheet")).type("text/css")).href(cssLink)).end();
                ((Html)((Html)((Html)this.script()).src(jqueryLink)).charset("utf-8")).end();
                ((Html)((Html)((Html)this.script()).src(jtreeLink)).charset("utf-8")).end();
                ((Html)((Html)((Html)this.script()).src((String)ProjectPageRenderer.this.namingScheme.transform((Object)project))).charset("utf-8")).end();
                ((Html)((Html)((Html)this.script()).src(scriptLink)).charset("utf-8")).end();
                ((Html)((Html)this.title()).text("Dependency reports")).end();
                this.end();
                this.body();
                ((Html)this.div()).id("content");
                ((Html)((Html)this.h1()).text("Dependency Report")).end();
                ((Html)this.div()).classAttr("breadcrumbs");
                ((Html)((Html)((Html)this.a()).href("index.html")).text("Projects")).end();
                this.text(" > ");
                ((Html)((Html)this.span()).id("projectBreadcrumb")).end();
                this.end();
                ((Html)((Html)this.div()).id("insight")).end();
                ((Html)((Html)this.div()).id("dependencies")).end();
                ((Html)this.div()).id("footer");
                this.p();
                this.text("Generated by ");
                ((Html)((Html)((Html)this.a()).href("http://www.gradle.org")).text(GradleVersion.current().toString())).end();
                this.text(" at " + builder.formatDate(new Date()));
                this.end();
                this.end();
                this.end();
                this.end();
                this.endAll();
            }
        };
    }

    private String requireReportResource(String path, HtmlPageBuilder<Writer> builder) {
        return this.requireClassResource(this.getReportResourcePath(path), builder);
    }

    private String requireClassResource(String path, HtmlPageBuilder<Writer> builder) {
        return builder.requireResource(((Object)((Object)this)).getClass().getResource(path));
    }

    private String getReportResourcePath(String fileName) {
        return "/org/gradle/api/tasks/diagnostics/htmldependencyreport/" + fileName;
    }
}

