/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal.install;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.initialization.GradleUserHomeDirProvider;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmMetadataDetector;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.JavaToolchainMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkCacheDirectory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdkCacheDirectory.class);
    private static final String MARKER_FILE = "provisioned.ok";
    private static final String MAC_OS_JAVA_HOME_FOLDER = "Contents/Home";
    private final FileOperations operations;
    private final File jdkDirectory;
    private final FileLockManager lockManager;
    private final JvmMetadataDetector detector;

    @Inject
    public JdkCacheDirectory(GradleUserHomeDirProvider homeDirProvider, FileOperations operations, FileLockManager lockManager, JvmMetadataDetector detector) {
        this.operations = operations;
        this.jdkDirectory = new File(homeDirProvider.getGradleUserHomeDirectory(), "jdks");
        this.lockManager = lockManager;
        this.detector = detector;
        this.jdkDirectory.mkdir();
    }

    public Set<File> listJavaHomes() {
        File[] candidates = this.jdkDirectory.listFiles();
        if (candidates != null) {
            return Arrays.stream(candidates).flatMap(this::allMarkedLocations).map(this::getJavaHome).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private Stream<File> allMarkedLocations(File candidate) {
        if (this.isMarkedLocation(candidate)) {
            return Stream.of(candidate);
        }
        File[] subFolders = candidate.listFiles();
        if (subFolders == null) {
            return Stream.empty();
        }
        return Arrays.stream(subFolders).filter(this::isMarkedLocation);
    }

    private boolean isMarkedLocation(File candidate) {
        return candidate.isDirectory() && new File(candidate, MARKER_FILE).exists();
    }

    private File getJavaHome(File markedLocation) {
        if (OperatingSystem.current().isMacOsX()) {
            if (new File(markedLocation, MAC_OS_JAVA_HOME_FOLDER).exists()) {
                return new File(markedLocation, MAC_OS_JAVA_HOME_FOLDER);
            }
            File[] subfolders = markedLocation.listFiles(File::isDirectory);
            if (subfolders != null) {
                for (File subfolder : subfolders) {
                    if (!new File(subfolder, MAC_OS_JAVA_HOME_FOLDER).exists()) continue;
                    return new File(subfolder, MAC_OS_JAVA_HOME_FOLDER);
                }
            }
        }
        return markedLocation;
    }

    public File provisionFromArchive(JavaToolchainSpec spec, File jdkArchive, URI uri) {
        File file;
        File[] unpackFolder = new File[1];
        File[] installFolder = new File[1];
        try {
            unpackFolder[0] = this.unpack(jdkArchive);
            File markedLocation = this.markLocationInsideFolder(unpackFolder[0]);
            JvmInstallationMetadata metadata = this.getMetadata(markedLocation);
            JdkCacheDirectory.validateMetadataMatchesSpec(spec, uri, metadata);
            String installFolderName = JdkCacheDirectory.getInstallFolderName(metadata);
            installFolder[0] = new File(this.jdkDirectory, installFolderName);
            this.checkInstallFolderForLeftoverContent(installFolder[0], uri, spec, metadata);
            this.operations.delete(new Object[]{installFolder[0]});
            this.operations.copy(copySpec -> {
                copySpec.from(new Object[]{unpackFolder[0]});
                copySpec.into((Object)installFolder[0]);
            });
            LOGGER.info("Installed toolchain from {} into {}", (Object)uri, (Object)installFolder[0]);
            file = this.getJavaHome(this.markedLocation(installFolder[0]));
        }
        catch (Throwable t) {
            try {
                if (installFolder[0] != null) {
                    this.operations.delete(new Object[]{installFolder[0]});
                }
                throw t;
            }
            catch (Throwable throwable) {
                if (unpackFolder[0] != null) {
                    this.operations.delete(new Object[]{unpackFolder[0]});
                }
                throw throwable;
            }
        }
        if (unpackFolder[0] != null) {
            this.operations.delete(new Object[]{unpackFolder[0]});
        }
        return file;
    }

    private void checkInstallFolderForLeftoverContent(File installFolder, URI uri, JavaToolchainSpec spec, JvmInstallationMetadata metadata) {
        String leftoverMetadata;
        if (!installFolder.exists()) {
            return;
        }
        File[] filesInInstallFolder = installFolder.listFiles();
        if (filesInInstallFolder == null || filesInInstallFolder.length == 0) {
            return;
        }
        File markerLocation = this.markedLocation(installFolder);
        if (!this.isMarkedLocation(markerLocation)) {
            return;
        }
        try {
            leftoverMetadata = this.getMetadata(markerLocation).toString();
        }
        catch (Exception e) {
            LOGGER.debug("Failed determining metadata of installation leftover", (Throwable)e);
            leftoverMetadata = "Could not be determined due to: " + e.getMessage();
        }
        LOGGER.warn("While provisioning Java toolchain from '{}' to satisfy spec '{}' (with metadata '{}'), leftover content (with metadata '{}') was found in the install folder '{}'. The existing installation will be replaced by the new download.", new Object[]{uri, spec, metadata, leftoverMetadata, installFolder});
    }

    private JvmInstallationMetadata getMetadata(File markedLocation) {
        File javaHome = this.getJavaHome(markedLocation);
        JvmInstallationMetadata metadata = this.detector.getMetadata(new InstallationLocation(javaHome, "provisioned toolchain", true));
        if (!metadata.isValidInstallation()) {
            throw new GradleException("Provisioned toolchain '" + javaHome + "' could not be probed: " + metadata.getErrorMessage(), metadata.getErrorCause());
        }
        return metadata;
    }

    private File markLocationInsideFolder(File unpackedInstallationFolder) {
        File markedLocation = this.markedLocation(unpackedInstallationFolder);
        this.markAsReady(markedLocation);
        return markedLocation;
    }

    private static void validateMetadataMatchesSpec(JavaToolchainSpec spec, URI uri, JvmInstallationMetadata metadata) {
        if (!new JavaToolchainMatcher(spec).test(metadata)) {
            throw new GradleException("Toolchain provisioned from '" + uri + "' doesn't satisfy the specification: " + spec.getDisplayName() + ".");
        }
    }

    private static String getInstallFolderName(JvmInstallationMetadata metadata) {
        String vendor = metadata.getJvmVendor();
        if (vendor == null || vendor.isEmpty()) {
            vendor = metadata.getVendor().getRawVendor();
        }
        String version = metadata.getLanguageVersion().getMajorVersion();
        String architecture = metadata.getArchitecture();
        String os = OperatingSystem.current().getFamilyName();
        return String.format("%s-%s-%s-%s", vendor, version, architecture, os).replaceAll("[^a-zA-Z0-9\\-]", "_").toLowerCase();
    }

    private File unpack(File jdkArchive) {
        FileTree fileTree = this.asFileTree(jdkArchive);
        String unpackFolderName = JdkCacheDirectory.getNameWithoutExtension(jdkArchive);
        File unpackFolder = new File(this.jdkDirectory, unpackFolderName);
        if (!unpackFolder.exists()) {
            this.operations.copy(spec -> {
                spec.from(new Object[]{fileTree});
                spec.into((Object)unpackFolder);
            });
        }
        return unpackFolder;
    }

    private File markedLocation(File unpackFolder) {
        File[] content = unpackFolder.listFiles();
        if (content == null) {
            throw new RuntimeException("Programming error");
        }
        for (File file : content) {
            if (!file.isDirectory()) continue;
            return file;
        }
        return unpackFolder;
    }

    private File markAsReady(File destination) {
        try {
            new File(destination, MARKER_FILE).createNewFile();
            return destination;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to create .ok file", (Throwable)e);
        }
    }

    private FileTree asFileTree(File jdkArchive) {
        String extension = FilenameUtils.getExtension((String)jdkArchive.getName());
        if (Objects.equals(extension, "zip")) {
            return this.operations.zipTree((Object)jdkArchive);
        }
        return this.operations.tarTree((Object)this.operations.getResources().gzip((Object)jdkArchive));
    }

    public FileLock acquireWriteLock(File destinationFile, String operationName) {
        return this.lockManager.lock(destinationFile, (LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.Exclusive), destinationFile.getName(), operationName);
    }

    public File getDownloadLocation() {
        return this.jdkDirectory;
    }

    private static String getNameWithoutExtension(File file) {
        String input;
        String output = file.getName();
        while (!(input = output).equals(output = Files.getNameWithoutExtension((String)input))) {
        }
        return output;
    }
}

