/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.properties.annotations;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.Collection;
import org.gradle.api.tasks.Nested;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.properties.annotations.AbstractPropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.PropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.PropertyMetadata;

public class NestedBeanAnnotationHandler
extends AbstractPropertyAnnotationHandler {
    public NestedBeanAnnotationHandler(Collection<Class<? extends Annotation>> allowedModifiers) {
        super(Nested.class, PropertyAnnotationHandler.Kind.OTHER, (ImmutableSet<Class<? extends Annotation>>)ImmutableSet.copyOf(allowedModifiers));
    }

    @Override
    public boolean isPropertyRelevant() {
        return true;
    }

    @Override
    public void visitPropertyValue(String propertyName, PropertyValue value, PropertyMetadata propertyMetadata, PropertyVisitor visitor) {
        Object nested = value.call();
        if (nested == null) {
            if (this.getAllowedModifiers().stream().noneMatch(propertyMetadata::isAnnotationPresent)) {
                visitor.visitInputProperty(propertyName, PropertyValue.ABSENT, false);
            }
        }
    }
}

