/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.GeneratedResource;

public class RecompilationSpec {
    private final Set<String> classesToCompile = new LinkedHashSet<String>();
    private final Set<String> sourcePaths = new LinkedHashSet<String>();
    private final Collection<String> classesToProcess = new LinkedHashSet<String>();
    private final Collection<GeneratedResource> resourcesToGenerate = new LinkedHashSet<GeneratedResource>();
    private String fullRebuildCause;

    public String toString() {
        return "RecompilationSpec{classesToCompile=" + this.classesToCompile + ", classesToProcess=" + this.classesToProcess + ", resourcesToGenerate=" + this.resourcesToGenerate + ", sourcePaths=" + this.sourcePaths + ", fullRebuildCause='" + this.fullRebuildCause + '\'' + ", buildNeeded=" + this.isBuildNeeded() + ", fullRebuildNeeded=" + this.isFullRebuildNeeded() + '}';
    }

    public boolean addClassToCompile(String classToCompile) {
        return this.classesToCompile.add(classToCompile);
    }

    public void addClassesToCompile(Collection<String> classes) {
        this.classesToCompile.addAll(classes);
    }

    public Set<String> getClassesToCompile() {
        return Collections.unmodifiableSet(this.classesToCompile);
    }

    public boolean hasClassToCompile(String className) {
        return this.classesToCompile.contains(className);
    }

    public void addClassToReprocess(String classToReprocess) {
        this.classesToProcess.add(classToReprocess);
    }

    public Collection<String> getClassesToProcess() {
        return Collections.unmodifiableCollection(this.classesToProcess);
    }

    public void addResourcesToGenerate(Collection<GeneratedResource> resources) {
        this.resourcesToGenerate.addAll(resources);
    }

    public Collection<GeneratedResource> getResourcesToGenerate() {
        return Collections.unmodifiableCollection(this.resourcesToGenerate);
    }

    public void addSourcePath(String sourcePath) {
        this.sourcePaths.add(sourcePath);
    }

    public void addSourcePaths(Set<String> sourcePath) {
        this.sourcePaths.addAll(sourcePath);
    }

    public Collection<String> getSourcePaths() {
        return Collections.unmodifiableCollection(this.sourcePaths);
    }

    public boolean isBuildNeeded() {
        return this.isFullRebuildNeeded() || !this.classesToCompile.isEmpty() || !this.classesToProcess.isEmpty();
    }

    public boolean isFullRebuildNeeded() {
        return this.fullRebuildCause != null;
    }

    public String getFullRebuildCause() {
        return this.fullRebuildCause;
    }

    public void setFullRebuildCause(String description) {
        this.fullRebuildCause = description;
    }
}

