/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog;

import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.gradle.api.artifacts.ExternalModuleDependencyBundle;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.VersionCatalog;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.internal.catalog.AbstractExternalDependencyFactory;
import org.gradle.api.internal.catalog.AliasNormalizer;
import org.gradle.api.internal.catalog.DefaultExternalDependencyFactory;
import org.gradle.api.internal.catalog.DefaultVersionCatalog;
import org.gradle.api.internal.catalog.ExternalModuleDependencyFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.plugin.use.PluginDependency;

public class VersionCatalogView
implements VersionCatalog {
    private final DefaultVersionCatalog config;
    private final ProviderFactory providerFactory;
    private final ExternalModuleDependencyFactory dependencyFactory;
    private final ObjectFactory objects;

    @Inject
    public VersionCatalogView(DefaultVersionCatalog config, ProviderFactory providerFactory, ObjectFactory objects) {
        this.config = config;
        this.providerFactory = providerFactory;
        this.objects = objects;
        this.dependencyFactory = new DefaultExternalDependencyFactory(config, providerFactory, objects);
    }

    @Deprecated
    public Optional<Provider<MinimalExternalModuleDependency>> findDependency(String alias) {
        ((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(VersionCatalog.class, (String)"findDependency(String)").replaceWith((Object)"findLibrary(String)")).willBeRemovedInGradle8().withUpgradeGuideSection(7, "version_catalog_deprecations").nagUser();
        return this.findLibrary(alias);
    }

    public final Optional<Provider<MinimalExternalModuleDependency>> findLibrary(String alias) {
        String normalizedAlias = AliasNormalizer.normalize(alias);
        if (this.config.getLibraryAliases().contains(normalizedAlias)) {
            return Optional.of(this.dependencyFactory.create(normalizedAlias));
        }
        return Optional.empty();
    }

    public final Optional<Provider<ExternalModuleDependencyBundle>> findBundle(String alias) {
        String normalizedBundle = AliasNormalizer.normalize(alias);
        if (this.config.getBundleAliases().contains(normalizedBundle)) {
            return Optional.of(new AbstractExternalDependencyFactory.BundleFactory(this.objects, this.providerFactory, this.config).createBundle(normalizedBundle));
        }
        return Optional.empty();
    }

    public final Optional<VersionConstraint> findVersion(String alias) {
        String normalizedName = AliasNormalizer.normalize(alias);
        if (this.config.getVersionAliases().contains(normalizedName)) {
            return Optional.of(new AbstractExternalDependencyFactory.VersionFactory(this.providerFactory, this.config).findVersionConstraint(normalizedName));
        }
        return Optional.empty();
    }

    public Optional<Provider<PluginDependency>> findPlugin(String alias) {
        String normalizedAlias = AliasNormalizer.normalize(alias);
        if (this.config.getPluginAliases().contains(normalizedAlias)) {
            return Optional.of(new AbstractExternalDependencyFactory.PluginFactory(this.providerFactory, this.config).createPlugin(normalizedAlias));
        }
        return Optional.empty();
    }

    public final String getName() {
        return this.config.getName();
    }

    @Deprecated
    public List<String> getDependencyAliases() {
        ((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(VersionCatalog.class, (String)"getDependencyAliases()").replaceWith((Object)"getLibraryAliases()")).willBeRemovedInGradle8().withUpgradeGuideSection(7, "version_catalog_deprecations").nagUser();
        return this.getLibraryAliases();
    }

    public List<String> getLibraryAliases() {
        return this.config.getLibraryAliases();
    }

    public List<String> getBundleAliases() {
        return this.config.getBundleAliases();
    }

    public List<String> getVersionAliases() {
        return this.config.getVersionAliases();
    }

    public List<String> getPluginAliases() {
        return this.config.getPluginAliases();
    }
}

