/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization.builtins;

import java.io.Closeable;
import java.io.InputStream;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.BuiltInsPackageFragment;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.builtins.BuiltInsBinaryVersion;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedPackageFragmentImpl;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.builtins.BuiltInSerializerProtocol;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import org.jetbrains.annotations.NotNull;

public final class BuiltInsPackageFragmentImpl
extends DeserializedPackageFragmentImpl
implements BuiltInsPackageFragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isFallback;

    private BuiltInsPackageFragmentImpl(FqName fqName2, StorageManager storageManager, ModuleDescriptor module, ProtoBuf.PackageFragment proto, BuiltInsBinaryVersion metadataVersion, boolean isFallback) {
        super(fqName2, storageManager, module, proto, metadataVersion, null);
        this.isFallback = isFallback;
    }

    @Override
    @NotNull
    public String toString() {
        return "builtins package fragment for " + this.getFqName() + " from " + DescriptorUtilsKt.getModule(this);
    }

    public /* synthetic */ BuiltInsPackageFragmentImpl(FqName fqName2, StorageManager storageManager, ModuleDescriptor module, ProtoBuf.PackageFragment proto, BuiltInsBinaryVersion metadataVersion, boolean isFallback, DefaultConstructorMarker $constructor_marker) {
        this(fqName2, storageManager, module, proto, metadataVersion, isFallback);
    }

    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final BuiltInsPackageFragmentImpl create(@NotNull FqName fqName2, @NotNull StorageManager storageManager, @NotNull ModuleDescriptor module, @NotNull InputStream inputStream, boolean isFallback) {
            ProtoBuf.PackageFragment packageFragment;
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            BuiltInsBinaryVersion version = null;
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream stream = (InputStream)closeable;
                boolean bl = false;
                version = BuiltInsBinaryVersion.Companion.readFrom(stream);
                BuiltInsBinaryVersion builtInsBinaryVersion = version;
                if (builtInsBinaryVersion == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"version");
                    builtInsBinaryVersion = null;
                }
                if (!builtInsBinaryVersion.isCompatible()) {
                    throw new UnsupportedOperationException("Kotlin built-in definition format version is not supported: expected " + BuiltInsBinaryVersion.INSTANCE + ", actual " + version + ". Please update Kotlin");
                }
                packageFragment = ProtoBuf.PackageFragment.parseFrom(stream, BuiltInSerializerProtocol.INSTANCE.getExtensionRegistry());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            ProtoBuf.PackageFragment proto = packageFragment;
            Intrinsics.checkNotNullExpressionValue((Object)proto, (String)"proto");
            return new BuiltInsPackageFragmentImpl(fqName2, storageManager, module, proto, version, isFallback, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

