/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.cache.CrossProcessCacheAccess;
import org.gradle.cache.FileLock;
import org.gradle.cache.MultiProcessSafePersistentIndexedCache;
import org.gradle.cache.internal.MultiProcessSafeAsyncPersistentIndexedCache;

public class CrossProcessSynchronizingCache<K, V>
implements MultiProcessSafePersistentIndexedCache<K, V> {
    private final CrossProcessCacheAccess cacheAccess;
    private final MultiProcessSafeAsyncPersistentIndexedCache<K, V> target;

    public CrossProcessSynchronizingCache(MultiProcessSafeAsyncPersistentIndexedCache<K, V> target, CrossProcessCacheAccess cacheAccess) {
        this.target = target;
        this.cacheAccess = cacheAccess;
    }

    public String toString() {
        return this.target.toString();
    }

    @Override
    @Nullable
    public V getIfPresent(K key) {
        return (V)this.cacheAccess.withFileLock(() -> this.target.get(key));
    }

    @Override
    public V get(K key, Function<? super K, ? extends V> producer) {
        Runnable runnable = this.cacheAccess.acquireFileLock();
        return this.target.get((K)key, producer, runnable);
    }

    @Override
    public void put(K key, V value) {
        Runnable runnable = this.cacheAccess.acquireFileLock();
        this.target.putLater(key, value, runnable);
    }

    @Override
    public void remove(K key) {
        Runnable runnable = this.cacheAccess.acquireFileLock();
        this.target.removeLater(key, runnable);
    }

    @Override
    public void afterLockAcquire(FileLock.State currentCacheState) {
        this.target.afterLockAcquire(currentCacheState);
    }

    @Override
    public void finishWork() {
        this.target.finishWork();
    }

    @Override
    public void beforeLockRelease(FileLock.State currentCacheState) {
        this.target.beforeLockRelease(currentCacheState);
    }
}

