/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.LineEndingNormalizingInputStreamHasher;
import org.gradle.internal.fingerprint.LineEndingSensitivity;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContext;
import org.gradle.internal.fingerprint.hashing.ResourceHasher;
import org.gradle.internal.fingerprint.hashing.ZipEntryContext;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.io.IoSupplier;

public class LineEndingNormalizingResourceHasher
implements ResourceHasher {
    private final ResourceHasher delegate;
    private final LineEndingNormalizingInputStreamHasher hasher;

    private LineEndingNormalizingResourceHasher(ResourceHasher delegate) {
        this.delegate = delegate;
        this.hasher = new LineEndingNormalizingInputStreamHasher();
    }

    public static ResourceHasher wrap(ResourceHasher delegate, LineEndingSensitivity lineEndingSensitivity) {
        switch (lineEndingSensitivity) {
            case DEFAULT: {
                return delegate;
            }
            case NORMALIZE_LINE_ENDINGS: {
                return new LineEndingNormalizingResourceHasher(delegate);
            }
        }
        throw new IllegalArgumentException();
    }

    public void appendConfigurationToHasher(Hasher hasher) {
        this.delegate.appendConfigurationToHasher(hasher);
        hasher.putString((CharSequence)this.getClass().getName());
    }

    @Nullable
    public HashCode hash(RegularFileSnapshotContext snapshotContext) throws IOException {
        return this.hasher.hashContent(new File(snapshotContext.getSnapshot().getAbsolutePath())).orElseGet(IoSupplier.wrap(() -> this.delegate.hash(snapshotContext)));
    }

    @Nullable
    public HashCode hash(ZipEntryContext zipEntryContext) throws IOException {
        return this.hashContent(zipEntryContext).orElseGet(IoSupplier.wrap(() -> this.delegate.hash(zipEntryContext)));
    }

    private Optional<HashCode> hashContent(ZipEntryContext zipEntryContext) throws IOException {
        return zipEntryContext.getEntry().isDirectory() ? Optional.empty() : (Optional)zipEntryContext.getEntry().withInputStream(this.hasher::hashContent);
    }
}

