/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts;

import java.util.Comparator;
import java.util.List;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortComparator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortComparators;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortListIterator;

public interface ShortList
extends ShortCollection,
Comparable<List<? extends Short>>,
List<Short> {
    @Override
    public ShortListIterator iterator();

    public ShortListIterator listIterator();

    public ShortListIterator listIterator(int var1);

    public ShortList subList(int var1, int var2);

    default public void setElements(short[] a) {
        this.setElements(0, a);
    }

    default public void setElements(int index2, short[] a) {
        this.setElements(index2, a, 0, a.length);
    }

    default public void setElements(int index2, short[] a, int offset2, int length) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than list size (" + this.size() + ")");
        }
        ShortArrays.ensureOffsetLength(a, offset2, length);
        if (index2 + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (index2 + length) + ") is greater than list size (" + this.size() + ")");
        }
        ShortListIterator iter = this.listIterator(index2);
        int i = 0;
        while (i < length) {
            iter.nextShort();
            iter.set(a[offset2 + i++]);
        }
    }

    @Override
    public boolean add(short var1);

    @Override
    public void add(int var1, short var2);

    @Override
    @Deprecated
    default public void add(int index2, Short key) {
        this.add(index2, (short)key);
    }

    @Override
    public short set(int var1, short var2);

    public short getShort(int var1);

    public int indexOf(short var1);

    public int lastIndexOf(short var1);

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        return ShortCollection.super.contains(key);
    }

    @Override
    @Deprecated
    default public Short get(int index2) {
        return this.getShort(index2);
    }

    @Override
    @Deprecated
    default public int indexOf(Object o) {
        return this.indexOf((Short)o);
    }

    @Override
    @Deprecated
    default public int lastIndexOf(Object o) {
        return this.lastIndexOf((Short)o);
    }

    @Override
    @Deprecated
    default public boolean add(Short k) {
        return this.add((short)k);
    }

    public short removeShort(int var1);

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        return ShortCollection.super.remove(key);
    }

    @Override
    @Deprecated
    default public Short remove(int index2) {
        return this.removeShort(index2);
    }

    @Override
    @Deprecated
    default public Short set(int index2, Short k) {
        return this.set(index2, (short)k);
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super Short> comparator) {
        this.sort(ShortComparators.asShortComparator(comparator));
    }

    default public void sort(ShortComparator comparator) {
        if (comparator == null) {
            this.unstableSort(comparator);
        } else {
            short[] elements = this.toShortArray();
            ShortArrays.stableSort(elements, comparator);
            this.setElements(elements);
        }
    }

    default public void unstableSort(ShortComparator comparator) {
        short[] elements = this.toShortArray();
        if (comparator == null) {
            ShortArrays.unstableSort(elements);
        } else {
            ShortArrays.unstableSort(elements, comparator);
        }
        this.setElements(elements);
    }
}

