/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.inline.FunctionInlineMutator;
import org.jetbrains.kotlin.js.inline.ImportIntoFragmentInliningScope;
import org.jetbrains.kotlin.js.inline.ImportIntoWrapperInliningScope;
import org.jetbrains.kotlin.js.inline.InlineAstVisitor;
import org.jetbrains.kotlin.js.inline.InlineFunctionDefinition;
import org.jetbrains.kotlin.js.inline.InlineableResult;
import org.jetbrains.kotlin.js.inline.InlinerCycleReporter;
import org.jetbrains.kotlin.js.inline.InliningScope;
import org.jetbrains.kotlin.js.inline.context.FunctionDefinitionLoader;
import org.jetbrains.kotlin.js.inline.context.InliningContext;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.translate.general.AstGenerationResult;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&J\u0006\u0010'\u001a\u00020(J(\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\"R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/js/inline/JsInliner;", "", "reporter", "Lorg/jetbrains/kotlin/js/config/JsConfig$Reporter;", "config", "Lorg/jetbrains/kotlin/js/config/JsConfig;", "trace", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "translationResult", "Lorg/jetbrains/kotlin/js/translate/general/AstGenerationResult;", "(Lorg/jetbrains/kotlin/js/config/JsConfig$Reporter;Lorg/jetbrains/kotlin/js/config/JsConfig;Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/js/translate/general/AstGenerationResult;)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "getConfig", "()Lorg/jetbrains/kotlin/js/config/JsConfig;", "cycleReporter", "Lorg/jetbrains/kotlin/js/inline/InlinerCycleReporter;", "getCycleReporter", "()Lorg/jetbrains/kotlin/js/inline/InlinerCycleReporter;", "functionDefinitionLoader", "Lorg/jetbrains/kotlin/js/inline/context/FunctionDefinitionLoader;", "getFunctionDefinitionLoader", "()Lorg/jetbrains/kotlin/js/inline/context/FunctionDefinitionLoader;", "getReporter", "()Lorg/jetbrains/kotlin/js/config/JsConfig$Reporter;", "getTrace", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "getTranslationResult", "()Lorg/jetbrains/kotlin/js/translate/general/AstGenerationResult;", "inline", "Lorg/jetbrains/kotlin/js/inline/InlineableResult;", "scope", "Lorg/jetbrains/kotlin/js/inline/InliningScope;", "call", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "currentStatement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "process", "", "inlineFn", "Lorg/jetbrains/kotlin/js/inline/InlineFunctionDefinition;", "definitionFragment", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgramFragment;", "callsiteScope", "js.translator"})
public final class JsInliner {
    @NotNull
    private final JsConfig.Reporter reporter;
    @NotNull
    private final JsConfig config;
    @NotNull
    private final DiagnosticSink trace;
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final AstGenerationResult translationResult;
    @NotNull
    private final FunctionDefinitionLoader functionDefinitionLoader;
    @NotNull
    private final InlinerCycleReporter cycleReporter;

    public JsInliner(@NotNull JsConfig.Reporter reporter, @NotNull JsConfig config, @NotNull DiagnosticSink trace, @NotNull BindingContext bindingContext, @NotNull AstGenerationResult translationResult) {
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)translationResult, (String)"translationResult");
        this.reporter = reporter;
        this.config = config;
        this.trace = trace;
        this.bindingContext = bindingContext;
        this.translationResult = translationResult;
        this.functionDefinitionLoader = new FunctionDefinitionLoader(this);
        this.cycleReporter = new InlinerCycleReporter(this.trace, this.functionDefinitionLoader);
    }

    @NotNull
    public final JsConfig.Reporter getReporter() {
        return this.reporter;
    }

    @NotNull
    public final JsConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final DiagnosticSink getTrace() {
        return this.trace;
    }

    @NotNull
    public final BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @NotNull
    public final AstGenerationResult getTranslationResult() {
        return this.translationResult;
    }

    @NotNull
    public final FunctionDefinitionLoader getFunctionDefinitionLoader() {
        return this.functionDefinitionLoader;
    }

    @NotNull
    public final InlinerCycleReporter getCycleReporter() {
        return this.cycleReporter;
    }

    public final void process() {
        for (JsProgramFragment fragment : this.translationResult.getNewFragments()) {
            ImportIntoFragmentInliningScope.Companion.process(fragment, (Function1<? super ImportIntoFragmentInliningScope, Unit>)((Function1)new Function1<ImportIntoFragmentInliningScope, Unit>(this){
                final /* synthetic */ JsInliner this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull ImportIntoFragmentInliningScope fragmentScope) {
                    Intrinsics.checkNotNullParameter((Object)fragmentScope, (String)"fragmentScope");
                    new InlineAstVisitor(this.this$0, fragmentScope).accept((JsNode)fragmentScope.getAllCode());
                }
            }));
        }
    }

    public final void process(@NotNull InlineFunctionDefinition inlineFn, @Nullable JsInvocation call2, @NotNull JsProgramFragment definitionFragment, @NotNull InliningScope callsiteScope) {
        Intrinsics.checkNotNullParameter((Object)inlineFn, (String)"inlineFn");
        Intrinsics.checkNotNullParameter((Object)definitionFragment, (String)"definitionFragment");
        Intrinsics.checkNotNullParameter((Object)callsiteScope, (String)"callsiteScope");
        if (!this.translationResult.getNewFragments().contains(definitionFragment)) {
            return;
        }
        this.cycleReporter.processInlineFunction(inlineFn.getFn(), call2, (Function0<Unit>)((Function0)new Function0<Unit>(inlineFn, definitionFragment, this, callsiteScope){
            final /* synthetic */ InlineFunctionDefinition $inlineFn;
            final /* synthetic */ JsProgramFragment $definitionFragment;
            final /* synthetic */ JsInliner this$0;
            final /* synthetic */ InliningScope $callsiteScope;
            {
                this.$inlineFn = $inlineFn;
                this.$definitionFragment = $definitionFragment;
                this.this$0 = $receiver;
                this.$callsiteScope = $callsiteScope;
                super(0);
            }

            public final void invoke() {
                FunctionWithWrapper functionWithWrapper = this.$inlineFn.getFn();
                JsFunction fn = functionWithWrapper.component1();
                JsBlock wrapperBody = functionWithWrapper.component2();
                if (wrapperBody != null) {
                    ImportIntoWrapperInliningScope.Companion.process(wrapperBody, this.$definitionFragment, (Function1<? super ImportIntoWrapperInliningScope, Unit>)((Function1)new Function1<ImportIntoWrapperInliningScope, Unit>(this.this$0, wrapperBody){
                        final /* synthetic */ JsInliner this$0;
                        final /* synthetic */ JsBlock $wrapperBody;
                        {
                            this.this$0 = $receiver;
                            this.$wrapperBody = $wrapperBody;
                            super(1);
                        }

                        public final void invoke(@NotNull ImportIntoWrapperInliningScope scope2) {
                            Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
                            new InlineAstVisitor(this.this$0, scope2).accept((JsNode)this.$wrapperBody);
                        }
                    }));
                } else {
                    new InlineAstVisitor(this.this$0, this.$callsiteScope).accept((JsNode)fn);
                }
            }
        }));
    }

    @NotNull
    public final InlineableResult inline(@NotNull InliningScope scope2, @NotNull JsInvocation call2, @Nullable JsStatement currentStatement) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        InlineFunctionDefinition definition = this.functionDefinitionLoader.getFunctionDefinition(call2, scope2);
        JsFunction function2 = scope2.importFunctionDefinition(definition);
        InliningContext inliningContext = new InliningContext(currentStatement);
        InlineableResult inlineableResult = FunctionInlineMutator.Companion.getInlineableCallReplacement(call2, function2, inliningContext);
        JsStatement inlineableBody = inlineableResult.component1();
        JsExpression resultExpression = inlineableResult.component2();
        new InlineAstVisitor(this, scope2).accept((JsNode)inlineableBody);
        JsExpression jsExpression = resultExpression;
        if (jsExpression != null) {
            MetadataProperties.setSynthetic(jsExpression, true);
        }
        return new InlineableResult(new JsBlock(CollectionsKt.plus((Collection)inliningContext.getPreviousStatements(), (Object)inlineableBody)), resultExpression);
    }
}

